/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.test;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.impl.CatalogFactoryImpl;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.MockCatalogBuilder;
import org.geoserver.data.test.MockTestData;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.KeyStoreProvider;
import org.geoserver.security.MasterPasswordProvider;
import org.geoserver.security.SecurityUtils;
import org.geoserver.security.config.PasswordPolicyConfig;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.SecurityInterceptorFilterConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.filter.GeoServerAnonymousAuthenticationFilter;
import org.geoserver.security.filter.GeoServerBasicAuthenticationFilter;
import org.geoserver.security.filter.GeoServerRoleFilter;
import org.geoserver.security.filter.GeoServerUserNamePasswordAuthenticationFilter;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.password.GeoServerDigestPasswordEncoder;
import org.geoserver.security.password.GeoServerEmptyPasswordEncoder;
import org.geoserver.security.password.GeoServerPBEPasswordEncoder;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.password.GeoServerPlainTextPasswordEncoder;
import org.geoserver.security.password.PasswordValidator;
import org.geoserver.security.validation.PasswordValidatorImpl;
import org.geoserver.security.xml.XMLRoleService;
import org.geoserver.security.xml.XMLUserGroupService;
import org.springframework.context.ApplicationContext;

public class MockCreator
implements MockCatalogBuilder.Callback {
    public GeoServerResourceLoader createResourceLoader(MockTestData testData) throws Exception {
        File data = testData.getDataDirectoryRoot();
        GeoServerResourceLoader loader = new GeoServerResourceLoader(data);
        GeoServerExtensionsHelper.singleton("resourceLoader", loader, new Class[0]);
        return loader;
    }

    public Catalog createCatalog(MockTestData testData) throws Exception {
        GeoServerResourceLoader loader = this.createResourceLoader(testData);
        final Catalog catalog = (Catalog)EasyMock.createMock(Catalog.class);
        EasyMock.expect((Object)catalog.getFactory()).andReturn((Object)new CatalogFactoryImpl(catalog)).anyTimes();
        EasyMock.expect((Object)catalog.getResourceLoader()).andReturn((Object)loader).anyTimes();
        catalog.removeListeners((Class)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        catalog.addListener((CatalogListener)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)catalog.getResourcePool()).andAnswer((IAnswer)new IAnswer<ResourcePool>(){

            public ResourcePool answer() throws Throwable {
                return ResourcePool.create((Catalog)catalog);
            }
        }).anyTimes();
        MockCatalogBuilder b = new MockCatalogBuilder(catalog, loader.getBaseDirectory());
        b.setCallback(this);
        b.style(CiteTestData.DEFAULT_VECTOR_STYLE);
        b.style("generic");
        this.createWorkspace(CiteTestData.DEFAULT_PREFIX, CiteTestData.DEFAULT_URI, null, b);
        this.createWorkspace(CiteTestData.CGF_PREFIX, CiteTestData.CGF_URI, CiteTestData.CGF_TYPENAMES, b);
        this.createWorkspace(CiteTestData.CDF_PREFIX, CiteTestData.CDF_URI, CiteTestData.CDF_TYPENAMES, b);
        this.createWorkspace(CiteTestData.SF_PREFIX, CiteTestData.SF_URI, CiteTestData.SF_TYPENAMES, b);
        this.createWorkspace(CiteTestData.CITE_PREFIX, CiteTestData.CITE_URI, CiteTestData.CITE_TYPENAMES, b);
        if (testData.isInludeRaster()) {
            b.style(CiteTestData.DEFAULT_RASTER_STYLE);
            this.createWorkspace(CiteTestData.WCS_PREFIX, CiteTestData.WCS_URI, null, CiteTestData.WCS_TYPENAMES, b);
        }
        this.addToCatalog(catalog, b);
        b.commit();
        return catalog;
    }

    protected void addToCatalog(Catalog catalog, MockCatalogBuilder b) {
    }

    void createWorkspace(String wsName, String nsURI, QName[] typeNames, MockCatalogBuilder b) {
        this.createWorkspace(wsName, nsURI, typeNames, null, b);
    }

    void createWorkspace(String wsName, String nsURI, QName[] ftTypeNames, QName[] covTypeNames, MockCatalogBuilder b) {
        String local;
        b.workspace(wsName, nsURI);
        if (ftTypeNames != null && ftTypeNames.length > 0) {
            b.dataStore(wsName);
            for (QName typeName : ftTypeNames) {
                local = typeName.getLocalPart();
                b.style(local);
                b.featureType(local);
            }
            b.commit().commit();
        }
        if (covTypeNames != null && covTypeNames.length > 0) {
            for (QName typeName : covTypeNames) {
                local = typeName.getLocalPart();
                String[] fileNameAndFormat = CiteTestData.COVERAGES.get(typeName);
                b.coverageStore(local, fileNameAndFormat[0], fileNameAndFormat[1]);
                b.coverage(typeName, fileNameAndFormat[0], null, null);
                b.commit();
            }
            b.commit();
        }
    }

    @Override
    public void onWorkspace(String name, WorkspaceInfo ws, MockCatalogBuilder b) {
    }

    @Override
    public void onStore(String name, StoreInfo st, WorkspaceInfo ws, MockCatalogBuilder b) {
    }

    @Override
    public void onResource(String name, ResourceInfo r, StoreInfo s, MockCatalogBuilder b) {
    }

    @Override
    public void onLayer(String name, LayerInfo l, MockCatalogBuilder b) {
    }

    @Override
    public void onStyle(String name, StyleInfo s, MockCatalogBuilder b) {
    }

    @Override
    public void onLayerGroup(String name, LayerGroupInfo lg, MockCatalogBuilder b) {
    }

    public GeoServerSecurityManager createSecurityManager(MockTestData testData) throws Exception {
        final GeoServerSecurityManager secMgr = (GeoServerSecurityManager)EasyMock.createNiceMock(GeoServerSecurityManager.class);
        ApplicationContext appContext = (ApplicationContext)EasyMock.createNiceMock(ApplicationContext.class);
        EasyMock.expect((Object)secMgr.getApplicationContext()).andReturn((Object)appContext).anyTimes();
        MasterPasswordProvider masterPasswdProvider = (MasterPasswordProvider)EasyMock.createNiceMock(MasterPasswordProvider.class);
        EasyMock.expect((Object)masterPasswdProvider.getName()).andReturn((Object)MasterPasswordProvider.DEFAULT_NAME).anyTimes();
        EasyMock.expect((Object)secMgr.listMasterPasswordProviders()).andReturn(new TreeSet<String>(Arrays.asList(MasterPasswordProvider.DEFAULT_NAME))).anyTimes();
        File mrPwdFolder = new File(testData.getDataDirectoryRoot(), "master-pwd");
        EasyMock.expect((Object)secMgr.masterPasswordProvider()).andReturn((Object)Files.asResource((File)mrPwdFolder)).anyTimes();
        PasswordValidator passwdValidator = (PasswordValidator)EasyMock.createNiceMock(PasswordValidator.class);
        EasyMock.expect((Object)secMgr.loadPasswordValidator("default")).andReturn((Object)passwdValidator).anyTimes();
        PasswordPolicyConfig masterPasswdPolicyConfig = (PasswordPolicyConfig)EasyMock.createNiceMock(PasswordPolicyConfig.class);
        EasyMock.expect((Object)masterPasswdPolicyConfig.getMinLength()).andReturn((Object)8).anyTimes();
        EasyMock.expect((Object)masterPasswdPolicyConfig.getMaxLength()).andReturn((Object)-1).anyTimes();
        PasswordValidatorImpl masterPasswdValidator = new PasswordValidatorImpl(secMgr);
        masterPasswdValidator.setConfig(masterPasswdPolicyConfig);
        EasyMock.expect((Object)secMgr.loadPasswordValidator("master")).andReturn((Object)masterPasswdValidator).anyTimes();
        EasyMock.expect((Object)secMgr.listPasswordValidators()).andReturn(new TreeSet<String>(Arrays.asList("default", "master"))).anyTimes();
        GeoServerUserGroupStore ugStore = this.createUserGroupStore(XMLUserGroupService.DEFAULT_NAME, secMgr);
        EasyMock.expect((Object)secMgr.listUserGroupServices()).andReturn(new TreeSet<String>(Arrays.asList(XMLUserGroupService.DEFAULT_NAME))).anyTimes();
        SecurityUserGroupServiceConfig ugConfig = (SecurityUserGroupServiceConfig)EasyMock.createNiceMock(SecurityUserGroupServiceConfig.class);
        EasyMock.expect((Object)ugConfig.getName()).andReturn((Object)XMLUserGroupService.DEFAULT_NAME).anyTimes();
        EasyMock.expect((Object)ugConfig.getPasswordPolicyName()).andReturn((Object)"default").anyTimes();
        EasyMock.expect((Object)secMgr.loadUserGroupServiceConfig(XMLUserGroupService.DEFAULT_NAME)).andReturn((Object)ugConfig).anyTimes();
        GeoServerRoleStore roleStore = this.createRoleStore(XMLRoleService.DEFAULT_NAME, secMgr, new String[0]);
        EasyMock.expect((Object)secMgr.listRoleServices()).andReturn(new TreeSet<String>(Arrays.asList(XMLRoleService.DEFAULT_NAME))).anyTimes();
        EasyMock.expect((Object)secMgr.getActiveRoleService()).andReturn((Object)roleStore).anyTimes();
        SecurityAuthProviderConfig authProviderConfig = (SecurityAuthProviderConfig)EasyMock.createNiceMock(SecurityAuthProviderConfig.class);
        EasyMock.expect((Object)authProviderConfig.getName()).andReturn((Object)GeoServerAuthenticationProvider.DEFAULT_NAME).anyTimes();
        EasyMock.expect((Object)authProviderConfig.getUserGroupServiceName()).andReturn((Object)XMLUserGroupService.DEFAULT_NAME).anyTimes();
        EasyMock.expect((Object)secMgr.loadAuthenticationProviderConfig(GeoServerAuthenticationProvider.DEFAULT_NAME)).andReturn((Object)authProviderConfig).anyTimes();
        GeoServerAuthenticationProvider authProvider = (GeoServerAuthenticationProvider)EasyMock.createNiceMock(GeoServerAuthenticationProvider.class);
        EasyMock.expect((Object)authProvider.getName()).andReturn((Object)GeoServerAuthenticationProvider.DEFAULT_NAME).anyTimes();
        EasyMock.expect((Object)secMgr.loadAuthenticationProvider(GeoServerAuthenticationProvider.DEFAULT_NAME)).andReturn((Object)authProvider).anyTimes();
        EasyMock.expect((Object)secMgr.listAuthenticationProviders()).andReturn(new TreeSet<String>(Arrays.asList(GeoServerAuthenticationProvider.DEFAULT_NAME))).anyTimes();
        EasyMock.expect((Object)secMgr.getAuthenticationProviders()).andReturn(Arrays.asList(authProvider)).anyTimes();
        SecurityInterceptorFilterConfig filterConfig = (SecurityInterceptorFilterConfig)EasyMock.createNiceMock(SecurityInterceptorFilterConfig.class);
        EasyMock.expect((Object)secMgr.loadFilterConfig("interceptor")).andReturn((Object)filterConfig).anyTimes();
        GeoServerAnonymousAuthenticationFilter authFilter = (GeoServerAnonymousAuthenticationFilter)EasyMock.createNiceMock(GeoServerAnonymousAuthenticationFilter.class);
        EasyMock.expect((Object)authFilter.applicableForServices()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)authFilter.applicableForHtml()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)secMgr.loadFilter("anonymous")).andReturn((Object)authFilter).anyTimes();
        GeoServerRoleFilter roleFilter = (GeoServerRoleFilter)EasyMock.createNiceMock(GeoServerRoleFilter.class);
        EasyMock.expect((Object)secMgr.loadFilter("roleFilter")).andReturn((Object)roleFilter).anyTimes();
        GeoServerUserNamePasswordAuthenticationFilter formFilter = (GeoServerUserNamePasswordAuthenticationFilter)EasyMock.createNiceMock(GeoServerUserNamePasswordAuthenticationFilter.class);
        EasyMock.expect((Object)formFilter.applicableForHtml()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)secMgr.loadFilter("form")).andReturn((Object)formFilter).anyTimes();
        GeoServerBasicAuthenticationFilter basicFilter = (GeoServerBasicAuthenticationFilter)EasyMock.createNiceMock(GeoServerBasicAuthenticationFilter.class);
        EasyMock.expect((Object)basicFilter.applicableForServices()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)secMgr.loadFilter("basic")).andReturn((Object)basicFilter).anyTimes();
        EasyMock.expect((Object)((GeoServerEmptyPasswordEncoder)secMgr.loadPasswordEncoder(GeoServerEmptyPasswordEncoder.class))).andAnswer((IAnswer)new IAnswer<GeoServerEmptyPasswordEncoder>(){

            public GeoServerEmptyPasswordEncoder answer() throws Throwable {
                return MockCreator.this.createEmptyPasswordEncoder(secMgr);
            }
        }).anyTimes();
        EasyMock.expect((Object)secMgr.loadPasswordEncoder("emptyPasswordEncoder")).andAnswer((IAnswer)new IAnswer<GeoServerPasswordEncoder>(){

            public GeoServerPasswordEncoder answer() throws Throwable {
                return MockCreator.this.createEmptyPasswordEncoder(secMgr);
            }
        }).anyTimes();
        EasyMock.expect((Object)((GeoServerPlainTextPasswordEncoder)secMgr.loadPasswordEncoder(GeoServerPlainTextPasswordEncoder.class))).andAnswer((IAnswer)new IAnswer<GeoServerPlainTextPasswordEncoder>(){

            public GeoServerPlainTextPasswordEncoder answer() throws Throwable {
                return MockCreator.this.createPlainTextPasswordEncoder(secMgr);
            }
        }).anyTimes();
        EasyMock.expect((Object)secMgr.loadPasswordEncoder("plainTextPasswordEncoder")).andAnswer((IAnswer)new IAnswer<GeoServerPasswordEncoder>(){

            public GeoServerPasswordEncoder answer() throws Throwable {
                return MockCreator.this.createPlainTextPasswordEncoder(secMgr);
            }
        }).anyTimes();
        EasyMock.expect((Object)((GeoServerPBEPasswordEncoder)secMgr.loadPasswordEncoder(GeoServerPBEPasswordEncoder.class, null, Boolean.valueOf(false)))).andAnswer((IAnswer)new IAnswer<GeoServerPBEPasswordEncoder>(){

            public GeoServerPBEPasswordEncoder answer() throws Throwable {
                return MockCreator.this.createPbePasswordEncoder(secMgr);
            }
        }).anyTimes();
        EasyMock.expect((Object)secMgr.loadPasswordEncoder("pbePasswordEncoder")).andAnswer((IAnswer)new IAnswer<GeoServerPasswordEncoder>(){

            public GeoServerPasswordEncoder answer() throws Throwable {
                return MockCreator.this.createPbePasswordEncoder(secMgr);
            }
        }).anyTimes();
        EasyMock.expect((Object)((GeoServerPBEPasswordEncoder)secMgr.loadPasswordEncoder(GeoServerPBEPasswordEncoder.class, null, Boolean.valueOf(true)))).andAnswer((IAnswer)new IAnswer<GeoServerPBEPasswordEncoder>(){

            public GeoServerPBEPasswordEncoder answer() throws Throwable {
                return MockCreator.this.createStrongPbePasswordEncoder(secMgr);
            }
        }).anyTimes();
        EasyMock.expect((Object)secMgr.loadPasswordEncoder("strongPbePasswordEncoder")).andAnswer((IAnswer)new IAnswer<GeoServerPasswordEncoder>(){

            public GeoServerPasswordEncoder answer() throws Throwable {
                return MockCreator.this.createStrongPbePasswordEncoder(secMgr);
            }
        }).anyTimes();
        EasyMock.expect((Object)((GeoServerDigestPasswordEncoder)secMgr.loadPasswordEncoder(GeoServerDigestPasswordEncoder.class, null, Boolean.valueOf(true)))).andAnswer((IAnswer)new IAnswer<GeoServerDigestPasswordEncoder>(){

            public GeoServerDigestPasswordEncoder answer() throws Throwable {
                return MockCreator.this.createDigestPasswordEncoder(secMgr);
            }
        }).anyTimes();
        EasyMock.expect((Object)((GeoServerDigestPasswordEncoder)secMgr.loadPasswordEncoder(GeoServerDigestPasswordEncoder.class))).andAnswer((IAnswer)new IAnswer<GeoServerDigestPasswordEncoder>(){

            public GeoServerDigestPasswordEncoder answer() throws Throwable {
                return MockCreator.this.createDigestPasswordEncoder(secMgr);
            }
        }).anyTimes();
        EasyMock.expect((Object)secMgr.loadPasswordEncoder("digestPasswordEncoder")).andAnswer((IAnswer)new IAnswer<GeoServerPasswordEncoder>(){

            public GeoServerPasswordEncoder answer() throws Throwable {
                return MockCreator.this.createDigestPasswordEncoder(secMgr);
            }
        }).anyTimes();
        EasyMock.expect((Object)secMgr.loadPasswordEncoders()).andAnswer((IAnswer)new IAnswer<List<GeoServerPasswordEncoder>>(){

            public List<GeoServerPasswordEncoder> answer() throws Throwable {
                return Arrays.asList(MockCreator.this.createEmptyPasswordEncoder(secMgr), MockCreator.this.createPlainTextPasswordEncoder(secMgr), MockCreator.this.createPbePasswordEncoder(secMgr), MockCreator.this.createStrongPbePasswordEncoder(secMgr), MockCreator.this.createDigestPasswordEncoder(secMgr));
            }
        }).anyTimes();
        KeyStoreProvider keyStoreProvider = (KeyStoreProvider)EasyMock.createNiceMock(KeyStoreProvider.class);
        EasyMock.expect((Object)keyStoreProvider.isKeyStorePassword(EasyMock.aryEq((char[])"geoserver".toCharArray()))).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)keyStoreProvider.containsAlias("config:password:key")).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)keyStoreProvider.getSecretKey("config:password:key")).andReturn((Object)new SecretKeySpec(SecurityUtils.toBytes((char[])"geoserver".toCharArray()), "PBE")).anyTimes();
        EasyMock.expect((Object)keyStoreProvider.hasUserGroupKey(XMLUserGroupService.DEFAULT_NAME)).andReturn((Object)true).anyTimes();
        String alias = "ugServiceAlias";
        EasyMock.expect((Object)keyStoreProvider.aliasForGroupService(XMLUserGroupService.DEFAULT_NAME)).andReturn((Object)alias).anyTimes();
        EasyMock.expect((Object)keyStoreProvider.containsAlias(alias)).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)keyStoreProvider.getSecretKey(alias)).andReturn((Object)new SecretKeySpec(SecurityUtils.toBytes((char[])"geoserver".toCharArray()), "PBE")).anyTimes();
        EasyMock.expect((Object)secMgr.getKeyStoreProvider()).andReturn((Object)keyStoreProvider).anyTimes();
        EasyMock.replay((Object[])new Object[]{keyStoreProvider, masterPasswdProvider, ugStore, ugConfig, roleStore, authProvider, authProviderConfig, filterConfig, passwdValidator, masterPasswdPolicyConfig, appContext, secMgr, roleFilter, formFilter, authFilter, basicFilter});
        return secMgr;
    }

    protected GeoServerEmptyPasswordEncoder createEmptyPasswordEncoder(GeoServerSecurityManager secMgr) throws IOException {
        GeoServerEmptyPasswordEncoder emptyPwe = new GeoServerEmptyPasswordEncoder();
        emptyPwe.setBeanName("emptyPasswordEncoder");
        emptyPwe.setPrefix("empty");
        return emptyPwe;
    }

    protected GeoServerDigestPasswordEncoder createDigestPasswordEncoder(GeoServerSecurityManager secMgr) throws IOException {
        GeoServerDigestPasswordEncoder digestPwe = new GeoServerDigestPasswordEncoder();
        digestPwe.setBeanName("digestPasswordEncoder");
        digestPwe.setPrefix("digest1");
        return digestPwe;
    }

    protected GeoServerPBEPasswordEncoder createStrongPbePasswordEncoder(GeoServerSecurityManager secMgr) throws IOException {
        GeoServerPBEPasswordEncoder strongPbePwe = new GeoServerPBEPasswordEncoder();
        strongPbePwe.setBeanName("strongPbePasswordEncoder");
        strongPbePwe.setPrefix("crypt2");
        strongPbePwe.setProviderName("BC");
        strongPbePwe.setAvailableWithoutStrongCryptogaphy(false);
        strongPbePwe.initialize(secMgr);
        return strongPbePwe;
    }

    protected GeoServerPBEPasswordEncoder createPbePasswordEncoder(GeoServerSecurityManager secMgr) throws IOException {
        GeoServerPBEPasswordEncoder pbePwe = new GeoServerPBEPasswordEncoder();
        pbePwe.setBeanName("pbePasswordEncoder");
        pbePwe.setPrefix("crypt1");
        pbePwe.setAlgorithm("PBEWITHMD5ANDDES");
        pbePwe.initialize(secMgr);
        return pbePwe;
    }

    protected GeoServerPlainTextPasswordEncoder createPlainTextPasswordEncoder(GeoServerSecurityManager secMgr) throws IOException {
        GeoServerPlainTextPasswordEncoder plainPwe = new GeoServerPlainTextPasswordEncoder();
        plainPwe.setBeanName("plainTextPasswordEncoder");
        plainPwe.setPrefix("plain");
        plainPwe.initialize(secMgr);
        return plainPwe;
    }

    protected GeoServerUserGroupStore createUserGroupStore(String name, GeoServerSecurityManager secMgr) throws IOException {
        GeoServerUserGroupStore ugStore = (GeoServerUserGroupStore)EasyMock.createNiceMock(GeoServerUserGroupStore.class);
        EasyMock.expect((Object)ugStore.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)secMgr.loadUserGroupService(name)).andReturn((Object)ugStore).anyTimes();
        return ugStore;
    }

    protected void addUsers(GeoServerUserGroupStore ugStore, String ... up) throws IOException {
        for (int i = 0; i < up.length; i += 2) {
            GeoServerUser user = new GeoServerUser(up[i]);
            user.setPassword(up[i + 1]);
            EasyMock.expect((Object)ugStore.getUserByUsername(up[i])).andReturn((Object)user).anyTimes();
        }
    }

    protected void addGroups(GeoServerUserGroupStore ugStore, String ... groupNames) throws IOException {
        for (String groupName : groupNames) {
            GeoServerUserGroup grp = new GeoServerUserGroup(groupName);
            EasyMock.expect((Object)ugStore.getGroupByGroupname(groupName)).andReturn((Object)grp).anyTimes();
        }
    }

    protected GeoServerRoleStore createRoleStore(String name, GeoServerSecurityManager secMgr, String ... roleNames) throws IOException {
        GeoServerRoleStore roleStore = (GeoServerRoleStore)EasyMock.createNiceMock(GeoServerRoleStore.class);
        EasyMock.expect((Object)roleStore.getSecurityManager()).andReturn((Object)secMgr).anyTimes();
        EasyMock.expect((Object)roleStore.getName()).andReturn((Object)name).anyTimes();
        for (String string : roleNames) {
            EasyMock.expect((Object)roleStore.getRoleByName(string)).andReturn((Object)new GeoServerRole(string)).anyTimes();
        }
        for (String string : GeoServerRole.SystemRoles) {
            String roleName = string.getAuthority();
            EasyMock.expect((Object)roleStore.createRoleObject(roleName)).andReturn((Object)new GeoServerRole(roleName)).anyTimes();
        }
        EasyMock.expect((Object)secMgr.loadRoleService(name)).andReturn((Object)roleStore).anyTimes();
        return roleStore;
    }

    protected void addRolesToCreate(GeoServerRoleStore roleStore, String ... roleNames) throws IOException {
        for (String roleName : roleNames) {
            EasyMock.expect((Object)roleStore.createRoleObject(roleName)).andReturn((Object)new GeoServerRole(roleName)).anyTimes();
        }
    }
}

