/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.util;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geoserver.data.util.CoverageUtils;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

public class CoverageUtilsTest {
    @Test
    public void testGetOutputTransparentColor() {
        ParameterDescriptor pdescriptor = ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR;
        ParameterValue pvalue = pdescriptor.createValue();
        String key = pdescriptor.getName().getCode();
        Map<String, String> values = Collections.singletonMap(key, "0xFFFFFF");
        Object value = CoverageUtils.getCvParamValue((String)key, (ParameterValue)pvalue, values);
        Assert.assertTrue((boolean)(value instanceof Color));
        Assert.assertEquals((Object)Color.WHITE, (Object)value);
    }

    @Test
    public void testMaxTiles() {
        ParameterDescriptor pdescriptor = ImageMosaicFormat.MAX_ALLOWED_TILES;
        ParameterValue pvalue = pdescriptor.createValue();
        String key = pdescriptor.getName().getCode();
        Map<String, String> values = Collections.singletonMap(key, "1");
        Object value = CoverageUtils.getCvParamValue((String)key, (ParameterValue)pvalue, values);
        Assert.assertTrue((boolean)(value instanceof Integer));
        Assert.assertEquals((Object)1, (Object)value);
    }

    @Test
    public void testMergeExisting() throws CQLException {
        List descriptors = new ImageMosaicFormat().getReadParameters().getDescriptor().descriptors();
        GeneralParameterValue[] oldParams = new GeneralParameterValue[]{ImageMosaicFormat.FILTER.createValue()};
        Filter filter = CQL.toFilter((String)"a = 6");
        GeneralParameterValue[] newParams = CoverageUtils.mergeParameter((List)descriptors, (GeneralParameterValue[])oldParams, (Object)filter, (String[])new String[]{ImageMosaicFormat.FILTER.getName().getCode()});
        Assert.assertEquals((long)1L, (long)newParams.length);
        Assert.assertEquals((Object)filter, (Object)((ParameterValue)newParams[0]).getValue());
    }
}

