/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import java.util.ArrayList;
import java.util.Arrays;
import org.geoserver.feature.CompositeFeatureCollection;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;

public class CompositeFeatureCollectionTest
extends DataTestCase {
    public CompositeFeatureCollectionTest(String name) {
        super(name);
    }

    public void testCompositeEmpty() {
        CompositeFeatureCollection fc = new CompositeFeatureCollection(new ArrayList());
        CompositeFeatureCollectionTest.assertEquals((int)0, (int)fc.size());
        CompositeFeatureCollectionTest.assertEquals(null, (Object)fc.getBounds());
        CompositeFeatureCollectionTest.assertEquals(null, (Object)DataUtilities.first((FeatureCollection)fc));
    }

    public void testComposeOne() {
        CompositeFeatureCollection fc = new CompositeFeatureCollection(Arrays.asList(DataUtilities.collection((SimpleFeature)this.riverFeatures[0])));
        CompositeFeatureCollectionTest.assertEquals((int)1, (int)fc.size());
        CompositeFeatureCollectionTest.assertEquals((Object)new ReferencedEnvelope(5.0, 13.0, 3.0, 7.0, this.riverType.getCoordinateReferenceSystem()), (Object)fc.getBounds());
        CompositeFeatureCollectionTest.assertEquals((Object)this.riverFeatures[0], (Object)DataUtilities.first((FeatureCollection)fc));
    }

    public void testComposeMany() {
        SimpleFeatureCollection roads = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        SimpleFeatureCollection rivers = DataUtilities.collection((SimpleFeature[])this.riverFeatures);
        SimpleFeatureCollection lakes = DataUtilities.collection((SimpleFeature[])this.lakeFeatures);
        CompositeFeatureCollection fc = new CompositeFeatureCollection(Arrays.asList(roads, rivers, lakes));
        CompositeFeatureCollectionTest.assertEquals((int)6, (int)fc.size());
        CompositeFeatureCollectionTest.assertEquals((Object)new ReferencedEnvelope(1.0, 16.0, 0.0, 10.0, this.riverType.getCoordinateReferenceSystem()), (Object)fc.getBounds());
        CompositeFeatureCollectionTest.assertEquals((Object)this.roadFeatures[0], (Object)DataUtilities.first((FeatureCollection)fc));
    }
}

