/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import org.geoserver.feature.ReprojectingFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;

public class ReprojectingFeatureCollectionTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPerserveUserData() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("foo");
        tb.setSRS("epsg:4326");
        tb.add("geom", Point.class);
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(tb.buildFeatureType());
        b.add((Object)new WKTReader().read("POINT(1 1)"));
        SimpleFeature f = b.buildFeature(null);
        f.getUserData().put("foo", "bar");
        DefaultFeatureCollection features = new DefaultFeatureCollection(null, b.getFeatureType());
        features.add(f);
        try (SimpleFeatureIterator it = features.features();){
            Assert.assertEquals((Object)"bar", it.next().getUserData().get("foo"));
        }
        ReprojectingFeatureCollection reprojected = new ReprojectingFeatureCollection((SimpleFeatureCollection)features, CRS.decode((String)"EPSG:3005"));
        it = reprojected.features();
        try {
            Assert.assertEquals((Object)"bar", it.next().getUserData().get("foo"));
        }
        finally {
            it.close();
        }
    }
}

