/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import java.io.IOException;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.util.ProgressListener;

public class RetypingFeatureCollectionTest {
    FeatureVisitor lastVisitor = null;
    private ListFeatureCollection collection;
    private SimpleFeatureType renamedSchema;

    @Before
    public void setup() throws SchemaException {
        SimpleFeatureType originalSchema = DataUtilities.createType((String)"BasicPolygons", (String)"the_geom:MultiPolygon:srid=4326,ID:String,value:int");
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init(originalSchema);
        tb.setName("BasicPolygons2");
        this.renamedSchema = tb.buildFeatureType();
        this.collection = new ListFeatureCollection(originalSchema){

            public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
                RetypingFeatureCollectionTest.this.lastVisitor = visitor;
            }
        };
    }

    @Test
    public void testMaxVisitorDelegation() throws SchemaException, IOException {
        MaxVisitor visitor = new MaxVisitor((Expression)CommonFactoryFinder.getFilterFactory2().property("value"));
        this.assertOptimalVisit((FeatureVisitor)visitor);
    }

    @Test
    public void testCountVisitorDelegation() throws SchemaException, IOException {
        CountVisitor visitor = new CountVisitor();
        this.assertOptimalVisit((FeatureVisitor)visitor);
    }

    private void assertOptimalVisit(FeatureVisitor visitor) throws IOException {
        RetypingFeatureCollection retypedCollection = new RetypingFeatureCollection((SimpleFeatureCollection)this.collection, this.renamedSchema);
        retypedCollection.accepts(visitor, null);
        Assert.assertSame((Object)this.lastVisitor, (Object)visitor);
    }

    @Test
    public void testSubCollectionRetyping() {
        RetypingFeatureCollection retypedCollection = new RetypingFeatureCollection((SimpleFeatureCollection)this.collection, this.renamedSchema);
        SimpleFeatureCollection subCollection = retypedCollection.subCollection((Filter)Filter.INCLUDE);
        Assert.assertSame((Object)this.renamedSchema, (Object)subCollection.getSchema());
    }
}

