/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature.retype;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.easymock.EasyMock;
import org.geoserver.data.test.MockData;
import org.geoserver.feature.retype.RetypingDataStore;
import org.geoserver.util.IOUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;

public class FullyRetypingDataStoreTest {
    SimpleFeatureType primitive;
    static final String RENAMED = "primitive";
    RetypingDataStore rts;
    private File data;
    private Id fidFilter;
    private String fid;

    @Before
    public void setUp() throws Exception {
        this.data = File.createTempFile("retype", "data", new File("./target"));
        this.data.delete();
        this.data.mkdir();
        String fileName = MockData.PRIMITIVEGEOFEATURE.getLocalPart() + ".properties";
        URL properties = MockData.class.getResource(fileName);
        IOUtils.copy((InputStream)properties.openStream(), (File)new File(this.data, fileName));
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.add("description", String.class);
        ftb.add("pointProperty", MultiPoint.class);
        ftb.add("intProperty", Long.class);
        ftb.add("dateTimeProperty", Date.class);
        ftb.add("newProperty", String.class);
        ftb.setName(RENAMED);
        this.primitive = ftb.buildFeatureType();
        PropertyDataStore pds = new PropertyDataStore(this.data);
        this.rts = new RetypingDataStore((DataStore)pds){

            protected SimpleFeatureType transformFeatureType(SimpleFeatureType original) throws IOException {
                if (original.getTypeName().equals(MockData.PRIMITIVEGEOFEATURE.getLocalPart())) {
                    return FullyRetypingDataStoreTest.this.primitive;
                }
                return super.transformFeatureType(original);
            }

            protected String transformFeatureTypeName(String originalName) {
                if (originalName.equals(MockData.PRIMITIVEGEOFEATURE.getLocalPart())) {
                    return FullyRetypingDataStoreTest.this.primitive.getTypeName();
                }
                return super.transformFeatureTypeName(originalName);
            }
        };
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        this.fid = "primitive.f001";
        this.fidFilter = ff.id(Collections.singleton(ff.featureId(this.fid)));
    }

    @After
    public void tearDown() throws Exception {
        IOUtils.delete((File)this.data);
    }

    @Test
    public void testLookupFeatureType() throws Exception {
        try {
            this.rts.getSchema(MockData.GENERICENTITY.getLocalPart());
            Assert.fail((String)"The original type name should not be visible");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SimpleFeatureType schema = this.rts.getSchema(RENAMED);
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((Object)this.primitive, (Object)schema);
    }

    @Test
    public void testGetFeaturesFeatureSource() throws Exception {
        SimpleFeatureSource fs = this.rts.getFeatureSource(RENAMED);
        Assert.assertEquals((Object)this.primitive, (Object)fs.getSchema());
        SimpleFeatureCollection fc = fs.getFeatures();
        Assert.assertEquals((Object)this.primitive, (Object)fc.getSchema());
        Assert.assertTrue((fc.size() > 0 ? 1 : 0) != 0);
        SimpleFeatureIterator it = fc.features();
        SimpleFeature sf = (SimpleFeature)it.next();
        it.close();
        Assert.assertEquals((Object)this.primitive, (Object)sf.getFeatureType());
        Assert.assertTrue((String)("Feature id has not been renamed, it's still " + sf.getID()), (boolean)sf.getID().startsWith(RENAMED));
        Assert.assertEquals((Object)"description-f001", (Object)sf.getAttribute("description"));
        Assert.assertTrue((boolean)new WKTReader().read("MULTIPOINT(39.73245 2.00342)").equalsExact((Geometry)sf.getAttribute("pointProperty")));
        Assert.assertEquals((Object)155L, (Object)sf.getAttribute("intProperty"));
        Assert.assertNull((Object)sf.getAttribute("newProperty"));
    }

    @Test
    public void testGetFeaturesReader() throws Exception {
        FeatureReader fr = this.rts.getFeatureReader(new Query(RENAMED), Transaction.AUTO_COMMIT);
        SimpleFeature sf = (SimpleFeature)fr.next();
        fr.close();
        Assert.assertEquals((Object)this.primitive, (Object)sf.getFeatureType());
        Assert.assertTrue((String)("Feature id has not been renamed, it's still " + sf.getID()), (boolean)sf.getID().startsWith(RENAMED));
    }

    @Test
    public void testFeautureSourceFidFilter() throws Exception {
        SimpleFeatureSource fs = this.rts.getFeatureSource(RENAMED);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        String fid = "primitive.f001";
        Id fidFilter = ff.id(Collections.singleton(ff.featureId("primitive.f001")));
        SimpleFeatureCollection fc = fs.getFeatures(new Query(RENAMED, (Filter)fidFilter));
        Assert.assertEquals((Object)RENAMED, (Object)((SimpleFeatureType)fc.getSchema()).getName().getLocalPart());
        Assert.assertEquals((long)1L, (long)fc.size());
        SimpleFeatureIterator it = fc.features();
        Assert.assertTrue((boolean)it.hasNext());
        SimpleFeature sf = (SimpleFeature)it.next();
        Assert.assertFalse((boolean)it.hasNext());
        it.close();
        Assert.assertEquals((Object)"primitive.f001", (Object)sf.getID());
    }

    @Test
    public void testFeatureReaderFidFilter() throws Exception {
        FeatureReader fr = this.rts.getFeatureReader(new Query(RENAMED, (Filter)this.fidFilter), Transaction.AUTO_COMMIT);
        Assert.assertEquals((Object)this.primitive, (Object)fr.getFeatureType());
        Assert.assertTrue((boolean)fr.hasNext());
        SimpleFeature sf = (SimpleFeature)fr.next();
        Assert.assertFalse((boolean)fr.hasNext());
        fr.close();
        Assert.assertEquals((Object)this.fid, (Object)sf.getID());
    }

    @Test
    public void testDelete() throws Exception {
        Query queryAll = new Query(RENAMED);
        SimpleFeatureStore store = (SimpleFeatureStore)this.rts.getFeatureSource(RENAMED);
        int count = store.getCount(queryAll);
        store.removeFeatures((Filter)this.fidFilter);
        Assert.assertEquals((long)(count - 1), (long)store.getCount(queryAll));
    }

    @Test
    public void testModify() throws Exception {
        Query queryAll = new Query(RENAMED);
        SimpleFeatureStore store = (SimpleFeatureStore)this.rts.getFeatureSource(RENAMED);
        SimpleFeature original = (SimpleFeature)store.getFeatures((Filter)this.fidFilter).features().next();
        String newDescription = (String)original.getAttribute("description") + " xxx";
        store.modifyFeatures((Name)new NameImpl("description"), (Object)newDescription, (Filter)this.fidFilter);
        SimpleFeature modified = (SimpleFeature)store.getFeatures((Filter)this.fidFilter).features().next();
        Assert.assertEquals((Object)newDescription, (Object)modified.getAttribute("description"));
        MultiPoint mpo = (MultiPoint)original.getAttribute("pointProperty");
        MultiPoint mpm = mpo.getFactory().createMultiPoint((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(10.0, 12.0)}));
        store.modifyFeatures((Name)new NameImpl("pointProperty"), (Object)mpm, (Filter)this.fidFilter);
        modified = (SimpleFeature)store.getFeatures((Filter)this.fidFilter).features().next();
        Assert.assertTrue((boolean)mpm.equalsExact((Geometry)modified.getAttribute("pointProperty")));
    }

    @Test
    public void testAppend() throws Exception {
        SimpleFeatureType type = DataUtilities.createType((String)"trees", (String)"the_geom:Point,FID:String,NAME:String");
        SimpleFeatureStore fs = (SimpleFeatureStore)EasyMock.createMock(SimpleFeatureStore.class);
        EasyMock.expect((Object)fs.addFeatures((FeatureCollection)EasyMock.isA(FeatureCollection.class))).andReturn(Collections.singletonList(new FeatureIdImpl("trees.105")));
        EasyMock.replay((Object[])new Object[]{fs});
        DataStore ds = (DataStore)EasyMock.createMock(DataStore.class);
        EasyMock.expect((Object)ds.getTypeNames()).andReturn((Object)new String[]{"trees"}).anyTimes();
        EasyMock.expect((Object)ds.getSchema("trees")).andReturn((Object)type).anyTimes();
        EasyMock.expect((Object)ds.getFeatureSource("trees")).andReturn((Object)fs);
        EasyMock.replay((Object[])new Object[]{ds});
        RetypingDataStore rts = new RetypingDataStore(ds){

            protected String transformFeatureTypeName(String originalName) {
                return "oaks";
            }
        };
        SimpleFeatureBuilder sfb = new SimpleFeatureBuilder(type);
        WKTReader reader = new WKTReader();
        sfb.set("the_geom", (Object)reader.read("POINT (0.002 0.0008)"));
        sfb.set("FID", (Object)"023");
        sfb.set("NAME", (Object)"Old oak");
        SimpleFeature feature = sfb.buildFeature(null);
        SimpleFeatureCollection fc = DataUtilities.collection((SimpleFeature)feature);
        SimpleFeatureStore store = (SimpleFeatureStore)rts.getFeatureSource("oaks");
        List ids = store.addFeatures((FeatureCollection)fc);
        Assert.assertEquals((long)1L, (long)ids.size());
        String id = ((FeatureId)ids.iterator().next()).getID();
        Assert.assertTrue((String)("Id does not start with oaks it's " + id), (boolean)id.startsWith("oaks"));
    }

    @Test
    public void testLockUnlockFilter() throws Exception {
        SimpleFeatureLocking fl = (SimpleFeatureLocking)this.rts.getFeatureSource(RENAMED);
        FeatureLock lock = new FeatureLock("lock", 600000L);
        DefaultTransaction t = new DefaultTransaction();
        t.addAuthorization(lock.getAuthorization());
        fl.setTransaction((Transaction)t);
        fl.setFeatureLock(lock);
        SimpleFeatureLocking fl2 = (SimpleFeatureLocking)this.rts.getFeatureSource(RENAMED);
        fl.setFeatureLock(lock);
        fl2.setTransaction((Transaction)new DefaultTransaction());
        Assert.assertEquals((long)1L, (long)fl.lockFeatures((Filter)this.fidFilter));
        Assert.assertEquals((long)0L, (long)fl2.lockFeatures((Filter)this.fidFilter));
        fl.unLockFeatures((Filter)this.fidFilter);
        Assert.assertEquals((long)1L, (long)fl2.lockFeatures((Filter)this.fidFilter));
    }

    @Test
    public void testLockUnlockQuery() throws Exception {
        SimpleFeatureLocking fl = (SimpleFeatureLocking)this.rts.getFeatureSource(RENAMED);
        FeatureLock lock = new FeatureLock("test", 600000L);
        DefaultTransaction t = new DefaultTransaction();
        t.addAuthorization(lock.getAuthorization());
        fl.setTransaction((Transaction)t);
        fl.setFeatureLock(lock);
        SimpleFeatureLocking fl2 = (SimpleFeatureLocking)this.rts.getFeatureSource(RENAMED);
        fl.setFeatureLock(lock);
        fl2.setTransaction((Transaction)new DefaultTransaction());
        Query q = new Query(RENAMED, (Filter)this.fidFilter);
        Assert.assertEquals((long)1L, (long)fl.lockFeatures(q));
        Assert.assertEquals((long)0L, (long)fl2.lockFeatures(q));
        fl.unLockFeatures(q);
        Assert.assertEquals((long)1L, (long)fl2.lockFeatures(q));
    }
}

