/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature.retype;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.geoserver.data.test.MockData;
import org.geoserver.feature.retype.RetypingDataStore;
import org.geoserver.feature.retype.RetypingFeatureSource;
import org.geoserver.util.IOUtils;
import org.geotools.data.DataStore;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public class RetypingFeatureSourceTest {
    static final String RENAMED = "houses";
    RetypingDataStore rts;
    private File data;
    private PropertyDataStore store;

    @Before
    public void setUp() throws Exception {
        this.data = File.createTempFile("retype", "data", new File("./target"));
        this.data.delete();
        this.data.mkdir();
        this.copyTestData(MockData.BUILDINGS, this.data);
        this.copyTestData(MockData.BRIDGES, this.data);
        this.store = new PropertyDataStore(this.data);
    }

    void copyTestData(QName testData, File data) throws IOException {
        String fileName = testData.getLocalPart() + ".properties";
        URL properties = MockData.class.getResource(fileName);
        IOUtils.copy((InputStream)properties.openStream(), (File)new File(data, fileName));
    }

    @Test
    public void testSimpleRename() throws IOException {
        ContentFeatureSource fs = this.store.getFeatureSource(MockData.BUILDINGS.getLocalPart());
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init((SimpleFeatureType)fs.getSchema());
        tb.setName(RENAMED);
        SimpleFeatureType target = tb.buildFeatureType();
        SimpleFeatureSource retyped = RetypingFeatureSource.getRetypingSource((SimpleFeatureSource)fs, (SimpleFeatureType)target);
        Assert.assertTrue((boolean)(retyped instanceof SimpleFeatureLocking));
        Assert.assertEquals((Object)target, (Object)retyped.getSchema());
        Assert.assertEquals((Object)target, (Object)((DataStore)retyped.getDataStore()).getSchema(RENAMED));
        Assert.assertEquals((Object)target, (Object)retyped.getFeatures().getSchema());
        SimpleFeatureIterator it = retyped.getFeatures().features();
        SimpleFeature f = (SimpleFeature)it.next();
        it.close();
        Assert.assertEquals((Object)target, (Object)f.getType());
    }

    @Test
    public void testConflictingRename() throws IOException {
        ContentFeatureSource fs = this.store.getFeatureSource(MockData.BUILDINGS.getLocalPart());
        Assert.assertEquals((long)2L, (long)this.store.getTypeNames().length);
        Assert.assertNotNull((Object)this.store.getSchema(MockData.BRIDGES.getLocalPart()));
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init((SimpleFeatureType)fs.getSchema());
        tb.setName(MockData.BRIDGES.getLocalPart());
        SimpleFeatureType target = tb.buildFeatureType();
        SimpleFeatureSource retyped = RetypingFeatureSource.getRetypingSource((SimpleFeatureSource)fs, (SimpleFeatureType)target);
        Assert.assertEquals((Object)target, (Object)retyped.getSchema());
        DataStore rs = (DataStore)retyped.getDataStore();
        Assert.assertEquals((long)1L, (long)rs.getTypeNames().length);
        Assert.assertEquals((Object)MockData.BRIDGES.getLocalPart(), (Object)rs.getTypeNames()[0]);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        String fid = MockData.BRIDGES.getLocalPart() + ".1107531701011";
        Id fidFilter = ff.id(Collections.singleton(ff.featureId(fid)));
        SimpleFeatureIterator it = retyped.getFeatures((Filter)fidFilter).features();
        Assert.assertTrue((boolean)it.hasNext());
        SimpleFeature f = (SimpleFeature)it.next();
        Assert.assertFalse((boolean)it.hasNext());
        it.close();
        Assert.assertEquals((Object)"114", (Object)f.getAttribute("FID"));
        Assert.assertEquals((Object)"215 Main Street", (Object)f.getAttribute("ADDRESS"));
    }
}

