/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.BufferedReader;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.filters.BufferedRequestWrapper;
import org.geoserver.filters.RequestWrapperTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class BufferedRequestWrapperTest
extends RequestWrapperTestSupport {
    @Test
    public void testGetInputStream() throws Exception {
        for (int i = 0; i < this.testStrings.length; ++i) {
            this.doInputStreamTest(this.testStrings[i]);
        }
    }

    @Test
    public void testGetReader() throws Exception {
        for (int i = 0; i < this.testStrings.length; ++i) {
            this.doGetReaderTest(this.testStrings[i]);
        }
    }

    public void doInputStreamTest(String testString) throws Exception {
        int amountRead;
        MockHttpServletRequest req = this.makeRequest(testString, null);
        BufferedRequestWrapper wrapper = new BufferedRequestWrapper((HttpServletRequest)req, "ISO-8859-1", testString.getBytes());
        ServletInputStream sis = req.getInputStream();
        byte[] b = new byte[32];
        while (sis.readLine(b, 0, 32) > 0) {
        }
        sis = wrapper.getInputStream();
        StringBuffer buff = new StringBuffer();
        while ((amountRead = sis.readLine(b, 0, 32)) != 0) {
            buff.append(new String(b, 0, amountRead));
        }
        Assert.assertEquals((Object)buff.toString(), (Object)testString);
    }

    public void doGetReaderTest(String testString) throws Exception {
        int c;
        MockHttpServletRequest req = this.makeRequest(testString, null);
        BufferedReader br = req.getReader();
        while (br.readLine() != null) {
        }
        BufferedRequestWrapper wrapper = new BufferedRequestWrapper((HttpServletRequest)req, "ISO-8859-1", testString.getBytes());
        StringBuffer buff = new StringBuffer();
        br = wrapper.getReader();
        while ((c = br.read()) != -1) {
            buff.append((char)c);
        }
        Assert.assertEquals((Object)buff.toString(), (Object)testString);
    }

    @Test
    public void testMixedRequest() throws Exception {
        String body = "a=1&b=2";
        String queryString = "c=3&d=4";
        MockHttpServletRequest req = this.makeRequest(body, queryString);
        BufferedReader br = req.getReader();
        while (br.readLine() != null) {
        }
        BufferedRequestWrapper wrapper = new BufferedRequestWrapper((HttpServletRequest)req, "UTF-8", body.getBytes());
        Map params = wrapper.getParameterMap();
        Assert.assertEquals((long)4L, (long)params.size());
        Assert.assertEquals((Object)"1", (Object)((String[])params.get("a"))[0]);
        Assert.assertEquals((Object)"2", (Object)((String[])params.get("b"))[0]);
        Assert.assertEquals((Object)"3", (Object)((String[])params.get("c"))[0]);
        Assert.assertEquals((Object)"4", (Object)((String[])params.get("d"))[0]);
    }

    @Test
    public void testNoContentType() throws Exception {
        String body = "a=1&b=2";
        String queryString = "c=3&d=4";
        MockHttpServletRequest req = this.makeRequest(body, queryString);
        req.setContentType(null);
        BufferedReader br = req.getReader();
        while (br.readLine() != null) {
        }
        BufferedRequestWrapper wrapper = new BufferedRequestWrapper((HttpServletRequest)req, "UTF-8", body.getBytes());
        Map params = wrapper.getParameterMap();
        Assert.assertEquals((long)0L, (long)params.size());
    }

    @Test
    public void testEmptyPost() throws Exception {
        MockHttpServletRequest req = this.makeRequest("", "");
        req.setContentType(null);
        BufferedReader br = req.getReader();
        while (br.readLine() != null) {
        }
        BufferedRequestWrapper wrapper = new BufferedRequestWrapper((HttpServletRequest)req, "UTF-8", "".getBytes());
        Map params = wrapper.getParameterMap();
        Assert.assertEquals((long)0L, (long)params.size());
    }
}

