/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.geoserver.filters.FlushSafeFilter;
import org.geoserver.filters.FlushSafeResponse;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class FlushSafeFilterTest {
    @Test
    public void testRetrieveSameOutputStream() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                ServletOutputStream os1 = response.getOutputStream();
                ServletOutputStream os2 = response.getOutputStream();
                Assert.assertSame((Object)os1, (Object)os2);
                Assert.assertTrue((boolean)(os1 instanceof FlushSafeResponse.FlushSafeServletOutputStream));
            }
        };
        FlushSafeFilter filter = new FlushSafeFilter();
        filter.init((FilterConfig)new MockFilterConfig());
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
    }

    @Test
    public void testFlushAfterClose() throws ServletException, IOException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse(){
            ServletOutputStream os;

            public ServletOutputStream getOutputStream() {
                if (this.os == null) {
                    final ServletOutputStream wrapped = super.getOutputStream();
                    this.os = new ServletOutputStream(){
                        boolean closed;

                        public void write(int b) throws IOException {
                            wrapped.write(b);
                        }

                        public void close() throws IOException {
                            this.closed = true;
                            wrapped.close();
                        }

                        public void flush() throws IOException {
                            if (this.closed) {
                                throw new RuntimeException("Aaarg, I'm already closed, your JVM shall die now!");
                            }
                            wrapped.flush();
                        }
                    };
                }
                return this.os;
            }
        };
        MockFilterChain chain = new MockFilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                ServletOutputStream os = response.getOutputStream();
                os.print("Some random text");
                os.close();
                os.flush();
            }
        };
        FlushSafeFilter filter = new FlushSafeFilter();
        filter.init((FilterConfig)new MockFilterConfig());
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((Object)"Some random text", (Object)response.getContentAsString());
    }
}

