/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.junit.Assert;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.mock.web.MockServletContext;

public class RequestWrapperTestSupport {
    protected final String[] testStrings = new String[]{"Hello, this is a test", "LongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLong", "", "test\ncontaining\nnewlines"};

    protected MockHttpServletRequest makeRequest(String body, String queryString) throws UnsupportedEncodingException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver");
        request.setQueryString(queryString != null ? queryString : "");
        request.setRemoteAddr("127.0.0.1");
        request.setServletPath("/geoserver");
        request.setContentType("application/x-www-form-urlencoded");
        request.setMethod("POST");
        request.setContent(body.getBytes("UTF-8"));
        MockHttpSession session = new MockHttpSession((ServletContext)new MockServletContext());
        request.setSession((HttpSession)session);
        request.setUserPrincipal(null);
        return request;
    }

    public static void compare(HttpServletRequest reqA, HttpServletRequest reqB) {
        Method[] methods = HttpServletRequest.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            try {
                if (methods[i].getParameterTypes().length != 0) continue;
                Object resultA = methods[i].invoke((Object)reqA, new Object[0]);
                Object resultB = methods[i].invoke((Object)reqB, new Object[0]);
                Assert.assertEquals((Object)resultA, (Object)resultB);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

