/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.geoserver.filters.XFrameOptionsFilter;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;

public class XFrameOptionsFilterTest {
    @Test
    public void doFilter() throws Exception {
        String header = this.getXStreamHeader();
        Assert.assertEquals((String)"Expect default XFrameOption to be DENY", (Object)"SAMEORIGIN", (Object)header);
    }

    @Test
    public void testFilterWithNoSetPolicy() throws IOException, ServletException {
        String currentShouldSetProperty = System.getProperty("geoserver.xframe.shouldSetPolicy");
        System.setProperty("geoserver.xframe.shouldSetPolicy", "false");
        String header = this.getXStreamHeader();
        Assert.assertEquals((String)"Expect default XFrameOption to be null", null, (Object)header);
        if (currentShouldSetProperty != null) {
            System.setProperty("geoserver.xframe.shouldSetPolicy", currentShouldSetProperty);
        }
    }

    @Test
    public void testFilterWithSameOrigin() throws IOException, ServletException {
        String currentShouldSetProperty = System.getProperty("geoserver.xframe.policy");
        System.setProperty("geoserver.xframe.policy", "DENY");
        String header = this.getXStreamHeader();
        Assert.assertEquals((String)"Expect default XFrameOption to be DENY", (Object)"DENY", (Object)header);
        if (currentShouldSetProperty != null) {
            System.setProperty("geoserver.xframe.policy", currentShouldSetProperty);
        }
    }

    private String getXStreamHeader() throws IOException, ServletException {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "http://www.geoserver.org");
        MockHttpServletResponse response = new MockHttpServletResponse();
        XFrameOptionsFilter filter = new XFrameOptionsFilter();
        MockServletContext context = new MockServletContext();
        MockFilterConfig config = new MockFilterConfig((ServletContext)context);
        MockFilterChain mockChain = new MockFilterChain();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)mockChain);
        return response.getHeader("X-Frame-Options");
    }
}

