/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import java.io.File;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geoserver.logging.LoggingStartupContextListener;
import org.geoserver.logging.LoggingUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.LockProvider;
import org.geoserver.platform.resource.MemoryLockProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockServletContext;

public class LoggingStartupContextListenerTest {
    @Before
    public void cleanupLoggers() {
        LogManager.resetConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogLocationFromServletContext() throws Exception {
        File tmp = File.createTempFile("log", "tmp", new File("target"));
        tmp.delete();
        tmp.mkdirs();
        File logs = new File(tmp, "logs");
        Assert.assertTrue((boolean)logs.mkdirs());
        FileUtils.copyURLToFile((URL)this.getClass().getResource("logging.xml"), (File)new File(tmp, "logging.xml"));
        MockServletContext context = new MockServletContext();
        context.setInitParameter("GEOSERVER_DATA_DIR", tmp.getPath());
        context.setInitParameter("GEOSERVER_LOG_LOCATION", new File(tmp, "foo.log").getAbsolutePath());
        Logger logger = Logger.getRootLogger();
        Assert.assertNull((String)("Expected geoserverlogfile to be null.  But was: " + logger.getAppender("geoserverlogfile")), (Object)logger.getAppender("geoserverlogfile"));
        String rel = System.getProperty("RELINQUISH_LOG4J_CONTROL");
        System.setProperty("RELINQUISH_LOG4J_CONTROL", "false");
        try {
            new LoggingStartupContextListener().contextInitialized(new ServletContextEvent((ServletContext)context));
        }
        finally {
            System.setProperty("RELINQUISH_LOG4J_CONTROL", "rel");
        }
        Appender appender = logger.getAppender("geoserverlogfile");
        Assert.assertNotNull((Object)appender);
        Assert.assertTrue((boolean)(appender instanceof FileAppender));
        Assert.assertEquals((Object)new File(tmp, "foo.log").getCanonicalPath().toLowerCase(), (Object)((FileAppender)appender).getFile().toLowerCase());
    }

    @Test
    public void testInitLoggingLock() throws Exception {
        File target = new File("./target");
        FileUtils.deleteQuietly((File)new File(target, "logs"));
        GeoServerResourceLoader loader = new GeoServerResourceLoader(target);
        FileSystemResourceStore store = (FileSystemResourceStore)loader.getResourceStore();
        store.setLockProvider((LockProvider)new MemoryLockProvider());
        LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)"DEFAULT_LOGGING.properties", (boolean)false, null);
        LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)"DEFAULT_LOGGING.properties", (boolean)false, null);
        LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)"DEFAULT_LOGGING.properties", (boolean)false, null);
    }
}

