/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.Collections;
import java.util.List;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.SystemTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class CustomManglerTest
extends GeoServerSystemTestSupport {
    private static final String BASEURL = "http://localhost:8080/geoserver";

    @Override
    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath*:/customManglerContext.xml");
    }

    @Test
    public void testBasic() {
        String url = ResponseUtils.buildURL((String)BASEURL, (String)"test", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/test?here=iam", (Object)url);
    }

    @Test
    public void testKVP() {
        String url = ResponseUtils.buildURL((String)BASEURL, (String)"test", Collections.singletonMap("param", "value()"), (URLMangler.URLType)URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/test?param=value%28%29&here=iam", (Object)url);
    }
}

