/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.Collections;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.OWSHandlerMapping;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.feature.NameImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.type.Name;
import org.springframework.context.ApplicationContext;

public class OWSHandlerMappingTest
extends GeoServerSystemTestSupport {
    private OWSHandlerMapping mapping = null;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        LayerInfo layer = catalog.getLayerByName((Name)new NameImpl(CiteTestData.BASIC_POLYGONS));
        StyleInfo style = catalog.getStyleByName(CiteTestData.DEFAULT_VECTOR_STYLE);
        CatalogFactory factory = catalog.getFactory();
        LayerGroupInfo lg1 = factory.createLayerGroup();
        lg1.setName("LayerGroup1");
        lg1.getLayers().add(layer);
        lg1.getStyles().add(style);
        catalog.add(lg1);
        LayerGroupInfo lg2 = factory.createLayerGroup();
        lg2.setName("LayerGroup2");
        lg2.setWorkspace(catalog.getWorkspaceByName(CiteTestData.CITE_PREFIX));
        lg2.getLayers().add(layer);
        lg2.getStyles().add(style);
        catalog.add(lg2);
    }

    @Before
    public void initHandlerMapping() {
        this.mapping = new OWSHandlerMapping(this.getCatalog());
        this.mapping.setUrlMap(Collections.singletonMap("/test", new Object()));
        this.mapping.setApplicationContext((ApplicationContext)applicationContext);
        this.mapping.initApplicationContext();
    }

    @Test
    public void testLookupHandler_WithoutWorkspace() throws Exception {
        Assert.assertNotNull((Object)this.mapping.lookupHandler("/test", null));
    }

    @Test
    public void testLookupHandler_WorkspaceExists() throws Exception {
        Assert.assertNotNull((Object)this.mapping.lookupHandler("/cite/test", null));
    }

    @Test
    public void testLookupHandler_WorkspaceMissing() throws Exception {
        Assert.assertNull((Object)this.mapping.lookupHandler("/ws/test", null));
    }

    @Test
    public void testLookupHandler_LayerExists() throws Exception {
        Assert.assertNotNull((Object)this.mapping.lookupHandler("/cite/BasicPolygons/test", null));
    }

    @Test
    public void testLookupHandler_LayerMissing() throws Exception {
        Assert.assertNull((Object)this.mapping.lookupHandler("/cite/MissingLayer/test", null));
    }

    @Test
    public void testLookupHandler_LayerMissingInWorkspace() throws Exception {
        Assert.assertNull((Object)this.mapping.lookupHandler("/cite/Fifteen/test", null));
    }

    @Test
    public void testLookupHandler_WorkspacedLayerGroupExists() throws Exception {
        Assert.assertNotNull((Object)this.mapping.lookupHandler("/cite/LayerGroup2/test", null));
    }

    @Test
    public void testLookupHandler_WorkspacedLayerGroupMissing() throws Exception {
        Assert.assertNull((Object)this.mapping.lookupHandler("/cite/lg/test", null));
    }

    @Test
    public void testLookupHandler_LayerGroupExists() throws Exception {
        Assert.assertNotNull((Object)this.mapping.lookupHandler("/LayerGroup1/test", null));
    }

    @Test
    public void testLookupHandler_LayerGroupMissing() throws Exception {
        Assert.assertNull((Object)this.mapping.lookupHandler("/lg/test", null));
    }

    @Test
    public void testLookupHandler_NotAGlobalLayerGroup() throws Exception {
        Assert.assertNull((Object)this.mapping.lookupHandler("/cite:LayerGroup2/test", null));
    }
}

