/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.AbstractURLPublisher;
import org.geoserver.ows.StylePublisher;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;

public class StylePublisherTest
extends GeoServerSystemTestSupport {
    static StylePublisher publisher;
    static List<String[]> paths;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        Catalog catalog = this.getCatalog();
        publisher = new StylePublisher(catalog);
        publisher.setServletContext((ServletContext)new MockServletContext());
        GeoServerResourceLoader resourceLoader = this.getResourceLoader();
        resourceLoader.copyFromClassPath("org/geoserver/ows/smileyface.png", "styles/smileyface.png");
        paths.add(new String[]{"styles", "smileyface.png"});
        resourceLoader.copyFromClassPath("org/geoserver/ows/smileyface.png", "styles/icons/smileyface.png");
        paths.add(new String[]{"styles", "icons", "smileyface.png"});
        resourceLoader.copyFromClassPath("org/geoserver/ows/house.svg", "workspaces/cite/styles/house.svg");
        paths.add(new String[]{"styles", "cite", "house.svg"});
        resourceLoader.copyFromClassPath("org/geoserver/ows/house.svg", "workspaces/cite/styles/icons/house.svg");
        paths.add(new String[]{"styles", "cite", "icons", "house.svg"});
        paths.add(new String[]{"styles", "cite", "smileyface.png"});
        paths.add(new String[]{"styles", "cite", "icons", "smileyface.png"});
        resourceLoader.copyFromClassPath("org/geoserver/ows/smileyface.png", "styles/override.png");
        resourceLoader.copyFromClassPath("org/geoserver/ows/grass_fill.png", "workspaces/cite/styles/override.png");
        resourceLoader.copyFromClassPath("org/geoserver/ows/smileyface.png", "styles/icons/override.png");
        resourceLoader.copyFromClassPath("org/geoserver/ows/grass_fill.png", "workspaces/cite/styles/icons/override.png");
    }

    private MockHttpServletResponse request(String[] path, String modifiedSince) throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setMethod("GET");
        StringBuilder b = new StringBuilder("/geoserver");
        for (int i = 0; i < path.length; ++i) {
            b.append('/').append(path[i]);
        }
        String uri = URLEncoder.encode(b.toString(), "UTF-8");
        request.setRequestURI(uri);
        if (modifiedSince != null) {
            request.addHeader("If-Modified-Since", (Object)modifiedSince);
        }
        MockHttpServletResponse response = new MockHttpServletResponse();
        publisher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        return response;
    }

    @Test
    public void testEncoding() throws Exception {
        for (Object[] objectArray : paths) {
            MockHttpServletResponse response = this.request((String[])objectArray, null);
            Assert.assertEquals((String)Arrays.toString(objectArray), (long)200L, (long)response.getStatus());
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/geoserver/ows/" + (String)objectArray[objectArray.length - 1])), (byte[])response.getContentAsByteArray());
        }
    }

    @Test
    public void testOverride() throws Exception {
        Object[] path = new String[]{"styles", "override.png"};
        MockHttpServletResponse response = this.request((String[])path, null);
        Assert.assertEquals((String)Arrays.toString(path), (long)200L, (long)response.getStatus());
        Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/geoserver/ows/smileyface.png")), (byte[])response.getContentAsByteArray());
        path = new String[]{"styles", "cite", "override.png"};
        response = this.request((String[])path, null);
        Assert.assertEquals((String)Arrays.toString(path), (long)200L, (long)response.getStatus());
        Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/geoserver/ows/grass_fill.png")), (byte[])response.getContentAsByteArray());
        path = new String[]{"styles", "icons", "override.png"};
        response = this.request((String[])path, null);
        Assert.assertEquals((String)Arrays.toString(path), (long)200L, (long)response.getStatus());
        Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/geoserver/ows/smileyface.png")), (byte[])response.getContentAsByteArray());
        path = new String[]{"styles", "cite", "icons", "override.png"};
        response = this.request((String[])path, null);
        Assert.assertEquals((String)Arrays.toString(path), (long)200L, (long)response.getStatus());
        Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/geoserver/ows/grass_fill.png")), (byte[])response.getContentAsByteArray());
    }

    @Test
    public void testLastModified() throws Exception {
        for (String[] path : paths) {
            MockHttpServletResponse response = this.request(path, null);
            String lastModified = response.getHeader("Last-Modified");
            Assert.assertNotNull((Object)lastModified);
            response = this.request(path, lastModified);
            Assert.assertEquals((long)304L, (long)response.getStatus());
            long timeStamp = AbstractURLPublisher.lastModified((String)lastModified) + 10000L;
            response = this.request(path, AbstractURLPublisher.lastModified((long)timeStamp));
            Assert.assertEquals((long)304L, (long)response.getStatus());
            response = this.request(path, AbstractURLPublisher.lastModified((long)(timeStamp -= 20000L)));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/geoserver/ows/" + path[path.length - 1])), (byte[])response.getContentAsByteArray());
        }
    }

    static {
        paths = new ArrayList<String[]>();
    }
}

