/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.geoserver.platform.GeoServerExtensions;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class GeoServerExtensionsHelper {
    public static void setIsSpringContext(boolean isSpring) {
        GeoServerExtensions.isSpringContext = isSpring;
    }

    public static void clear() {
        GeoServerExtensions.extensionsCache.clear();
        GeoServerExtensions.singletonBeanCache.clear();
        GeoServerExtensions.propertyCache.clear();
        GeoServerExtensions.fileCache.clear();
    }

    public static void init(ApplicationContext context) throws BeansException {
        GeoServerExtensions.isSpringContext = false;
        GeoServerExtensions.context = context;
        GeoServerExtensionsHelper.clear();
    }

    public static void singleton(String name, Object bean, Class<?> ... declaredClasses) {
        if (GeoServerExtensions.context != null) {
            Class<?>[] conflict;
            if (GeoServerExtensions.context.containsBean(name) && bean != (conflict = GeoServerExtensions.context.getBean(name))) {
                GeoServerExtensions.LOGGER.fine("ApplicationContext override " + name + ": " + conflict);
            }
        } else {
            GeoServerExtensions.isSpringContext = false;
        }
        if (name == null || bean == null) {
            return;
        }
        GeoServerExtensions.singletonBeanCache.put(name, bean);
        if (declaredClasses != null && declaredClasses.length > 0) {
            for (Class<?> clazz : declaredClasses) {
                GeoServerExtensionsHelper.addToCache(GeoServerExtensions.extensionsCache, clazz, name);
            }
        } else {
            Class<?> type = bean.getClass();
            GeoServerExtensionsHelper.addToCache(GeoServerExtensions.extensionsCache, type, name);
        }
    }

    static <T> void addToCache(Map<T, String[]> cache, T key, String name) {
        String[] cached = cache.get(key);
        if (cached != null) {
            cached = Arrays.copyOf(cached, cached.length + 1);
            cached[cached.length - 1] = name;
        } else {
            cached = new String[]{name};
        }
        cache.put(key, cached);
    }

    public static void property(String propertyName, String property) {
        GeoServerExtensions.propertyCache.put(propertyName, property);
    }

    public static void file(String path, File file) {
        GeoServerExtensions.fileCache.put(path, file);
    }

    public static class ExtensionsHelperRule
    implements TestRule {
        ApplicationContext context;
        Boolean isSpringContext;
        Boolean active = false;

        public Statement apply(Statement base, Description description) {
            return this.statement(base);
        }

        private Statement statement(final Statement base) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    try {
                        if (context != null) {
                            GeoServerExtensionsHelper.init(context);
                        } else {
                            GeoServerExtensionsHelper.clear();
                        }
                        if (isSpringContext != null) {
                            GeoServerExtensionsHelper.setIsSpringContext(isSpringContext);
                        }
                        active = true;
                        base.evaluate();
                    }
                    finally {
                        active = false;
                        GeoServerExtensionsHelper.clear();
                    }
                }
            };
        }

        public void singleton(String name, Object bean, Class<?> ... declaredClasses) {
            if (!this.active.booleanValue()) {
                throw new IllegalStateException();
            }
            GeoServerExtensionsHelper.singleton(name, bean, declaredClasses);
        }

        public void property(String propertyName, String property) {
            if (!this.active.booleanValue()) {
                throw new IllegalStateException();
            }
            GeoServerExtensionsHelper.property(propertyName, property);
        }

        public void file(String path, File file) {
            if (!this.active.booleanValue()) {
                throw new IllegalStateException();
            }
            GeoServerExtensionsHelper.file(path, file);
        }
    }
}

