/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.io.File;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeoServerExtensionsHelperTest {
    @Before
    public void setUp() throws Exception {
        System.setProperty("TEST_PROPERTY", "ABC");
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("TEST_PROPERTY");
        GeoServerExtensionsHelper.init(null);
    }

    @Test
    public void helperProperty() {
        Assert.assertEquals((Object)"ABC", (Object)GeoServerExtensions.getProperty((String)"TEST_PROPERTY"));
        GeoServerExtensionsHelper.property("TEST_PROPERTY", "abc");
        Assert.assertEquals((Object)"abc", (Object)GeoServerExtensions.getProperty((String)"TEST_PROPERTY"));
        GeoServerExtensionsHelper.clear();
        Assert.assertEquals((Object)"ABC", (Object)GeoServerExtensions.getProperty((String)"TEST_PROPERTY"));
    }

    @Test
    public void helperSingleton() {
        GeoServerExtensionsHelper.singleton("bean", this, new Class[0]);
        Assert.assertSame((Object)this, (Object)GeoServerExtensions.bean((String)"bean"));
        Assert.assertSame((Object)this, (Object)GeoServerExtensions.bean(GeoServerExtensionsHelperTest.class));
        GeoServerExtensionsHelper.clear();
        Assert.assertNull((Object)GeoServerExtensions.bean((String)"bean"));
        Assert.assertNull((Object)GeoServerExtensions.bean(GeoServerExtensionsHelperTest.class));
    }

    @Test
    public void helperMultipleSingleton() {
        TestClass o1 = new TestClass();
        TestClass o2 = new TestClass();
        GeoServerExtensionsHelper.singleton("o1", o1, TestClass.class);
        GeoServerExtensionsHelper.singleton("o2", o2, TestClass.class);
        Assert.assertThat((Object)GeoServerExtensions.extensions(TestClass.class), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.sameInstance((Object)o1), Matchers.sameInstance((Object)o2)}));
    }

    @Test
    public void helperFile() {
        File webxml = new File("web.xml");
        GeoServerExtensionsHelper.file("WEB-INF/web.xml", webxml);
        Assert.assertSame((Object)webxml, (Object)GeoServerExtensions.file((String)"WEB-INF/web.xml"));
    }

    class TestClass {
        TestClass() {
        }
    }
}

