/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.password.GeoServerDigestPasswordEncoder;
import org.geoserver.security.password.GeoServerEmptyPasswordEncoder;
import org.geoserver.security.password.GeoServerMultiplexingPasswordEncoder;
import org.geoserver.security.password.GeoServerPBEPasswordEncoder;
import org.geoserver.security.password.GeoServerPlainTextPasswordEncoder;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.util.URLs;
import org.junit.Assert;

public abstract class AbstractSecurityServiceTest
extends GeoServerSystemTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    public GeoServerUserGroupService createUserGroupService(String name) throws Exception {
        return null;
    }

    public GeoServerRoleService createRoleService(String name) throws Exception {
        return null;
    }

    protected boolean isNewRoleService(String name) throws IOException {
        return !this.getSecurityManager().listRoleServices().contains(name);
    }

    protected boolean isNewUGService(String name) throws IOException {
        return !this.getSecurityManager().listUserGroupServices().contains(name);
    }

    public GeoServerUserGroupStore createStore(GeoServerUserGroupService service) throws IOException {
        return service.createStore();
    }

    public GeoServerRoleStore createStore(GeoServerRoleService service) throws IOException {
        return service.createStore();
    }

    protected void checkEmpty(GeoServerRoleService roleService) throws IOException {
        Assert.assertEquals((long)0L, (long)roleService.getRoles().size());
        Assert.assertEquals((long)0L, (long)roleService.getRoleCount());
    }

    public void insertValues(GeoServerRoleStore roleStore) throws IOException {
        GeoServerRole role_admin = roleStore.createRoleObject(GeoServerRole.ADMIN_ROLE.getAuthority());
        GeoServerRole role_auth = roleStore.createRoleObject("ROLE_AUTHENTICATED");
        GeoServerRole role_wfs = roleStore.createRoleObject("ROLE_WFS");
        GeoServerRole role_wms = roleStore.createRoleObject("ROLE_WMS");
        role_auth.getProperties().put("employee", "");
        role_auth.getProperties().put("bbox", "lookupAtRuntime");
        roleStore.addRole(role_admin);
        roleStore.addRole(role_auth);
        roleStore.addRole(role_wfs);
        roleStore.addRole(role_wms);
        roleStore.setParentRole(role_wms, role_auth);
        roleStore.setParentRole(role_wfs, role_auth);
        roleStore.associateRoleToUser(role_admin, "admin");
        roleStore.associateRoleToUser(role_wms, "user1");
        roleStore.associateRoleToUser(role_wfs, "user1");
        roleStore.associateRoleToGroup(role_wms, "g_wms");
        roleStore.associateRoleToGroup(role_wfs, "g_wfs");
        roleStore.associateRoleToGroup(role_wms, "g_all");
        roleStore.associateRoleToGroup(role_wfs, "g_all");
    }

    public void removeValues(GeoServerRoleStore roleStore) throws IOException {
        GeoServerRole role_auth = roleStore.createRoleObject("ROLE_AUTHENTICATED");
        GeoServerRole role_wfs = roleStore.getRoleByName("ROLE_WFS");
        roleStore.removeRole(role_wfs);
        roleStore.removeRole(role_auth);
    }

    public void modifyValues(GeoServerRoleStore roleStore) throws IOException {
        GeoServerRole role_auth = roleStore.getRoleByName("ROLE_AUTHENTICATED");
        GeoServerRole role_wfs = roleStore.getRoleByName("ROLE_WFS");
        GeoServerRole role_wms = roleStore.getRoleByName("ROLE_WMS");
        role_auth.getProperties().remove("bbox");
        role_auth.getProperties().setProperty("employee", "4711");
        roleStore.updateRole(role_auth);
        role_wms.getProperties().setProperty("envelope", "10 10 20 20");
        roleStore.updateRole(role_wms);
        roleStore.disAssociateRoleFromGroup(role_wfs, "g_all");
        roleStore.disAssociateRoleFromUser(role_wfs, "user1");
        roleStore.setParentRole(role_wms, null);
        roleStore.setParentRole(role_wfs, role_wms);
    }

    protected void checkValuesRemoved(GeoServerRoleService roleService) throws IOException {
        GeoServerRole role_admin = roleService.getRoleByName(GeoServerRole.ADMIN_ROLE.getAuthority());
        GeoServerRole role_wms = roleService.getRoleByName("ROLE_WMS");
        Assert.assertEquals((long)2L, (long)roleService.getRoles().size());
        Assert.assertEquals((long)2L, (long)roleService.getRoleCount());
        Assert.assertTrue((boolean)roleService.getRoles().contains(role_admin));
        Assert.assertTrue((boolean)roleService.getRoles().contains(role_wms));
        Assert.assertNull((Object)roleService.getParentRole(role_wms));
        Assert.assertEquals((long)1L, (long)roleService.getRolesForUser("user1").size());
        Assert.assertTrue((boolean)roleService.getRolesForUser("user1").contains(role_wms));
        Assert.assertEquals((long)0L, (long)roleService.getRolesForGroup("g_wfs").size());
        Assert.assertEquals((long)1L, (long)roleService.getRolesForGroup("g_all").size());
        Assert.assertTrue((boolean)roleService.getRolesForGroup("g_all").contains(role_wms));
    }

    protected void checkValuesModified(GeoServerRoleService roleService) throws IOException {
        GeoServerRole role_auth = roleService.getRoleByName("ROLE_AUTHENTICATED");
        GeoServerRole role_wms = roleService.getRoleByName("ROLE_WMS");
        GeoServerRole role_wfs = roleService.getRoleByName("ROLE_WFS");
        Assert.assertEquals((long)1L, (long)role_auth.getProperties().size());
        Assert.assertEquals((Object)"4711", (Object)role_auth.getProperties().get("employee"));
        Assert.assertEquals((long)1L, (long)role_wms.getProperties().size());
        Assert.assertEquals((Object)"10 10 20 20", (Object)role_wms.getProperties().get("envelope"));
        Assert.assertEquals((long)0L, (long)role_wfs.getProperties().size());
        for (GeoServerRole role : roleService.getRoles()) {
            if ("ROLE_AUTHENTICATED".equals(role.getAuthority())) {
                Assert.assertEquals((long)1L, (long)role.getProperties().size());
                Assert.assertEquals((Object)"4711", (Object)role.getProperties().get("employee"));
                continue;
            }
            if ("ROLE_WMS".equals(role.getAuthority())) {
                Assert.assertEquals((long)1L, (long)role.getProperties().size());
                Assert.assertEquals((Object)"10 10 20 20", (Object)role.getProperties().get("envelope"));
                continue;
            }
            Assert.assertEquals((long)0L, (long)role.getProperties().size());
        }
        Assert.assertEquals((long)1L, (long)roleService.getGroupNamesForRole(role_wfs).size());
        Assert.assertTrue((boolean)roleService.getGroupNamesForRole(role_wfs).contains("g_wfs"));
        Assert.assertEquals((long)0L, (long)roleService.getUserNamesForRole(role_wfs).size());
        Assert.assertEquals((long)1L, (long)roleService.getRolesForGroup("g_all").size());
        Assert.assertTrue((boolean)roleService.getRolesForGroup("g_all").contains(role_wms));
        GeoServerRole role = (GeoServerRole)roleService.getRolesForGroup("g_all").iterator().next();
        Assert.assertEquals((long)1L, (long)role.getProperties().size());
        Assert.assertEquals((Object)"10 10 20 20", (Object)role.getProperties().get("envelope"));
        Assert.assertEquals((long)1L, (long)roleService.getRolesForUser("user1").size());
        Assert.assertTrue((boolean)roleService.getRolesForUser("user1").contains(role_wms));
        role = (GeoServerRole)roleService.getRolesForUser("user1").iterator().next();
        Assert.assertEquals((long)1L, (long)role.getProperties().size());
        Assert.assertEquals((Object)"10 10 20 20", (Object)role.getProperties().get("envelope"));
        Assert.assertNull((Object)roleService.getParentRole(role_wms));
        Assert.assertEquals((Object)role_wms, (Object)roleService.getParentRole(role_wfs));
    }

    protected void checkValuesInserted(GeoServerRoleService roleService) throws IOException {
        GeoServerRole role_auth = roleService.getRoleByName("ROLE_AUTHENTICATED");
        GeoServerRole role_wfs = roleService.getRoleByName("ROLE_WFS");
        GeoServerRole role_wms = roleService.getRoleByName("ROLE_WMS");
        GeoServerRole role_admin = roleService.getRoleByName(GeoServerRole.ADMIN_ROLE.getAuthority());
        Assert.assertEquals((long)4L, (long)roleService.getRoles().size());
        Assert.assertEquals((long)4L, (long)roleService.getRoleCount());
        Assert.assertTrue((boolean)roleService.getRoles().contains(role_admin));
        Assert.assertTrue((boolean)roleService.getRoles().contains(role_auth));
        Assert.assertTrue((boolean)roleService.getRoles().contains(role_wfs));
        Assert.assertTrue((boolean)roleService.getRoles().contains(role_wms));
        Assert.assertNull((Object)roleService.getRoleByName("xxx"));
        for (GeoServerRole role : roleService.getRoles()) {
            if (role_auth.getAuthority().equals(role.getAuthority())) {
                Assert.assertEquals((long)2L, (long)role.getProperties().size());
                Assert.assertEquals((Object)role.getProperties().getProperty("employee"), (Object)"");
                Assert.assertEquals((Object)role.getProperties().getProperty("bbox"), (Object)"lookupAtRuntime");
                continue;
            }
            Assert.assertEquals((long)0L, (long)role.getProperties().size());
        }
        Assert.assertEquals((long)0L, (long)role_admin.getProperties().size());
        Assert.assertEquals((long)0L, (long)role_wfs.getProperties().size());
        Assert.assertEquals((long)0L, (long)role_wms.getProperties().size());
        Assert.assertEquals((long)2L, (long)role_auth.getProperties().size());
        Assert.assertEquals((Object)role_auth.getProperties().getProperty("employee"), (Object)"");
        Assert.assertEquals((Object)role_auth.getProperties().getProperty("bbox"), (Object)"lookupAtRuntime");
        Assert.assertNull((Object)roleService.getParentRole(role_admin));
        Assert.assertNull((Object)roleService.getParentRole(role_auth));
        Assert.assertEquals((Object)role_auth, (Object)roleService.getParentRole(role_wms));
        Assert.assertEquals((Object)role_auth, (Object)roleService.getParentRole(role_wfs));
        Assert.assertEquals((long)2L, (long)roleService.getParentRole(role_wfs).getProperties().size());
        Assert.assertEquals((Object)roleService.getParentRole(role_wfs).getProperties().getProperty("employee"), (Object)"");
        Assert.assertEquals((Object)roleService.getParentRole(role_wfs).getProperties().getProperty("bbox"), (Object)"lookupAtRuntime");
        Assert.assertEquals((long)0L, (long)roleService.getRolesForUser("xxx").size());
        Assert.assertEquals((long)1L, (long)roleService.getRolesForUser("admin").size());
        Assert.assertTrue((boolean)roleService.getRolesForUser("admin").contains(GeoServerRole.ADMIN_ROLE));
        Assert.assertEquals((long)2L, (long)roleService.getRolesForUser("user1").size());
        Assert.assertTrue((boolean)roleService.getRolesForUser("user1").contains(role_wfs));
        Assert.assertTrue((boolean)roleService.getRolesForUser("user1").contains(role_wms));
        Assert.assertEquals((long)0L, (long)roleService.getRolesForGroup("xxx").size());
        Assert.assertEquals((long)1L, (long)roleService.getRolesForGroup("g_wfs").size());
        Assert.assertTrue((boolean)roleService.getRolesForGroup("g_wfs").contains(role_wfs));
        Assert.assertEquals((long)1L, (long)roleService.getRolesForGroup("g_wms").size());
        Assert.assertTrue((boolean)roleService.getRolesForGroup("g_wms").contains(role_wms));
        Assert.assertEquals((long)2L, (long)roleService.getRolesForGroup("g_all").size());
        Assert.assertTrue((boolean)roleService.getRolesForGroup("g_all").contains(role_wfs));
        Assert.assertTrue((boolean)roleService.getRolesForGroup("g_all").contains(role_wms));
        Assert.assertEquals((long)1L, (long)roleService.getUserNamesForRole(GeoServerRole.ADMIN_ROLE).size());
        Assert.assertTrue((boolean)roleService.getUserNamesForRole(GeoServerRole.ADMIN_ROLE).contains("admin"));
        Assert.assertEquals((long)1L, (long)roleService.getUserNamesForRole(role_wfs).size());
        Assert.assertTrue((boolean)roleService.getUserNamesForRole(role_wfs).contains("user1"));
        Assert.assertEquals((long)1L, (long)roleService.getUserNamesForRole(role_wms).size());
        Assert.assertTrue((boolean)roleService.getUserNamesForRole(role_wms).contains("user1"));
        Assert.assertEquals((long)0L, (long)roleService.getUserNamesForRole(roleService.createRoleObject("xxx")).size());
        Assert.assertEquals((long)2L, (long)roleService.getGroupNamesForRole(role_wfs).size());
        Assert.assertTrue((boolean)roleService.getGroupNamesForRole(role_wfs).contains("g_wfs"));
        Assert.assertTrue((boolean)roleService.getGroupNamesForRole(role_wfs).contains("g_all"));
        Assert.assertEquals((long)2L, (long)roleService.getGroupNamesForRole(role_wms).size());
        Assert.assertTrue((boolean)roleService.getGroupNamesForRole(role_wms).contains("g_wms"));
        Assert.assertTrue((boolean)roleService.getGroupNamesForRole(role_wms).contains("g_all"));
        Assert.assertEquals((long)0L, (long)roleService.getGroupNamesForRole(roleService.createRoleObject("xxx")).size());
        Assert.assertEquals((long)4L, (long)roleService.getParentMappings().size());
        Assert.assertNull(roleService.getParentMappings().get(GeoServerRole.ADMIN_ROLE.getAuthority()));
        Assert.assertNull(roleService.getParentMappings().get(role_auth.getAuthority()));
        Assert.assertEquals(roleService.getParentMappings().get(role_wfs.getAuthority()), (Object)role_auth.getAuthority());
        Assert.assertEquals(roleService.getParentMappings().get(role_wms.getAuthority()), (Object)role_auth.getAuthority());
    }

    protected void checkEmpty(GeoServerUserGroupService userService) throws IOException {
        Assert.assertEquals((long)0L, (long)userService.getUsers().size());
        Assert.assertEquals((long)0L, (long)userService.getUserGroups().size());
        Assert.assertEquals((long)0L, (long)userService.getUserCount());
        Assert.assertEquals((long)0L, (long)userService.getGroupCount());
    }

    protected void checkValuesInserted(GeoServerUserGroupService userGroupService) throws IOException {
        Assert.assertEquals((long)5L, (long)userGroupService.getUsers().size());
        Assert.assertEquals((long)5L, (long)userGroupService.getUserCount());
        GeoServerUser admin = userGroupService.getUserByUsername("admin");
        GeoServerUser user1 = userGroupService.getUserByUsername("user1");
        GeoServerUser user2 = userGroupService.getUserByUsername("user2");
        GeoServerUser disableduser = userGroupService.getUserByUsername("disableduser");
        GeoServerUser groupAdminUser = userGroupService.getUserByUsername("groupAdminUser");
        Assert.assertNull((Object)userGroupService.getUserByUsername("xxx"));
        Assert.assertTrue((boolean)userGroupService.getUsers().contains(admin));
        Assert.assertTrue((boolean)userGroupService.getUsers().contains(user1));
        Assert.assertTrue((boolean)userGroupService.getUsers().contains(user2));
        Assert.assertTrue((boolean)userGroupService.getUsers().contains(disableduser));
        Assert.assertTrue((boolean)userGroupService.getUsers().contains(groupAdminUser));
        for (GeoServerUser user : userGroupService.getUsers()) {
            if (user2.getUsername().equals(user.getUsername())) {
                Assert.assertEquals((long)2L, (long)user.getProperties().size());
                Assert.assertEquals((Object)user.getProperties().getProperty("mail"), (Object)"user2@gmx.com");
                Assert.assertEquals((Object)user.getProperties().getProperty("tel"), (Object)"12-34-38");
                continue;
            }
            Assert.assertEquals((long)0L, (long)user.getProperties().size());
        }
        Assert.assertTrue((boolean)admin.isEnabled());
        Assert.assertTrue((boolean)user1.isEnabled());
        Assert.assertTrue((boolean)user2.isEnabled());
        Assert.assertFalse((boolean)disableduser.isEnabled());
        Assert.assertTrue((boolean)groupAdminUser.isEnabled());
        GeoServerMultiplexingPasswordEncoder encoder = this.getEncoder(userGroupService);
        Assert.assertTrue((boolean)encoder.isPasswordValid(admin.getPassword(), "geoserver", null));
        Assert.assertTrue((boolean)encoder.isPasswordValid(user1.getPassword(), "11111", null));
        Assert.assertTrue((boolean)encoder.isPasswordValid(user2.getPassword(), "22222", null));
        Assert.assertTrue((boolean)encoder.isPasswordValid(disableduser.getPassword(), "", null));
        Assert.assertEquals((long)0L, (long)admin.getProperties().size());
        Assert.assertEquals((long)0L, (long)user1.getProperties().size());
        Assert.assertEquals((long)0L, (long)disableduser.getProperties().size());
        Assert.assertEquals((long)2L, (long)user2.getProperties().size());
        Assert.assertEquals((Object)user2.getProperties().getProperty("mail"), (Object)"user2@gmx.com");
        Assert.assertEquals((Object)user2.getProperties().getProperty("tel"), (Object)"12-34-38");
        Assert.assertEquals((long)4L, (long)userGroupService.getUserGroups().size());
        Assert.assertEquals((long)4L, (long)userGroupService.getGroupCount());
        GeoServerUserGroup admins = userGroupService.getGroupByGroupname("admins");
        GeoServerUserGroup group1 = userGroupService.getGroupByGroupname("group1");
        GeoServerUserGroup group2 = userGroupService.getGroupByGroupname("group2");
        GeoServerUserGroup disabledgroup = userGroupService.getGroupByGroupname("disabledgroup");
        Assert.assertNull((Object)userGroupService.getGroupByGroupname("yyy"));
        Assert.assertTrue((boolean)userGroupService.getUserGroups().contains(admins));
        Assert.assertTrue((boolean)userGroupService.getUserGroups().contains(group1));
        Assert.assertTrue((boolean)userGroupService.getUserGroups().contains(group2));
        Assert.assertTrue((boolean)userGroupService.getUserGroups().contains(disabledgroup));
        Assert.assertTrue((boolean)admins.isEnabled());
        Assert.assertTrue((boolean)group1.isEnabled());
        Assert.assertTrue((boolean)group2.isEnabled());
        Assert.assertFalse((boolean)disabledgroup.isEnabled());
        Assert.assertEquals((long)2L, (long)userGroupService.getUsersForGroup(group1).size());
        Assert.assertTrue((boolean)userGroupService.getUsersForGroup(group1).contains(user1));
        Assert.assertTrue((boolean)userGroupService.getUsersForGroup(group1).contains(user2));
        for (GeoServerUser user : userGroupService.getUsersForGroup(group1)) {
            if (user2.getUsername().equals(user.getUsername())) {
                Assert.assertEquals((long)2L, (long)user.getProperties().size());
                Assert.assertEquals((Object)user.getProperties().getProperty("mail"), (Object)"user2@gmx.com");
                Assert.assertEquals((Object)user.getProperties().getProperty("tel"), (Object)"12-34-38");
                continue;
            }
            Assert.assertEquals((long)0L, (long)user.getProperties().size());
        }
        Assert.assertEquals((long)1L, (long)userGroupService.getUsersForGroup(admins).size());
        Assert.assertTrue((boolean)userGroupService.getUsersForGroup(admins).contains(admin));
        Assert.assertEquals((long)1L, (long)userGroupService.getUsersForGroup(disabledgroup).size());
        Assert.assertTrue((boolean)userGroupService.getUsersForGroup(disabledgroup).contains(disableduser));
        Assert.assertEquals((long)1L, (long)userGroupService.getGroupsForUser(admin).size());
        Assert.assertTrue((boolean)userGroupService.getGroupsForUser(admin).contains(admins));
        Assert.assertEquals((long)1L, (long)userGroupService.getGroupsForUser(user1).size());
        Assert.assertTrue((boolean)userGroupService.getGroupsForUser(user1).contains(group1));
        Assert.assertEquals((long)1L, (long)userGroupService.getGroupsForUser(user2).size());
        Assert.assertTrue((boolean)userGroupService.getGroupsForUser(user2).contains(group1));
        Assert.assertEquals((long)1L, (long)userGroupService.getGroupsForUser(disableduser).size());
        Assert.assertTrue((boolean)userGroupService.getGroupsForUser(disableduser).contains(disabledgroup));
        Assert.assertEquals((long)1L, (long)userGroupService.getGroupsForUser(groupAdminUser).size());
        Assert.assertTrue((boolean)userGroupService.getGroupsForUser(groupAdminUser).contains(group2));
        Assert.assertEquals((long)0L, (long)userGroupService.getUserCountHavingProperty("unknown"));
        Assert.assertEquals((long)userGroupService.getUserCount(), (long)userGroupService.getUserCountNotHavingProperty("unknown"));
        Assert.assertEquals((long)0L, (long)userGroupService.getUserCountHavingPropertyValue("tel", "123"));
        Assert.assertEquals((long)1L, (long)userGroupService.getUserCountHavingProperty("tel"));
        Assert.assertEquals((long)(userGroupService.getUserCount() - 1), (long)userGroupService.getUserCountNotHavingProperty("tel"));
        Assert.assertEquals((long)1L, (long)userGroupService.getUserCountHavingPropertyValue("tel", "12-34-38"));
        Assert.assertEquals((long)0L, (long)userGroupService.getUsersHavingProperty("unknown").size());
        Assert.assertEquals((long)userGroupService.getUserCount(), (long)userGroupService.getUsersNotHavingProperty("unknown").size());
        for (GeoServerUser user : userGroupService.getUsersNotHavingProperty("unknown")) {
            if (user2.getUsername().equals(user.getUsername())) {
                Assert.assertEquals((long)2L, (long)user.getProperties().size());
                Assert.assertEquals((Object)user.getProperties().getProperty("mail"), (Object)"user2@gmx.com");
                Assert.assertEquals((Object)user.getProperties().getProperty("tel"), (Object)"12-34-38");
                continue;
            }
            Assert.assertEquals((long)0L, (long)user.getProperties().size());
        }
        Assert.assertEquals((long)0L, (long)userGroupService.getUsersHavingPropertyValue("tel", "123").size());
        Assert.assertEquals((long)1L, (long)userGroupService.getUsersHavingProperty("mail").size());
        user2 = (GeoServerUser)userGroupService.getUsersHavingProperty("mail").first();
        Assert.assertEquals((Object)user2.getProperties().getProperty("mail"), (Object)"user2@gmx.com");
        Assert.assertEquals((Object)user2.getProperties().getProperty("tel"), (Object)"12-34-38");
        Assert.assertEquals((long)(userGroupService.getUserCount() - 1), (long)userGroupService.getUsersNotHavingProperty("mail").size());
        for (GeoServerUser user : userGroupService.getUsersNotHavingProperty("mail")) {
            Assert.assertEquals((long)0L, (long)user.getProperties().size());
        }
        Assert.assertEquals((long)1L, (long)userGroupService.getUsersHavingPropertyValue("tel", "12-34-38").size());
        user2 = (GeoServerUser)userGroupService.getUsersHavingPropertyValue("tel", "12-34-38").first();
        Assert.assertEquals((Object)user2.getProperties().getProperty("mail"), (Object)"user2@gmx.com");
        Assert.assertEquals((Object)user2.getProperties().getProperty("tel"), (Object)"12-34-38");
    }

    protected void checkValuesModified(GeoServerUserGroupService userGroupService) throws IOException {
        GeoServerUser disableduser = userGroupService.getUserByUsername("disableduser");
        Assert.assertTrue((boolean)disableduser.isEnabled());
        GeoServerMultiplexingPasswordEncoder encoder = this.getEncoder(userGroupService);
        Assert.assertTrue((boolean)encoder.isPasswordValid(disableduser.getPassword(), "hallo", null));
        Assert.assertEquals((long)1L, (long)disableduser.getProperties().size());
        Assert.assertEquals((Object)"miller", (Object)disableduser.getProperties().getProperty("lastname"));
        GeoServerUser user2 = userGroupService.getUserByUsername("user2");
        Assert.assertEquals((long)1L, (long)user2.getProperties().size());
        Assert.assertEquals((Object)"11-22-33", (Object)user2.getProperties().getProperty("tel"));
        GeoServerUserGroup disabledgroup = userGroupService.getGroupByGroupname("disabledgroup");
        Assert.assertTrue((boolean)disabledgroup.isEnabled());
        GeoServerUserGroup group1 = userGroupService.getGroupByGroupname("group1");
        GeoServerUser user1 = userGroupService.getUserByUsername("user1");
        Assert.assertEquals((long)1L, (long)userGroupService.getUsersForGroup(group1).size());
        Assert.assertTrue((boolean)userGroupService.getUsersForGroup(group1).contains(user1));
        Assert.assertEquals((long)0L, (long)userGroupService.getGroupsForUser(user2).size());
        Assert.assertEquals((long)0L, (long)userGroupService.getUsersHavingProperty("mail").size());
        Assert.assertEquals((long)0L, (long)userGroupService.getUsersHavingPropertyValue("tel", "12-34-38").size());
        Assert.assertEquals((long)1L, (long)userGroupService.getUsersHavingPropertyValue("tel", "11-22-33").size());
        user2 = (GeoServerUser)userGroupService.getUsersHavingPropertyValue("tel", "11-22-33").first();
        Assert.assertEquals((Object)"11-22-33", (Object)user2.getProperties().getProperty("tel"));
    }

    protected void checkValuesRemoved(GeoServerUserGroupService userGroupService) throws IOException {
        GeoServerUser admin = GeoServerUser.createDefaultAdmin();
        GeoServerUser user1 = userGroupService.getUserByUsername("user1");
        GeoServerUser disableduser = userGroupService.getUserByUsername("disableduser");
        GeoServerUser groupAdminUser = userGroupService.getUserByUsername("groupAdminUser");
        Assert.assertEquals((long)4L, (long)userGroupService.getUsers().size());
        Assert.assertEquals((long)4L, (long)userGroupService.getUserCount());
        Assert.assertTrue((boolean)userGroupService.getUsers().contains(admin));
        Assert.assertTrue((boolean)userGroupService.getUsers().contains(user1));
        Assert.assertTrue((boolean)userGroupService.getUsers().contains(disableduser));
        Assert.assertTrue((boolean)userGroupService.getUsers().contains(groupAdminUser));
        GeoServerUserGroup admins = userGroupService.getGroupByGroupname("admins");
        GeoServerUserGroup group1 = userGroupService.getGroupByGroupname("group1");
        Assert.assertEquals((long)3L, (long)userGroupService.getUserGroups().size());
        Assert.assertEquals((long)3L, (long)userGroupService.getGroupCount());
        Assert.assertTrue((boolean)userGroupService.getUserGroups().contains(admins));
        Assert.assertTrue((boolean)userGroupService.getUserGroups().contains(group1));
        Assert.assertEquals((long)0L, (long)userGroupService.getGroupsForUser(disableduser).size());
        Assert.assertEquals((long)1L, (long)userGroupService.getUsersForGroup(group1).size());
        Assert.assertTrue((boolean)userGroupService.getUsersForGroup(group1).contains(user1));
        Assert.assertEquals((long)0L, (long)userGroupService.getUsersHavingProperty("mail").size());
        Assert.assertEquals((long)0L, (long)userGroupService.getUsersHavingPropertyValue("tel", "11-22-33").size());
    }

    public void insertValues(GeoServerUserGroupStore userGroupStore) throws Exception {
        GeoServerUser admin = userGroupStore.createUserObject("admin", "geoserver", true);
        GeoServerUser user1 = userGroupStore.createUserObject("user1", "11111", true);
        GeoServerUser user2 = userGroupStore.createUserObject("user2", "22222", true);
        GeoServerUser disableduser = userGroupStore.createUserObject("disableduser", "", false);
        GeoServerUser groupAdminUser = userGroupStore.createUserObject("groupAdminUser", "foo", true);
        user2.getProperties().put("mail", "user2@gmx.com");
        user2.getProperties().put("tel", "12-34-38");
        userGroupStore.addUser(admin);
        userGroupStore.addUser(user1);
        userGroupStore.addUser(user2);
        userGroupStore.addUser(disableduser);
        userGroupStore.addUser(groupAdminUser);
        GeoServerUserGroup admins = userGroupStore.createGroupObject("admins", true);
        GeoServerUserGroup group1 = userGroupStore.createGroupObject("group1", true);
        GeoServerUserGroup group2 = userGroupStore.createGroupObject("group2", true);
        GeoServerUserGroup disabledgroup = userGroupStore.createGroupObject("disabledgroup", false);
        userGroupStore.addGroup(admins);
        userGroupStore.addGroup(group1);
        userGroupStore.addGroup(disabledgroup);
        userGroupStore.addGroup(group2);
        userGroupStore.associateUserToGroup(admin, admins);
        userGroupStore.associateUserToGroup(user1, group1);
        userGroupStore.associateUserToGroup(user2, group1);
        userGroupStore.associateUserToGroup(disableduser, disabledgroup);
        userGroupStore.associateUserToGroup(groupAdminUser, group2);
    }

    public void modifyValues(GeoServerUserGroupStore userGroupStore) throws Exception {
        GeoServerUser disableduser = userGroupStore.getUserByUsername("disableduser");
        disableduser.setEnabled(true);
        disableduser.setPassword("hallo");
        disableduser.getProperties().put("lastname", "miller");
        userGroupStore.updateUser(disableduser);
        GeoServerUser user2 = userGroupStore.getUserByUsername("user2");
        user2.getProperties().remove("mail");
        user2.getProperties().put("tel", "11-22-33");
        userGroupStore.updateUser(user2);
        GeoServerUserGroup disabledgroup = userGroupStore.getGroupByGroupname("disabledgroup");
        disabledgroup.setEnabled(true);
        userGroupStore.updateGroup(disabledgroup);
        GeoServerUserGroup group1 = userGroupStore.getGroupByGroupname("group1");
        userGroupStore.disAssociateUserFromGroup(user2, group1);
    }

    public void removeValues(GeoServerUserGroupStore userGroupStore) throws IOException {
        GeoServerUserGroup disabledGroup;
        GeoServerUser user2 = userGroupStore.getUserByUsername("user2");
        if (user2 != null) {
            userGroupStore.removeUser(user2);
        }
        if ((disabledGroup = userGroupStore.getGroupByGroupname("disabledgroup")) != null) {
            userGroupStore.removeGroup(disabledGroup);
        }
    }

    public static File unpackTestDataDir() throws Exception {
        URL url = AbstractSecurityServiceTest.class.getResource("/data_dir/default");
        if (!"file".equals(url.getProtocol())) {
            File dataDir = File.createTempFile("data", "live", new File("./target"));
            dataDir.delete();
            dataDir.mkdirs();
            FileUtils.copyURLToFile((URL)AbstractSecurityServiceTest.class.getResource("/data_dir/default/dummy.txt"), (File)new File(dataDir, "dummy.txt"));
            return dataDir;
        }
        return URLs.urlToFile((URL)url);
    }

    protected boolean isJDBCTest() {
        return false;
    }

    protected GeoServerMultiplexingPasswordEncoder getEncoder(GeoServerUserGroupService ugService) throws IOException {
        return new GeoServerMultiplexingPasswordEncoder(this.getSecurityManager(), ugService);
    }

    @Override
    protected GeoServerPlainTextPasswordEncoder getPlainTextPasswordEncoder() {
        return (GeoServerPlainTextPasswordEncoder)this.getSecurityManager().loadPasswordEncoder(GeoServerPlainTextPasswordEncoder.class);
    }

    @Override
    protected GeoServerDigestPasswordEncoder getDigestPasswordEncoder() {
        return (GeoServerDigestPasswordEncoder)this.getSecurityManager().loadPasswordEncoder(GeoServerDigestPasswordEncoder.class);
    }

    @Override
    protected GeoServerPBEPasswordEncoder getPBEPasswordEncoder() {
        return (GeoServerPBEPasswordEncoder)this.getSecurityManager().loadPasswordEncoder(GeoServerPBEPasswordEncoder.class, null, Boolean.valueOf(false));
    }

    @Override
    protected GeoServerPBEPasswordEncoder getStrongPBEPasswordEncoder() {
        return (GeoServerPBEPasswordEncoder)this.getSecurityManager().loadPasswordEncoder(GeoServerPBEPasswordEncoder.class, null, Boolean.valueOf(true));
    }

    protected GeoServerEmptyPasswordEncoder getEmptyEncoder() {
        return (GeoServerEmptyPasswordEncoder)this.getSecurityManager().loadPasswordEncoder(GeoServerEmptyPasswordEncoder.class);
    }

    protected String getMasterPassword() {
        return new String(this.getSecurityManager().getMasterPassword());
    }
}

