/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityProvider;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.impl.MemoryRoleServiceConfigImpl;
import org.geoserver.security.config.impl.MemoryUserGroupServiceConfigImpl;
import org.geoserver.security.impl.MemorySecurityConfigValidator;
import org.geoserver.security.impl.ReadOnlyRoleService;
import org.geoserver.security.impl.ReadOnlyUGService;
import org.geoserver.security.validation.SecurityConfigValidator;

public class MemoryReadOnlySecurityProvider
extends GeoServerSecurityProvider {
    public void configure(XStreamPersister xp) {
        super.configure(xp);
        xp.getXStream().alias("memoryreadonlygroupservice", MemoryUserGroupServiceConfigImpl.class);
        xp.getXStream().alias("memoryreadonlyroleservice", MemoryRoleServiceConfigImpl.class);
    }

    public Map<Class<?>, Set<String>> getFieldsForEncryption() {
        HashMap map = new HashMap();
        HashSet<String> fields = new HashSet<String>();
        fields.add("toBeEncrypted");
        map.put(MemoryRoleServiceConfigImpl.class, fields);
        map.put(MemoryUserGroupServiceConfigImpl.class, fields);
        return map;
    }

    public Class<? extends GeoServerUserGroupService> getUserGroupServiceClass() {
        return ReadOnlyUGService.class;
    }

    public GeoServerUserGroupService createUserGroupService(SecurityNamedServiceConfig config) throws IOException {
        return new ReadOnlyUGService();
    }

    public Class<? extends GeoServerRoleService> getRoleServiceClass() {
        return ReadOnlyRoleService.class;
    }

    public GeoServerRoleService createRoleService(SecurityNamedServiceConfig config) throws IOException {
        return new ReadOnlyRoleService();
    }

    public SecurityConfigValidator createConfigurationValidator(GeoServerSecurityManager securityManager) {
        return new MemorySecurityConfigValidator(securityManager);
    }
}

