/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import org.geoserver.template.FeatureWrapper;
import org.geoserver.template.TemplateUtils;
import org.geotools.data.DataUtilities;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureWrapperTest {
    DefaultFeatureCollection features;
    Configuration cfg;

    @Before
    public void setUp() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        SimpleFeatureType featureType = DataUtilities.createType((String)"testType", (String)"string:String,int:Integer,double:Double,geom:Point");
        this.features = new DefaultFeatureCollection(){};
        this.features.add(SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"one", 1, 1.1, gf.createPoint(new Coordinate(1.0, 1.0))}, (String)"fid.1"));
        this.features.add(SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"two", 2, 2.2, gf.createPoint(new Coordinate(2.0, 2.0))}, (String)"fid.2"));
        this.features.add(SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"three", 3, 3.3, gf.createPoint(new Coordinate(3.0, 3.0))}, (String)"fid.3"));
        this.cfg = TemplateUtils.getSafeConfiguration();
        this.cfg.setClassForTemplateLoading(this.getClass(), "");
        this.cfg.setObjectWrapper((ObjectWrapper)this.createWrapper());
    }

    public FeatureWrapper createWrapper() {
        return new FeatureWrapper();
    }

    @Test
    public void testFeatureCollection() throws Exception {
        Template template = this.cfg.getTemplate("FeatureCollection.ftl");
        StringWriter out = new StringWriter();
        template.process((Object)this.features, (Writer)out);
        Assert.assertEquals((Object)"fid.1\nfid.2\nfid.3\n", (Object)out.toString().replaceAll("\r\n", "\n").replaceAll("\r", "\n"));
    }

    @Test
    public void testFeatureSimple() throws Exception {
        Template template = this.cfg.getTemplate("FeatureSimple.ftl");
        StringWriter out = new StringWriter();
        template.process(this.features.iterator().next(), (Writer)out);
        Assert.assertEquals((Object)"one\n1\n1.1\nPOINT (1 1)", (Object)out.toString().replace(',', '.').replaceAll("\r\n", "\n").replaceAll("\r", "\n"));
    }

    @Test
    public void testFeatureDynamic() throws Exception {
        Template template = this.cfg.getTemplate("FeatureDynamic.ftl");
        StringWriter out = new StringWriter();
        template.process(this.features.iterator().next(), (Writer)out);
        Assert.assertEquals((Object)"string=one\nint=1\ndouble=1.1\ngeom=POINT (1 1)\n", (Object)out.toString().replace(',', '.').replaceAll("\r\n", "\n").replaceAll("\r", "\n"));
    }

    @Test
    public void testFeatureSequence() throws Exception {
        Template template = this.cfg.getTemplate("FeatureSequence.ftl");
        StringWriter out = new StringWriter();
        template.process((Object)this.features, (Writer)out);
        Assert.assertEquals((Object)"three\none\n3", (Object)out.toString().replaceAll("\r\n", "\n").replaceAll("\r", "\n"));
    }
}

