/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import java.io.File;
import java.io.IOException;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.data.DataUtilities;
import org.junit.Assert;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeoServerTemplateLoaderTest
extends GeoServerSystemTestSupport {
    public void test() throws Exception {
        File data = ((SystemTestData)this.getTestData()).getDataDirectoryRoot();
        File templates = new File(data, "templates");
        File featureTypes = new File(data, "featureTypes");
        File featureType1 = new File(featureTypes, "ft1");
        featureType1.mkdir();
        File featureType2 = new File(featureTypes, "ft2");
        featureType2.mkdir();
        GeoServerResourceLoader resources = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        GeoServerTemplateLoader templateLoader = new GeoServerTemplateLoader(this.getClass(), resources);
        File expected = new File(templates, "1.ftl");
        expected.createNewFile();
        File actual = (File)templateLoader.findTemplateSource("1.ftl");
        Assert.assertEquals((Object)expected.getCanonicalPath(), (Object)actual.getCanonicalPath());
        expected = new File(featureType1, "2.ftl");
        expected.createNewFile();
        actual = (File)templateLoader.findTemplateSource("ft1/2.ftl");
        Assert.assertEquals((Object)expected.getCanonicalPath(), (Object)actual.getCanonicalPath());
        actual = (File)templateLoader.findTemplateSource("2.ftl");
        Assert.assertNull((Object)actual);
        Object source = templateLoader.findTemplateSource("FeatureSimple.ftl");
        Assert.assertNotNull((Object)source);
        Assert.assertFalse((boolean)(source instanceof File));
        templateLoader.getReader(source, "UTF-8");
    }

    public void testRemoteType() throws Exception {
        SimpleFeatureType ft = DataUtilities.createType((String)"remoteType", (String)"the_geom:MultiPolygon,FID:String,ADDRESS:String");
        GeoServerResourceLoader resources = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        GeoServerTemplateLoader loader = new GeoServerTemplateLoader(this.getClass(), resources);
        loader.findTemplateSource("header.ftl");
    }

    void delete(File file) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.delete(files[i]);
            }
        }
        file.delete();
    }
}

