/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.awt.RenderingHints;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import org.apache.commons.codec.binary.Base64;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.GeoServerLoaderProxy;
import org.geoserver.data.test.TestData;
import org.geoserver.logging.LoggingUtils;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ContextLoadedEvent;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.test.CodeExpectingHttpServletResponse;
import org.geoserver.test.DirectoryResourceLoader;
import org.geoserver.test.GeoServerTestApplicationContext;
import org.geoserver.test.OneTimeSetupTest;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Log4JLoggerFactory;
import org.geotools.util.logging.LoggerFactory;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.XSD;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.mock.web.MockServletContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerInterceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class GeoServerAbstractTestSupport
extends OneTimeSetupTest {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.test");
    protected static GeoServerTestApplicationContext applicationContext;
    protected static TestData testData;
    private boolean validating = false;
    String username;
    String password;

    protected abstract TestData buildTestData() throws Exception;

    public TestData getTestData() {
        return testData;
    }

    protected void runTest() throws Throwable {
        if (this.getTestData().isTestDataAvailable()) {
            super.runTest();
        } else {
            LOGGER.warning("Skipping " + ((Object)((Object)this)).getClass() + "." + this.getName() + " since test data is not available");
        }
    }

    @Override
    protected void tearDownInternal() throws Exception {
        super.tearDownInternal();
        this.username = null;
        this.password = null;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    @Override
    protected void oneTimeSetUp() throws Exception {
        if (System.getProperty("org.geotools.referencing.forceXY") == null || !"http".equals(Hints.getSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING))) {
            System.setProperty("org.geotools.referencing.forceXY", "true");
            Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING, (Object)"http");
            CRS.reset((String)"all");
        }
        testData = this.buildTestData();
        testData.setUp();
        try {
            Logging.ALL.setLoggerFactory((LoggerFactory)Log4JLoggerFactory.getInstance());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not configure log4j logging redirection", e);
        }
        System.setProperty("RELINQUISH_LOG4J_CONTROL", "true");
        GeoServerResourceLoader loader = new GeoServerResourceLoader(testData.getDataDirectoryRoot());
        LoggingUtils.configureGeoServerLogging((GeoServerResourceLoader)loader, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream(this.getLogConfiguration()), (boolean)false, (boolean)true, null);
        GeoServerLoader.setLegacy((boolean)this.useLegacyDataDirectory());
        if (testData.isTestDataAvailable()) {
            DefaultResourceLoader rl;
            if (testData.getDataDirectoryRoot().canWrite()) {
                File webinf = new File(testData.getDataDirectoryRoot(), "WEB-INF");
                webinf.mkdir();
                rl = new DirectoryResourceLoader(testData.getDataDirectoryRoot());
            } else {
                rl = new DefaultResourceLoader();
            }
            MockServletContext servletContext = new MockServletContext((ResourceLoader)rl);
            servletContext.setInitParameter("GEOSERVER_DATA_DIR", testData.getDataDirectoryRoot().getPath());
            servletContext.setMinorVersion(4);
            servletContext.setInitParameter("serviceStrategy", "PARTIAL-BUFFER2");
            applicationContext = new GeoServerTestApplicationContext(this.getSpringContextLocations(), (ServletContext)servletContext);
            applicationContext.setValidating(this.validating);
            applicationContext.setUseLegacyGeoServerLoader(this.useLegacyDataDirectory());
            applicationContext.refresh();
            applicationContext.publishEvent((ApplicationEvent)new ContextLoadedEvent((ApplicationContext)applicationContext));
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)applicationContext);
        }
    }

    protected boolean useLegacyDataDirectory() {
        return true;
    }

    protected String[] getSpringContextLocations() {
        return new String[]{"classpath*:/applicationContext.xml", "classpath*:/applicationSecurityContext.xml"};
    }

    protected String getLogConfiguration() {
        return "/TEST_LOGGING.properties";
    }

    protected URL getServicesFile() {
        return GeoServerAbstractTestSupport.class.getResource("services.xml");
    }

    protected boolean isMemoryCleanRequired() {
        return false;
    }

    @Override
    protected void oneTimeTearDown() throws Exception {
        if (this.getTestData().isTestDataAvailable()) {
            try {
                GeoServerAbstractTestSupport.disposeIfExists(this.getXSD11());
                GeoServerAbstractTestSupport.disposeIfExists(this.getXSD10());
                applicationContext.close();
                GeoServerExtensionsHelper.init(null);
                if (this.isMemoryCleanRequired()) {
                    System.gc();
                    System.runFinalization();
                }
                if (this.getTestData() != null) {
                    this.getTestData().tearDown();
                }
            }
            finally {
                applicationContext = null;
                testData = null;
            }
        }
    }

    protected void reloadCatalogAndConfiguration() throws Exception {
        GeoServerLoaderProxy loader = (GeoServerLoaderProxy)GeoServerExtensions.bean(GeoServerLoaderProxy.class, (ApplicationContext)applicationContext);
        loader.reload();
    }

    protected Catalog getCatalog() {
        return (Catalog)applicationContext.getBean("catalog");
    }

    protected GeoServer getGeoServer() {
        return (GeoServer)applicationContext.getBean("geoServer");
    }

    protected GeoServerSecurityManager getSecurityManager() {
        return (GeoServerSecurityManager)applicationContext.getBean("geoServerSecurityManager");
    }

    protected static void disposeIfExists(XSD xsd) {
        if (xsd != null) {
            xsd.dispose();
        }
    }

    protected XSD getXSD11() {
        if (applicationContext.containsBean("wfsXsd-1.1")) {
            return (XSD)applicationContext.getBean("wfsXsd-1.1");
        }
        return null;
    }

    protected XSD getXSD10() {
        if (applicationContext.containsBean("wfsXsd-1.0")) {
            return (XSD)applicationContext.getBean("wfsXsd-1.0");
        }
        return null;
    }

    protected GeoServerResourceLoader getResourceLoader() {
        return (GeoServerResourceLoader)applicationContext.getBean("resourceLoader");
    }

    protected GeoServerDataDirectory getDataDirectory() {
        return new GeoServerDataDirectory(this.getResourceLoader());
    }

    protected SimpleFeatureSource getFeatureSource(QName typeName) throws IOException {
        FeatureTypeInfo ft = this.getFeatureTypeInfo(typeName);
        return DataUtilities.simple((FeatureSource)ft.getFeatureSource(null, null));
    }

    protected FeatureTypeInfo getFeatureTypeInfo(QName typename) {
        return this.getCatalog().getFeatureTypeByName(typename.getNamespaceURI(), typename.getLocalPart());
    }

    protected void authenticate(String username, String password) {
        this.username = username;
        this.password = password;
    }

    protected FeatureTypeInfo getFeatureTypeInfo(String typename) {
        return this.getFeatureTypeInfo(this.resolveLayerName(typename));
    }

    protected QName resolveLayerName(String typename) {
        int i = typename.indexOf(":");
        String prefix = typename.substring(0, i);
        String name = typename.substring(i + 1);
        NamespaceInfo ns = this.getCatalog().getNamespaceByPrefix(prefix);
        QName qname = new QName(ns.getURI(), name, ns.getPrefix());
        return qname;
    }

    public String getLayerId(QName layerName) {
        if (layerName.getPrefix() != null) {
            return layerName.getPrefix() + ":" + layerName.getLocalPart();
        }
        return layerName.getLocalPart();
    }

    protected MockHttpServletRequest createRequest(String path) {
        GeoServerMockHttpServletRequest request = new GeoServerMockHttpServletRequest();
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setRequestURI(ResponseUtils.stripQueryString((String)ResponseUtils.appendPath((String[])new String[]{"/geoserver/", path})));
        request.setQueryString(ResponseUtils.getQueryString((String)path));
        request.setRemoteAddr("127.0.0.1");
        request.setServletPath(ResponseUtils.makePathAbsolute((String)ResponseUtils.stripRemainingPath((String)path)));
        request.setPathInfo(ResponseUtils.makePathAbsolute((String)ResponseUtils.stripBeginningPath((String)path)));
        if (this.username != null) {
            String token = this.username + ":";
            if (this.password != null) {
                token = token + this.password;
            }
            request.addHeader("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])token.getBytes())));
        }
        this.kvp(request, path);
        MockHttpSession session = new MockHttpSession((ServletContext)new MockServletContext());
        request.setSession((HttpSession)session);
        request.setUserPrincipal(null);
        return request;
    }

    protected MockHttpServletRequest createRequest(String path, Map kvp) {
        StringBuffer q = new StringBuffer();
        for (Map.Entry entry : kvp.entrySet()) {
            q.append(entry.getKey()).append("=").append(entry.getValue());
            q.append("&");
        }
        q.setLength(q.length() - 1);
        return this.createRequest(ResponseUtils.appendQueryString((String)path, (String)q.toString()));
    }

    protected InputStream get(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        return new ByteArrayInputStream(response.getContentAsString().getBytes());
    }

    protected MockHttpServletResponse getAsServletResponse(String path) throws Exception {
        return this.getAsServletResponse(path, null);
    }

    protected MockHttpServletResponse getAsServletResponse(String path, String charset) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("GET");
        request.setContent(new byte[0]);
        return this.dispatch((HttpServletRequest)request, charset);
    }

    protected InputStream post(String path) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("POST");
        request.setContentType("application/x-www-form-urlencoded");
        request.setContent(new byte[0]);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        return new ByteArrayInputStream(response.getContentAsString().getBytes());
    }

    protected InputStream put(String path) throws Exception {
        return this.put(path, "");
    }

    protected InputStream put(String path, String body) throws Exception {
        return this.put(path, body, "text/plain");
    }

    protected InputStream put(String path, String body, String contentType) throws Exception {
        return this.put(path, body.getBytes(), contentType);
    }

    protected InputStream put(String path, byte[] body, String contentType) throws Exception {
        MockHttpServletResponse response = this.putAsServletResponse(path, body, contentType);
        return new ByteArrayInputStream(response.getContentAsString().getBytes());
    }

    protected MockHttpServletResponse putAsServletResponse(String path) throws Exception {
        return this.putAsServletResponse(path, new byte[0], "text/plain");
    }

    protected MockHttpServletResponse putAsServletResponse(String path, String body, String contentType) throws Exception {
        return this.putAsServletResponse(path, body != null ? body.getBytes() : (byte[])null, contentType);
    }

    protected MockHttpServletResponse putAsServletResponse(String path, byte[] body, String contentType) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("PUT");
        request.setContentType(contentType);
        request.setContent(body);
        request.addHeader("Content-type", (Object)contentType);
        return this.dispatch((HttpServletRequest)request);
    }

    protected InputStream post(String path, String xml) throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse(path, xml);
        return new ByteArrayInputStream(response.getContentAsString().getBytes());
    }

    protected MockHttpServletResponse postAsServletResponse(String path, String xml) throws Exception {
        return this.postAsServletResponse(path, xml, "application/xml");
    }

    protected ByteArrayInputStream getBinaryInputStream(MockHttpServletResponse response) {
        return new ByteArrayInputStream(response.getContentAsByteArray());
    }

    protected InputStream post(String path, String body, String contentType) throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse(path, body, contentType);
        return new ByteArrayInputStream(response.getContentAsString().getBytes());
    }

    protected MockHttpServletResponse postAsServletResponse(String path, String body, String contentType) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("POST");
        request.setContentType(contentType);
        request.setContent(body.getBytes("UTF-8"));
        request.addHeader("Content-type", (Object)contentType);
        return this.dispatch((HttpServletRequest)request);
    }

    protected MockHttpServletResponse deleteAsServletResponse(String path) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("DELETE");
        return this.dispatch((HttpServletRequest)request);
    }

    protected Document getAsDOM(String path) throws Exception {
        return this.getAsDOM(path, true);
    }

    protected JSON getAsJSON(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        return this.json(response);
    }

    protected JSON json(MockHttpServletResponse response) throws UnsupportedEncodingException {
        String content = response.getContentAsString();
        return JSONSerializer.toJSON((Object)content);
    }

    protected Document getAsDOM(String path, boolean skipDTD) throws Exception {
        return this.dom(this.get(path), skipDTD);
    }

    protected Document postAsDOM(String path) throws Exception {
        return this.postAsDOM(path, (List<Exception>)null);
    }

    protected Document postAsDOM(String path, List<Exception> validationErrors) throws Exception {
        return this.dom(this.post(path));
    }

    protected Document postAsDOM(String path, String xml) throws Exception {
        return this.postAsDOM(path, xml, null);
    }

    protected Document postAsDOM(String path, String xml, List<Exception> validationErrors) throws Exception {
        return this.dom(this.post(path, xml));
    }

    protected String getAsString(String path) throws Exception {
        return this.string(this.get(path));
    }

    protected Document dom(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        return this.dom(is, true);
    }

    protected Document dom(InputStream input, boolean skipDTD) throws ParserConfigurationException, SAXException, IOException {
        if (skipDTD) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EmptyResolver());
            Document dom = builder.parse(input);
            return dom;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(input);
    }

    protected void checkValidationErorrs(Document dom, String schemaLocation) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new File(schemaLocation));
        this.checkValidationErrors(dom, schema);
    }

    protected void checkValidationErrors(Document dom, Schema schema) throws SAXException, IOException {
        Validator validator = schema.newValidator();
        final ArrayList validationErrors = new ArrayList();
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                System.out.println(exception.getMessage());
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                validationErrors.add(exception);
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                validationErrors.add(exception);
            }
        });
        validator.validate(new DOMSource(dom));
        if (validationErrors != null && validationErrors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Exception ve : validationErrors) {
                sb.append(ve.getMessage()).append("\n");
            }
            GeoServerAbstractTestSupport.fail((String)sb.toString());
        }
    }

    protected void checkOws10Exception(Document dom) throws Exception {
        this.checkOws10Exception(dom, null, null);
    }

    protected void checkOws10Exception(Document dom, String exceptionCode) throws Exception {
        this.checkOws10Exception(dom, exceptionCode, null);
    }

    protected void checkOws10Exception(Document dom, String exceptionCode, String locator) throws Exception {
        Element root = dom.getDocumentElement();
        GeoServerAbstractTestSupport.assertEquals((String)"ows:ExceptionReport", (String)root.getNodeName());
        GeoServerAbstractTestSupport.assertEquals((String)"1.0.0", (String)root.getAttribute("version"));
        GeoServerAbstractTestSupport.assertEquals((String)"http://www.opengis.net/ows", (String)root.getAttribute("xmlns:ows"));
        GeoServerAbstractTestSupport.assertEquals((int)1, (int)dom.getElementsByTagName("ows:Exception").getLength());
        Element ex = (Element)dom.getElementsByTagName("ows:Exception").item(0);
        if (exceptionCode != null) {
            GeoServerAbstractTestSupport.assertEquals((String)exceptionCode, (String)ex.getAttribute("exceptionCode"));
        }
        if (locator != null) {
            GeoServerAbstractTestSupport.assertEquals((String)locator, (String)ex.getAttribute("locator"));
        }
    }

    protected void checkOws11Exception(Document dom) throws Exception {
        this.checkOws11Exception(dom, null);
    }

    protected void checkOws11Exception(Document dom, String exceptionCode) throws Exception {
        Element root = dom.getDocumentElement();
        GeoServerAbstractTestSupport.assertEquals((String)"ows:ExceptionReport", (String)root.getNodeName());
        GeoServerAbstractTestSupport.assertEquals((String)"1.1.0", (String)root.getAttribute("version"));
        GeoServerAbstractTestSupport.assertEquals((String)"http://www.opengis.net/ows/1.1", (String)root.getAttribute("xmlns:ows"));
        if (exceptionCode != null) {
            GeoServerAbstractTestSupport.assertEquals((int)1, (int)dom.getElementsByTagName("ows:Exception").getLength());
            Element ex = (Element)dom.getElementsByTagName("ows:Exception").item(0);
            GeoServerAbstractTestSupport.assertEquals((String)exceptionCode, (String)ex.getAttribute("exceptionCode"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String string(InputStream input) throws Exception {
        BufferedReader reader = null;
        StringBuffer sb = new StringBuffer();
        char[] buf = new char[8192];
        try {
            reader = new BufferedReader(new InputStreamReader(input));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return sb.toString();
    }

    protected void print(Document dom) throws Exception {
        TransformerFactory txFactory = TransformerFactory.newInstance();
        try {
            txFactory.setAttribute("{http://xml.apache.org/xalan}indent-number", 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Transformer tx = txFactory.newTransformer();
        tx.setOutputProperty("method", "xml");
        tx.setOutputProperty("indent", "yes");
        tx.transform(new DOMSource(dom), new StreamResult(new OutputStreamWriter((OutputStream)System.out, "utf-8")));
    }

    protected void print(InputStream in) throws Exception {
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = r.readLine()) != null) {
            System.out.println(line);
        }
    }

    protected void print(JSON json) {
        System.out.println(json.toString(2));
    }

    protected Element getFirstElementByTagName(Element element, String name) {
        NodeList elements = element.getElementsByTagName(name);
        if (elements.getLength() > 0) {
            return (Element)elements.item(0);
        }
        return null;
    }

    protected Element getFirstElementByTagName(Document dom, String name) {
        return this.getFirstElementByTagName(dom.getDocumentElement(), name);
    }

    private void kvp(MockHttpServletRequest request, String path) {
        Map params = KvpUtils.parseQueryString((String)path);
        for (String key : params.keySet()) {
            String[] values;
            Object value = params.get(key);
            if (value instanceof String) {
                request.addParameter(key, (String)value);
                continue;
            }
            for (String v : values = (String[])value) {
                request.addParameter(key, v);
            }
        }
    }

    protected MockHttpServletResponse dispatch(HttpServletRequest request) throws Exception {
        return this.dispatch(request, (String)null);
    }

    protected MockHttpServletResponse dispatch(HttpServletRequest request, String charset) throws Exception {
        MockHttpServletResponse response = null;
        if (charset == null) {
            response = new MockHttpServletResponse(){

                public void setCharacterEncoding(String encoding) {
                }
            };
        } else {
            response = new MockHttpServletResponse();
            response.setCharacterEncoding(charset);
        }
        this.dispatch(request, (HttpServletResponse)response);
        return response;
    }

    protected DispatcherServlet getDispatcher() throws Exception {
        ServletContext context = applicationContext.getServletContext();
        MockServletConfig config = new MockServletConfig(context, "dispatcher");
        DispatcherServlet dispatcher = new DispatcherServlet();
        dispatcher.setContextConfigLocation(GeoServerAbstractTestSupport.class.getResource("dispatcher-servlet.xml").toString());
        dispatcher.init((ServletConfig)config);
        return dispatcher;
    }

    private void dispatch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        final DispatcherServlet dispatcher = this.getDispatcher();
        HttpServlet servlet = new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                try {
                    List interceptors = GeoServerExtensions.extensions(HandlerInterceptor.class, (ApplicationContext)applicationContext);
                    for (HandlerInterceptor interceptor : interceptors) {
                        interceptor.preHandle(request, response, (Object)dispatcher);
                    }
                    dispatcher.service((ServletRequest)request, (ServletResponse)response);
                    for (HandlerInterceptor interceptor : interceptors) {
                        interceptor.postHandle(request, response, (Object)dispatcher, null);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (ServletException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw (IOException)new IOException("Failed to handle the request").initCause(e);
                }
            }
        };
        List<Filter> filterList = this.getFilters();
        MockFilterChain chain = filterList != null ? new MockFilterChain((Servlet)servlet, filterList.toArray(new Filter[filterList.size()])) : new MockFilterChain((Servlet)servlet);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected List<Filter> getFilters() {
        return null;
    }

    protected void assertStatusCodeForGet(int code, String path) throws Exception {
        this.assertStatusCodeForRequest(code, "GET", path, "", "");
    }

    protected void assertStatusCodeForPost(int code, String path, String body, String type) throws Exception {
        this.assertStatusCodeForRequest(code, "POST", path, body, type);
    }

    protected void assertStatusCodeForPut(int code, String path, String body, String type) throws Exception {
        this.assertStatusCodeForRequest(code, "PUT", path, body, type);
    }

    protected void assertStatusCodeForRequest(int code, String method, String path, String body, String type) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod(method);
        request.setContent(body.getBytes("UTF-8"));
        request.setContentType(type);
        CodeExpectingHttpServletResponse response = new CodeExpectingHttpServletResponse((HttpServletResponse)new MockHttpServletResponse());
        this.dispatch((HttpServletRequest)request, (HttpServletResponse)response);
        GeoServerAbstractTestSupport.assertEquals((int)code, (int)response.getErrorCode());
    }

    private static class GeoServerDelegatingServletInputStream
    extends ServletInputStream {
        private byte[] myBody;
        private int myOffset = 0;
        private int myMark = -1;

        public GeoServerDelegatingServletInputStream(byte[] body) {
            this.myBody = body;
        }

        public int available() {
            return this.myBody.length - this.myOffset;
        }

        public void close() {
        }

        public void mark(int readLimit) {
            this.myMark = this.myOffset;
        }

        public void reset() {
            if (this.myMark < 0 || this.myMark >= this.myBody.length) {
                throw new IllegalStateException("Can't reset when no mark was set.");
            }
            this.myOffset = this.myMark;
        }

        public boolean markSupported() {
            return true;
        }

        public int read() {
            byte[] b = new byte[1];
            return this.read(b, 0, 1) == -1 ? -1 : b[0];
        }

        public int read(byte[] b) {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int offset, int length) {
            int i;
            int realOffset = offset + this.myOffset;
            if (realOffset >= this.myBody.length) {
                return -1;
            }
            for (i = 0; i < length && i + this.myOffset < this.myBody.length; ++i) {
                b[offset + i] = this.myBody[this.myOffset + i];
            }
            this.myOffset += i;
            return i;
        }

        public int readLine(byte[] b, int offset, int length) {
            int i;
            int realOffset = offset + this.myOffset;
            for (i = 0; i < length && i + this.myOffset < this.myBody.length; ++i) {
                b[offset + i] = this.myBody[this.myOffset + i];
                if (this.myBody[this.myOffset + i] == 10) break;
            }
            this.myOffset += i;
            return i;
        }
    }

    public static class GeoServerMockHttpServletRequest
    extends MockHttpServletRequest {
        private byte[] myBody;

        public GeoServerMockHttpServletRequest() {
        }

        public GeoServerMockHttpServletRequest(String method, String requestURI) {
            super(method, requestURI);
        }

        public void setContent(byte[] body) {
            this.myBody = body;
        }

        public ServletInputStream getInputStream() {
            return new GeoServerDelegatingServletInputStream(this.myBody);
        }

        public String toString() {
            return "GeoServerMockHttpServletRequest " + this.getMethod() + " " + this.getRequestURI();
        }
    }

    static class EmptyResolver
    implements EntityResolver {
        EmptyResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            StringReader reader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            InputSource source = new InputSource(reader);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
    }
}

