/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.threadlocals;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.geoserver.threadlocals.ThreadLocalTransfer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractThreadLocalTransferTest {
    protected ExecutorService executor;

    @Before
    public void setupExecutor() {
        this.executor = Executors.newCachedThreadPool();
    }

    @After
    public void stopExecutor() {
        this.executor.shutdown();
    }

    public void testThreadLocalTransfer(ThreadLocalTransferCallable callable) throws InterruptedException, ExecutionException {
        Future<Void> future = this.executor.submit(callable);
        future.get();
    }

    protected static abstract class ThreadLocalTransferCallable
    implements Callable<Void> {
        Thread originalThread;
        ThreadLocalTransfer transfer;
        Map<String, Object> storage = new HashMap<String, Object>();

        public ThreadLocalTransferCallable(ThreadLocalTransfer transfer) {
            this.originalThread = Thread.currentThread();
            this.transfer = transfer;
            this.transfer.collect(this.storage);
        }

        @Override
        public Void call() throws Exception {
            Assert.assertNotEquals((Object)this.originalThread, (Object)Thread.currentThread());
            this.transfer.apply(this.storage);
            this.assertThreadLocalApplied();
            this.transfer.cleanup();
            this.assertThreadLocalCleaned();
            return null;
        }

        abstract void assertThreadLocalCleaned();

        abstract void assertThreadLocalApplied();
    }
}

