/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.util.logging.Level;
import org.easymock.EasyMock;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.util.CacheProvider;
import org.geoserver.util.DefaultCacheProvider;
import org.geoserver.util.LoggerRule;
import org.geotools.util.logging.Logging;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class DefaultCacheProviderTest {
    @Rule
    public GeoServerExtensionsHelper.ExtensionsHelperRule extensions = new GeoServerExtensionsHelper.ExtensionsHelperRule();
    @Rule
    public LoggerRule logging = new LoggerRule(Logging.getLogger(DefaultCacheProvider.class), Level.WARNING);

    @Test
    public void testDefault() {
        CacheProvider provider = DefaultCacheProvider.findProvider();
        Assert.assertThat((Object)provider, (Matcher)Matchers.instanceOf(DefaultCacheProvider.class));
    }

    private CacheProvider addMockProvider(String name) {
        CacheProvider provider = (CacheProvider)EasyMock.createMock((String)name, CacheProvider.class);
        this.extensions.singleton(name, provider, CacheProvider.class);
        return provider;
    }

    @Test
    public void testFindInContext() {
        CacheProvider testCacheProvider1 = this.addMockProvider("testCacheProvider1");
        EasyMock.replay((Object[])new Object[]{testCacheProvider1});
        CacheProvider provider = DefaultCacheProvider.findProvider();
        Assert.assertThat((Object)provider, (Matcher)Matchers.sameInstance((Object)testCacheProvider1));
        EasyMock.verify((Object[])new Object[]{testCacheProvider1});
    }

    @Test
    public void testFindTwoInContext() {
        CacheProvider testCacheProvider1 = this.addMockProvider("testCacheProvider1");
        CacheProvider testCacheProvider2 = this.addMockProvider("testCacheProvider2");
        EasyMock.replay((Object[])new Object[]{testCacheProvider1, testCacheProvider2});
        CacheProvider provider = DefaultCacheProvider.findProvider();
        Assert.assertThat((Object)provider, (Matcher)Matchers.anyOf((Matcher)Matchers.sameInstance((Object)testCacheProvider1), (Matcher)Matchers.sameInstance((Object)testCacheProvider2)));
        String providerName = "testCacheProvider2";
        if (provider == testCacheProvider1) {
            providerName = "testCacheProvider1";
        }
        this.logging.assertLogged(Matchers.allOf((Matcher)Matchers.hasProperty((String)"level", (Matcher)Matchers.is((Object)Level.WARNING)), (Matcher)Matchers.hasProperty((String)"parameters", (Matcher)Matchers.arrayContainingInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)providerName), Matchers.anyOf((Matcher)Matchers.equalTo((Object)"testCacheProvider1, testCacheProvider2"), (Matcher)Matchers.equalTo((Object)"testCacheProvider2, testCacheProvider1")), Matchers.equalTo((Object)"GEOSERVER_DEFAULT_CACHE_PROVIDER")}))));
        EasyMock.verify((Object[])new Object[]{testCacheProvider1, testCacheProvider2});
    }

    @Test
    public void testResolveWithProperty() {
        CacheProvider testCacheProvider1 = this.addMockProvider("testCacheProvider1");
        CacheProvider testCacheProvider2 = this.addMockProvider("testCacheProvider2");
        this.extensions.property("GEOSERVER_DEFAULT_CACHE_PROVIDER", "testCacheProvider1");
        EasyMock.replay((Object[])new Object[]{testCacheProvider1, testCacheProvider2});
        CacheProvider provider = DefaultCacheProvider.findProvider();
        Assert.assertThat((Object)provider, (Matcher)Matchers.sameInstance((Object)testCacheProvider1));
        EasyMock.verify((Object[])new Object[]{testCacheProvider1, testCacheProvider2});
        EasyMock.reset((Object[])new Object[]{testCacheProvider1, testCacheProvider2});
        this.extensions.property("GEOSERVER_DEFAULT_CACHE_PROVIDER", "testCacheProvider2");
        EasyMock.replay((Object[])new Object[]{testCacheProvider1, testCacheProvider2});
        provider = DefaultCacheProvider.findProvider();
        Assert.assertThat((Object)provider, (Matcher)Matchers.sameInstance((Object)testCacheProvider2));
        EasyMock.verify((Object[])new Object[]{testCacheProvider1, testCacheProvider2});
    }

    @Test
    public void testPropertyPriority() {
        CacheProvider testCacheProvider3 = this.addMockProvider("testCacheProvider3");
        CacheProvider testCacheProvider2 = this.addMockProvider("testCacheProvider2");
        this.extensions.property("GEOSERVER_DEFAULT_CACHE_PROVIDER", "testCacheProvider1,testCacheProvider2,testCacheProvider3");
        EasyMock.replay((Object[])new Object[]{testCacheProvider3, testCacheProvider2});
        CacheProvider provider = DefaultCacheProvider.findProvider();
        Assert.assertThat((Object)provider, (Matcher)Matchers.sameInstance((Object)testCacheProvider2));
        EasyMock.verify((Object[])new Object[]{testCacheProvider3, testCacheProvider2});
    }
}

