/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.util.Set;
import org.geoserver.util.AllowListEntityResolver;
import org.geoserver.util.EntityResolverProvider;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EntityResolverProviderTest {
    @Test
    public void testAllowListDefaults() throws Exception {
        Set allowed = EntityResolverProvider.entityResolutionAllowlist((String)"");
        Assert.assertNotNull((String)"defaults for empty", (Object)allowed);
        Assert.assertEquals((long)4L, (long)allowed.size());
        Assert.assertTrue((boolean)allowed.contains(AllowListEntityResolver.W3C));
        Assert.assertTrue((boolean)allowed.contains(AllowListEntityResolver.INSPIRE));
        Assert.assertTrue((boolean)allowed.contains(AllowListEntityResolver.OGC1));
        Assert.assertTrue((boolean)allowed.contains(AllowListEntityResolver.OGC2));
        allowed = EntityResolverProvider.entityResolutionAllowlist(null);
        Assert.assertNotNull((String)"defaults for null", (Object)allowed);
        Assert.assertEquals((long)4L, (long)allowed.size());
        Assert.assertTrue((boolean)allowed.contains(AllowListEntityResolver.W3C));
        Assert.assertTrue((boolean)allowed.contains(AllowListEntityResolver.INSPIRE));
        Assert.assertTrue((boolean)allowed.contains(AllowListEntityResolver.OGC1));
        Assert.assertTrue((boolean)allowed.contains(AllowListEntityResolver.OGC2));
    }

    @Test
    public void testAllowListUnrestriced() throws Exception {
        Set allowed = EntityResolverProvider.entityResolutionAllowlist((String)"*");
        Assert.assertNull((String)"null for Unrestricted", (Object)allowed);
    }

    @Test
    public void testAllowListDomains() throws Exception {
        Set allowed = EntityResolverProvider.entityResolutionAllowlist((String)"how2map.com");
        Assert.assertNotNull((Object)allowed);
        Assert.assertEquals((long)5L, (long)allowed.size());
        Assert.assertTrue((boolean)allowed.contains(AllowListEntityResolver.W3C));
        Assert.assertTrue((boolean)allowed.contains(AllowListEntityResolver.INSPIRE));
        Assert.assertTrue((boolean)allowed.contains(AllowListEntityResolver.OGC1));
        Assert.assertTrue((boolean)allowed.contains(AllowListEntityResolver.OGC2));
        Assert.assertTrue((boolean)allowed.contains("how2map.com"));
    }

    @Test
    public void testNoWildcard() throws Exception {
        Set everything = EntityResolverProvider.entityResolutionAllowlist((String)AllowListEntityResolver.UNRESTRICTED);
        Assert.assertNull((String)"* allows everything", (Object)everything);
        Set allowed = EntityResolverProvider.entityResolutionAllowlist((String)"foo*bar");
        Assert.assertNotNull((Object)allowed);
        Assert.assertTrue((boolean)allowed.contains("foo*bar"));
    }

    @Test
    public void testEntityResolverDefaultBehaviour() throws Exception {
        EntityResolverProvider provider = new EntityResolverProvider(null);
        EntityResolverProvider.setEntityResolver((EntityResolver)new AllowListEntityResolver(null));
        EntityResolver resolver = provider.getEntityResolver();
        InputSource filter = resolver.resolveEntity(null, "http://schemas.opengis.net/filter/1.1.0/filter.xsd");
        Assert.assertNull((String)"Public Filter 1.1.0 connection allowed", (Object)filter);
        InputSource filterJar = resolver.resolveEntity(null, "jar:file:/some/path/gs-main.jar!schemas/filter/1.1.0/filter.xsd");
        Assert.assertNull((String)"JAR Filter 1.1.0 connection allowed", (Object)filterJar);
        InputSource filterJBoss = resolver.resolveEntity(null, "vfsfile:/home/userone/jboss-eap-5.1/jboss-as/server/default_WAR/deploy/geoserver.war/WEB-INF/lib/gs-main.jar!/filter/1.1.0/filter.xsd");
        Assert.assertNull((String)"JBoss Virtual File System Filter 1.1.0 connection allowed", (Object)filterJBoss);
        try {
            InputSource external = resolver.resolveEntity(null, "https://how2map.geocat.live/geoserver/schemas/wfs/1.0.0/WFS-basic.xsd");
            Assert.assertNotNull((String)"Website Filter 1.1.0 not allowed", (Object)external);
            Assert.fail((String)"Filter 1.1.0 is should not be provided built-in");
        }
        catch (SAXException e) {
            Assert.assertTrue((String)"External XSD not allowed", (boolean)e.getMessage().startsWith("Entity resolution disallowed for"));
            Assert.assertTrue((String)"External XSD not allowed", (boolean)e.getMessage().contains("https://how2map.geocat.live/geoserver/schemas/wfs/1.0.0/WFS-basic.xsd"));
        }
    }
}

