/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfsng;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.data.DataAccess;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.util.decorate.Wrapper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.opengis.feature.type.FeatureType;

public class WfsCompatibilityTest
extends GeoServerSystemTestSupport {
    private boolean isOnline() {
        try {
            URL u = new URL("http://localhost:8080/geoserver");
            HttpURLConnection huc = (HttpURLConnection)u.openConnection();
            huc.setRequestMethod("HEAD");
            huc.connect();
            return huc.getResponseCode() == 200;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Test
    public void testWfsCompatitibility() throws IOException {
        Assume.assumeTrue((boolean)this.isOnline());
        XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
        DataStoreInfo storeInfo = (DataStoreInfo)xp.load(this.getClass().getResourceAsStream("datastore.xml"), DataStoreInfoImpl.class);
        storeInfo.setWorkspace(this.getCatalog().getDefaultWorkspace());
        this.getCatalog().add((StoreInfo)storeInfo);
        FeatureTypeInfo ftInfo = (FeatureTypeInfo)xp.load(this.getClass().getResourceAsStream("featuretype.xml"), FeatureTypeInfoImpl.class);
        ((FeatureTypeInfoImpl)ftInfo).setStore((StoreInfo)storeInfo);
        this.getCatalog().add((ResourceInfo)ftInfo);
        DataAccess store = storeInfo.getDataStore(null);
        if (store instanceof Wrapper) {
            store = (DataAccess)((Wrapper)store).unwrap(DataAccess.class);
        }
        Assert.assertTrue((boolean)(store instanceof WFSDataStore));
        try {
            FeatureType type = ftInfo.getFeatureType();
            Assert.assertEquals((Object)"sf_archsites", (Object)type.getName().getLocalPart());
            Assert.assertEquals((Object)"sf_archsites", (Object)ftInfo.getFeatureSource(null, null).getName().getLocalPart());
        }
        catch (IOException e) {
            String expectedMessage = "Unknown type sf_archsites";
            Assert.assertEquals((String)"Exception message must be correct", (Object)expectedMessage, (Object)e.getMessage());
        }
    }
}

