/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.security.decorators.DecoratingSimpleFeatureSource;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.filter.function.EnvFunction;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.vfny.geoserver.global.GeoServerFeatureSource;

public class GeoServerFeatureSourceTest {
    private PropertyDataStore pds;

    @Before
    public void setup() {
        this.pds = new PropertyDataStore(new File("src/test/java/org/geoserver/data/test"));
    }

    @After
    public void cleanup() {
        EnvFunction.clearLocalValues();
    }

    @Test
    public void testEnvVarExpansionDefaultInclude() throws Exception {
        this.checkRoadSegmentsDefinitionQuery(ECQL.toFilter((String)"FID > env('threshold', 100)"), ECQL.toFilter((String)"FID > 100"), (Filter)Filter.INCLUDE);
    }

    @Test
    public void testEnvVarExpansionDefault() throws Exception {
        this.checkRoadSegmentsDefinitionQuery(ECQL.toFilter((String)"FID > env('threshold', 100)"), ECQL.toFilter((String)"NAME='Main Street' AND FID > 100"), ECQL.toFilter((String)"NAME='Main Street'"));
    }

    @Test
    public void testEnvVarExpansionInclude() throws Exception {
        EnvFunction.setLocalValue((String)"threshold", (Object)20);
        this.checkRoadSegmentsDefinitionQuery(ECQL.toFilter((String)"FID > env('threshold', 100)"), ECQL.toFilter((String)"FID > 20"), (Filter)Filter.INCLUDE);
    }

    @Test
    public void testEnvVarExpansion() throws Exception {
        EnvFunction.setLocalValue((String)"threshold", (Object)30);
        this.checkRoadSegmentsDefinitionQuery(ECQL.toFilter((String)"FID > env('threshold', 100)"), ECQL.toFilter((String)"NAME='Main Street' AND FID > 30"), ECQL.toFilter((String)"NAME='Main Street'"));
    }

    private void checkRoadSegmentsDefinitionQuery(Filter definitionFilter, Filter expected, Filter requestFilter) throws IOException, CQLException {
        ContentFeatureSource basicRoads = this.pds.getFeatureSource("RoadSegments");
        final AtomicReference lastFilter = new AtomicReference();
        DecoratingSimpleFeatureSource roads = new DecoratingSimpleFeatureSource((SimpleFeatureSource)basicRoads){

            public int getCount(Query query) throws IOException {
                lastFilter.set(query.getFilter());
                return super.getCount(query);
            }

            public SimpleFeatureCollection getFeatures(Query query) throws IOException {
                lastFilter.set(query.getFilter());
                return super.getFeatures(query);
            }

            public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
                lastFilter.set(filter);
                return super.getFeatures(filter);
            }
        };
        GeoServerFeatureSource fs = new GeoServerFeatureSource((FeatureSource)roads, roads.getSchema(), definitionFilter, roads.getSchema().getCoordinateReferenceSystem(), ProjectionPolicy.FORCE_DECLARED.getCode().intValue(), null, new MetadataMap());
        fs.getCount(new Query(null, requestFilter));
        Assert.assertEquals((Object)expected, lastFilter.get());
        lastFilter.set(null);
        fs.getFeatures(requestFilter);
        Assert.assertEquals((Object)expected, lastFilter.get());
        lastFilter.set(null);
        fs.getFeatures(new Query(null, requestFilter));
        Assert.assertEquals((Object)expected, lastFilter.get());
    }
}

