/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.data.test.TestData;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.SystemTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class GeoserverDataDirectoryTest
extends GeoServerSystemTestSupport {
    private static final String EXTERNAL_ENTITIES = "externalEntities";
    private static final char SEPARATOR_CHAR = File.separatorChar;
    private static final String RAIN_DATA_PATH = "rain" + SEPARATOR_CHAR + "rain" + SEPARATOR_CHAR + "rain.asc";
    private static final QName RAIN = new QName(MockData.SF_URI, "rain", MockData.SF_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addRasterLayer(RAIN, "rain.zip", "asc", this.getCatalog());
        testData.addStyle(EXTERNAL_ENTITIES, "externalEntities.sld", TestData.class, this.getCatalog());
    }

    @Test
    public void testFindDataFile() throws IOException {
        GeoServerResourceLoader loader = this.getResourceLoader();
        File file = Resources.find((Resource)Resources.fromURL((Resource)Files.asResource((File)loader.getBaseDirectory()), (String)("file:" + RAIN_DATA_PATH)), (boolean)true);
        Assert.assertNotNull((Object)file);
    }

    @Test
    public void testFindDataFileForAbsolutePath() throws IOException {
        GeoServerResourceLoader loader = this.getResourceLoader();
        File dataDir = loader.getBaseDirectory();
        String absolutePath = dataDir.getCanonicalPath() + SEPARATOR_CHAR + RAIN_DATA_PATH;
        File file = Resources.find((Resource)Resources.fromURL((Resource)Files.asResource((File)loader.getBaseDirectory()), (String)absolutePath), (boolean)true);
        Assert.assertNotNull((Object)file);
    }

    @Test
    public void testFindDataFileForCustomUrl() throws IOException {
        GeoServerResourceLoader loader = this.getResourceLoader();
        File file = Resources.find((Resource)Resources.fromURL((Resource)Files.asResource((File)loader.getBaseDirectory()), (String)"sde://user:password@server:port"), (boolean)true);
        Assert.assertNull((Object)file);
    }

    @Test
    public void testStyleWithExternalEntities() throws Exception {
        GeoServerDataDirectory dd = this.getDataDirectory();
        StyleInfo si = this.getCatalog().getStyleByName(EXTERNAL_ENTITIES);
        try {
            dd.parsedStyle(si);
            Assert.fail((String)"Should have failed with a parse error");
        }
        catch (Exception e) {
            String message = e.getMessage();
            Assert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"Entity resolution disallowed"));
            Assert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"/this/file/does/not/exist"));
        }
    }
}

