/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import org.easymock.EasyMock;
import org.geoserver.catalog.DataLinkInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.impl.DataLinkInfoImpl;
import org.geoserver.catalog.impl.MetadataLinkInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.ows.ProxifyingURLMangler;
import org.geoserver.ows.URLMangler;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.util.ResponseUtils;

public class ResponseUtilsTest {
    void createAppContext(String proxyBaseUrl) {
        SettingsInfo settings = (SettingsInfo)EasyMock.createNiceMock(SettingsInfo.class);
        EasyMock.expect((Object)settings.getProxyBaseUrl()).andReturn((Object)proxyBaseUrl).anyTimes();
        EasyMock.replay((Object[])new Object[]{settings});
        GeoServer geoServer = (GeoServer)EasyMock.createNiceMock(GeoServer.class);
        EasyMock.expect((Object)geoServer.getGlobal()).andReturn((Object)new GeoServerInfoImpl());
        EasyMock.expect((Object)geoServer.getSettings()).andReturn((Object)settings).anyTimes();
        EasyMock.replay((Object[])new Object[]{geoServer});
        ProxifyingURLMangler mangler = new ProxifyingURLMangler(geoServer);
        ApplicationContext appContext = (ApplicationContext)EasyMock.createNiceMock(ApplicationContext.class);
        EasyMock.expect((Object)appContext.getBeanNamesForType(URLMangler.class)).andReturn((Object)new String[]{"mangler"});
        EasyMock.expect((Object)appContext.getBean("mangler")).andReturn((Object)mangler).anyTimes();
        EasyMock.replay((Object[])new Object[]{appContext});
        GeoServerExtensionsHelper.init(appContext);
    }

    @After
    public void clearAppContext() {
        GeoServerExtensionsHelper.init(null);
    }

    @Test
    public void testProxyMetadataURL() throws Exception {
        this.createAppContext("http://foo.org/geoserver");
        MetadataLinkInfoImpl link = new MetadataLinkInfoImpl();
        link.setContent("http://bar.com/geoserver/metadata.xml?foo=bar");
        String url = ResponseUtils.proxifyMetadataLink((MetadataLinkInfo)link, (String)"http://localhost/geoserver");
        Assert.assertEquals((Object)link.getContent(), (Object)url);
    }

    @Test
    public void testProxyMetadataURLBackReference() throws Exception {
        this.createAppContext("http://foo.org/geoserver");
        MetadataLinkInfoImpl link = new MetadataLinkInfoImpl();
        link.setContent("/metadata.xml?foo=bar");
        String url = ResponseUtils.proxifyMetadataLink((MetadataLinkInfo)link, (String)"http://localhost/geoserver");
        Assert.assertEquals((Object)"http://foo.org/geoserver/metadata.xml?foo=bar", (Object)url);
    }

    @Test
    public void testProxyMetadataURLBackReferenceNoProxyBaseUrl() throws Exception {
        this.createAppContext(null);
        MetadataLinkInfoImpl link = new MetadataLinkInfoImpl();
        link.setContent("/metadata.xml?foo=bar");
        String url = ResponseUtils.proxifyMetadataLink((MetadataLinkInfo)link, (String)"http://localhost/geoserver");
        Assert.assertEquals((Object)"http://localhost/geoserver/metadata.xml?foo=bar", (Object)url);
    }

    @Test
    public void testProxyDataURL() throws Exception {
        this.createAppContext("http://foo.org/geoserver");
        DataLinkInfoImpl link = new DataLinkInfoImpl();
        link.setContent("http://bar.com/geoserver/metadata.xml?foo=bar");
        String url = ResponseUtils.proxifyDataLink((DataLinkInfo)link, (String)"http://localhost/geoserver");
        Assert.assertEquals((Object)link.getContent(), (Object)url);
    }

    @Test
    public void testProxyDataURLBackReference() throws Exception {
        this.createAppContext("http://foo.org/geoserver");
        DataLinkInfoImpl link = new DataLinkInfoImpl();
        link.setContent("/metadata.xml?foo=bar");
        String url = ResponseUtils.proxifyDataLink((DataLinkInfo)link, (String)"http://localhost/geoserver");
        Assert.assertEquals((Object)"http://foo.org/geoserver/metadata.xml?foo=bar", (Object)url);
    }

    @Test
    public void testDataURLBackReferenceNoProxyBaseUrl() throws Exception {
        this.createAppContext(null);
        DataLinkInfoImpl link = new DataLinkInfoImpl();
        link.setContent("/metadata.xml?foo=bar");
        String url = ResponseUtils.proxifyDataLink((DataLinkInfo)link, (String)"http://localhost/geoserver");
        Assert.assertEquals((Object)"http://localhost/geoserver/metadata.xml?foo=bar", (Object)url);
    }
}

