/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.easymock.EasyMock;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.HTTPHeadersCollector;
import org.geoserver.ows.ProxifyingURLMangler;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;

public class URLProxifyingTest {
    ProxifyingURLMangler mangler;

    void createAppContext(String proxyBaseUrl, final Boolean useHeadersProxyURLIn, String forwardedHeader, String forwardedProtoHeader, String host, String forwardedHost, String forwardedPath, String forwarded) {
        final HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(ProxifyingURLMangler.Headers.FORWARDED.asString().toLowerCase(), forwardedHeader);
        headers.put(ProxifyingURLMangler.Headers.FORWARDED_PROTO.asString().toLowerCase(), forwardedProtoHeader);
        headers.put(ProxifyingURLMangler.Headers.HOST.asString().toLowerCase(), host);
        headers.put(ProxifyingURLMangler.Headers.FORWARDED_HOST.asString().toLowerCase(), forwardedHost);
        headers.put(ProxifyingURLMangler.Headers.FORWARDED_PATH.asString().toLowerCase(), forwardedPath);
        headers.put(ProxifyingURLMangler.Headers.FORWARDED.asString().toLowerCase(), forwarded);
        Request request = (Request)EasyMock.createNiceMock(Request.class);
        EasyMock.expect((Object)request.getHttpRequest()).andReturn((Object)new HttpServletRequestWrapper((HttpServletRequest)new MockHttpServletRequest()){

            public String getHeader(String name) {
                return (String)headers.get(name);
            }

            public Enumeration<String> getHeaderNames() {
                return Collections.enumeration(headers.keySet());
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{request});
        Dispatcher.REQUEST.set(request);
        new HTTPHeadersCollector().init(request);
        GeoServer geoServer = (GeoServer)EasyMock.createNiceMock(GeoServer.class);
        EasyMock.expect((Object)geoServer.getGlobal()).andReturn((Object)new GeoServerInfoImpl(){

            public Boolean isUseHeadersProxyURL() {
                return useHeadersProxyURLIn == null ? false : useHeadersProxyURLIn;
            }
        }).anyTimes();
        SettingsInfo settings = (SettingsInfo)EasyMock.createNiceMock(SettingsInfo.class);
        EasyMock.expect((Object)settings.getProxyBaseUrl()).andReturn((Object)proxyBaseUrl).anyTimes();
        EasyMock.replay((Object[])new Object[]{settings});
        EasyMock.expect((Object)geoServer.getSettings()).andReturn((Object)settings).anyTimes();
        EasyMock.replay((Object[])new Object[]{geoServer});
        ProxifyingURLMangler mangler = new ProxifyingURLMangler(geoServer);
        ApplicationContext appContext = (ApplicationContext)EasyMock.createNiceMock(ApplicationContext.class);
        EasyMock.expect((Object)appContext.getBeanNamesForType(URLMangler.class)).andReturn((Object)new String[]{"mangler"});
        EasyMock.expect((Object)appContext.getBean("mangler")).andReturn((Object)mangler).anyTimes();
        EasyMock.replay((Object[])new Object[]{appContext});
        GeoServerExtensionsHelper.init(appContext);
        this.mangler = new ProxifyingURLMangler(geoServer);
    }

    @After
    public void clearAppContext() {
        GeoServerExtensionsHelper.init(null);
    }

    @Test
    public void testNullFlag() throws Exception {
        this.createAppContext(null, null, null, null, null, null, null, null);
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"", (Object)baseURL.toString());
    }

    @Test
    public void testNoProxyBaseURL() throws Exception {
        this.createAppContext(null, false, null, null, null, null, null, null);
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"", (Object)baseURL.toString());
    }

    @Test
    public void testProxyBaseURL() throws Exception {
        this.createAppContext("http://foo.org/geoserver", false, null, null, null, null, null, null);
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://foo.org/geoserver", (Object)baseURL.toString());
    }

    @Test
    public void testProxyBaseURLFlagSetNoTemplate() throws Exception {
        this.createAppContext("http://foo.org/geoserver", true, null, null, null, null, null, null);
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://foo.org/geoserver", (Object)baseURL.toString());
    }

    @Test
    public void testProxyBaseURLFlagSetWithTemplateNoHeaders() throws Exception {
        this.createAppContext("http://${X-Forwarded-Host}/${X-Forwarded-Path}/geoserver", true, null, null, null, null, null, null);
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"", (Object)baseURL.toString());
    }

    @Test
    public void testProxyBaseURLFlagSetWithTemplatePartialHeaders() throws Exception {
        this.createAppContext("http://${X-Forwarded-Host}/${X-Forwarded-Path}/geoserver", true, null, null, null, "example.com:8080", null, null);
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"", (Object)baseURL.toString());
    }

    @Test
    public void testProxyBaseURLFlagSetWithTemplateEmptyBaseURL() throws Exception {
        this.createAppContext("", true, null, null, null, "example.com:8080", null, null);
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"", (Object)baseURL.toString());
    }

    @Test
    public void testProxyBaseURLFlagSetWithTemplate() throws Exception {
        this.createAppContext("http://${X-Forwarded-Host}/geoserver", true, null, null, null, "example.com:8080", null, null);
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://example.com:8080/geoserver", (Object)baseURL.toString());
    }

    @Test
    public void testProxyBaseURLFlagSetWithTemplateForwardedHost() throws Exception {
        this.createAppContext("http://${X-Forwarded-Host}/${X-Forwarded-Path}/geoserver", true, null, null, null, "example.com:8080", "public", null);
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://example.com:8080/public/geoserver", (Object)baseURL.toString());
    }

    @Test
    public void testProxyBaseURLFlagSetWithTemplateHost() throws Exception {
        this.createAppContext("http://${Host}/${X-Forwarded-Path}/geoserver", true, null, null, "example.com:8080", null, "public", null);
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://example.com:8080/public/geoserver", (Object)baseURL.toString());
    }

    @Test
    public void testProxyBaseURLFlagSetWithTemplateForwarded() throws Exception {
        this.createAppContext("${Forwarded.proto}://${Forwarded.host}/geoserver", true, null, null, null, null, null, "for=192.0.2.60; proto=http; by=203.0.113.43; host=example.com:8080");
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://example.com:8080/geoserver", (Object)baseURL.toString());
    }

    @Test
    public void testProxyBaseURLFlagSetWithTemplateForwardedPath() throws Exception {
        this.createAppContext("${Forwarded.proto}://${Forwarded.host}/${Forwarded.path}/geoserver", true, null, null, null, null, null, "proto=http; host=example.com:8080; path=public");
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://example.com:8080/public/geoserver", (Object)baseURL.toString());
    }

    @Test
    public void testProxyBaseURLFlagSetWithTwoTemplates() throws Exception {
        this.createAppContext("http://${X-Forwarded-Host}/${X-Forwarded-Path}/geoserver" + ProxifyingURLMangler.TEMPLATE_SEPARATOR + "http://${X-Forwarded-Host}/geoserver", true, null, null, null, "example.com:8080", "public", null);
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://example.com:8080/public/geoserver", (Object)baseURL.toString());
    }

    @Test
    public void testProxyBaseURLFlagSetWithTwoTemplates2() throws Exception {
        this.createAppContext("http://${X-Forwarded-Host}/${X-Forwarded-Path}/geoserver" + ProxifyingURLMangler.TEMPLATE_SEPARATOR + "http://example.org/${X-Forwarded-Path}/geoserver", true, null, null, null, null, "public", null);
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://example.org/public/geoserver", (Object)baseURL.toString());
    }

    @Test
    public void testProxyBaseURLFlagSetWithTemplateMixedCase() throws Exception {
        this.createAppContext("http://${X-ForwarDED-HoST}/${x-forwarded-PATH}/geoserver", true, null, null, null, "example.com:8080", "public", null);
        StringBuilder baseURL = new StringBuilder();
        this.mangler.mangleURL(baseURL, new StringBuilder(), new HashMap(), URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://example.com:8080/public/geoserver", (Object)baseURL.toString());
    }
}

