/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.media.jai.ImageLayout;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.SingleGridCoverage2DReader;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;

class CoverageViewHandler {
    private GridCoverage2DReader delegate;
    private String referenceName;
    private boolean homogeneousCoverages = true;
    boolean supportHeterogeneousCoverages;
    private CoveragesConsistencyChecker checker;
    private CoverageView coverageView;
    private ReaderResolutionComposer resolutionComposer;
    private EnvelopeComposer envelopeComposer;

    public CoverageViewHandler(boolean supportHeterogeneousCoverages, GridCoverage2DReader delegate, String referenceName, CoverageView coverageView) {
        this.supportHeterogeneousCoverages = supportHeterogeneousCoverages;
        this.delegate = delegate;
        this.referenceName = referenceName;
        this.coverageView = coverageView;
        this.resolutionComposer = this.initResolutionComposer();
        this.envelopeComposer = this.initEnvelopeComposer();
        List<CoverageView.CoverageBand> bands = coverageView.getCoverageBands();
        int coverageBandsSize = bands.size();
        for (int bIdx = 0; bIdx < coverageBandsSize; ++bIdx) {
            CoverageView.CoverageBand band = bands.get(bIdx);
            List<CoverageView.InputCoverageBand> selectedBands = band.getInputCoverageBands();
            String coverageName = selectedBands.get(0).getCoverageName();
            SingleGridCoverage2DReader reader = SingleGridCoverage2DReader.wrap(delegate, coverageName);
            try {
                if (this.checker == null) {
                    this.checker = new CoveragesConsistencyChecker(reader, supportHeterogeneousCoverages);
                } else {
                    this.homogeneousCoverages &= this.checker.checkConsistency(reader);
                }
                this.envelopeComposer.visit(reader);
                this.resolutionComposer.visit(reader);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.referenceName = this.resolutionComposer.getReferenceName();
    }

    public boolean isHomogeneousCoverages() {
        return this.homogeneousCoverages;
    }

    public GeneralEnvelope getOriginalEnvelope() {
        if (this.homogeneousCoverages) {
            return this.delegate.getOriginalEnvelope(this.referenceName);
        }
        return this.envelopeComposer.getOriginalEnvelope();
    }

    public double[][] getResolutionLevels() throws IOException {
        if (this.homogeneousCoverages) {
            return this.delegate.getResolutionLevels(this.referenceName);
        }
        return this.resolutionComposer.getResolutionLevels();
    }

    public GridEnvelope getOriginalGridRange() {
        if (this.homogeneousCoverages) {
            return this.delegate.getOriginalGridRange(this.referenceName);
        }
        GeneralEnvelope envelope = this.getOriginalEnvelope();
        try {
            double[] res = this.getResolutionLevels()[0];
            return new GridEnvelope2D(new Rectangle((int)(envelope.getSpan(0) / res[0]), (int)(envelope.getSpan(1) / res[1])));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        if (this.homogeneousCoverages) {
            return this.delegate.getOriginalGridToWorld(this.referenceName, pixInCell);
        }
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper(this.getOriginalGridRange(), (Envelope)this.getOriginalEnvelope());
        geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
        MathTransform2D coverageGridToWorld2D = (MathTransform2D)geMapper.createTransform();
        if (pixInCell == PixelInCell.CELL_CENTER) {
            return coverageGridToWorld2D;
        }
        if (coverageGridToWorld2D instanceof AffineTransform) {
            AffineTransform tr = new AffineTransform((AffineTransform)coverageGridToWorld2D);
            tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
            return ProjectiveTransform.create((AffineTransform)tr);
        }
        throw new IllegalStateException("This reader's grid to world transform is invalid!");
    }

    private ReaderResolutionComposer initResolutionComposer() {
        CoverageView.SelectedResolution selectedResolution = this.coverageView.getSelectedResolution();
        switch (selectedResolution) {
            case WORST: {
                return new WorstReaderResolutionComposer();
            }
            case BEST: {
                return new BestReaderResolutionComposer();
            }
        }
        return new BestReaderResolutionComposer();
    }

    private EnvelopeComposer initEnvelopeComposer() {
        CoverageView.EnvelopeCompositionType envelopeCompositionType = this.coverageView.getEnvelopeCompositionType();
        switch (envelopeCompositionType) {
            case INTERSECTION: {
                return new IntersectionEnvelopeComposer();
            }
            case UNION: {
                return new UnionEnvelopeComposer();
            }
        }
        return new UnionEnvelopeComposer();
    }

    public double[] getReadingResolutions(OverviewPolicy policy, double[] requestedResolution) throws IOException {
        return this.delegate.getReadingResolutions(this.referenceName, policy, requestedResolution);
    }

    CoverageView.EnvelopeCompositionType getEnvelopeCompositionType() {
        return this.coverageView.getEnvelopeCompositionType();
    }

    CoverageResolutionChooser getCoverageResolutionChooser() {
        return this.resolutionComposer.getCoverageResolutionChooser();
    }

    static class CoveragesConsistencyChecker {
        private static double DELTA = 1.0E-10;
        private Set<ParameterDescriptor<List>> dynamicParameters;
        private String[] metadataNames;
        private GridEnvelope gridRange;
        private GeneralEnvelope envelope;
        private CoordinateReferenceSystem crs;
        private ImageLayout layout;
        private boolean canSupportHeterogeneousCoverages = false;

        public CoveragesConsistencyChecker(GridCoverage2DReader reader, boolean canSupportHeterogeneousCoverages) throws IOException {
            this.envelope = reader.getOriginalEnvelope();
            this.gridRange = reader.getOriginalGridRange();
            this.crs = reader.getCoordinateReferenceSystem();
            this.metadataNames = reader.getMetadataNames();
            this.dynamicParameters = reader.getDynamicParameters();
            this.layout = reader.getImageLayout();
            this.canSupportHeterogeneousCoverages = canSupportHeterogeneousCoverages;
        }

        public boolean checkConsistency(GridCoverage2DReader reader) throws IOException {
            Rectangle thatRectangle;
            GeneralEnvelope envelope = reader.getOriginalEnvelope();
            GridEnvelope gridRange = reader.getOriginalGridRange();
            CoordinateReferenceSystem crs = reader.getCoordinateReferenceSystem();
            String[] metadataNames = reader.getMetadataNames();
            if (!envelope.equals((Envelope)this.envelope, DELTA, true)) {
                if (!this.canSupportHeterogeneousCoverages) {
                    throw new IllegalArgumentException("The coverage envelope must be the same for all coverages");
                }
                if (!envelope.intersects((Envelope)this.envelope, true)) {
                    throw new IllegalArgumentException("The coverage envelopes need to intersect each other");
                }
                return false;
            }
            Rectangle thisRectangle = new Rectangle(this.gridRange.getLow(0), this.gridRange.getLow(1), this.gridRange.getSpan(0), this.gridRange.getSpan(1));
            if (!thisRectangle.equals(thatRectangle = new Rectangle(gridRange.getLow(0), gridRange.getLow(1), gridRange.getSpan(0), gridRange.getSpan(1)))) {
                if (!this.canSupportHeterogeneousCoverages) {
                    throw new IllegalArgumentException("The coverage gridRange should be the same for all coverages");
                }
                return false;
            }
            if (metadataNames == null) {
                if (this.metadataNames != null && this.metadataNames.length > 0) {
                    throw new IllegalArgumentException("The coverage metadataNames should have the same size");
                }
            } else if (this.metadataNames == null) {
                if (metadataNames != null && metadataNames.length > 0) {
                    throw new IllegalArgumentException("The coverage metadataNames should have the same size");
                }
            } else {
                if (metadataNames.length != this.metadataNames.length) {
                    throw new IllegalArgumentException("The coverage metadataNames should have the same size");
                }
                HashSet<String> metadataSet = new HashSet<String>(Arrays.asList(metadataNames));
                for (String metadataName : this.metadataNames) {
                    if (metadataSet.contains(metadataName)) continue;
                    throw new IllegalArgumentException("The coverage metadata are different");
                }
            }
            MathTransform destinationToSourceTransform = null;
            if (!CRS.equalsIgnoreMetadata((Object)crs, (Object)this.crs)) {
                try {
                    destinationToSourceTransform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)this.crs, (boolean)true);
                }
                catch (FactoryException e) {
                    throw new DataSourceException("Unable to inspect request CRS", (Throwable)e);
                }
            }
            if (destinationToSourceTransform != null && !destinationToSourceTransform.isIdentity()) {
                throw new IllegalArgumentException("The coverage coordinateReferenceSystem should be the same for all coverages");
            }
            if (this.layout.getSampleModel(null).getDataType() != this.layout.getSampleModel(null).getDataType()) {
                throw new IllegalArgumentException("The coverage dataType should be the same for all coverages");
            }
            return true;
        }
    }

    class IntersectionEnvelopeComposer
    extends AbstractEnvelopeComposer {
        IntersectionEnvelopeComposer() {
        }

        @Override
        public void visit(GridCoverage2DReader reader) {
            GeneralEnvelope envelope = reader.getOriginalEnvelope();
            if (this.env == null) {
                this.env = envelope;
            } else {
                this.env.intersect((Envelope)envelope);
            }
        }
    }

    class UnionEnvelopeComposer
    extends AbstractEnvelopeComposer {
        UnionEnvelopeComposer() {
        }

        @Override
        public void visit(GridCoverage2DReader reader) {
            GeneralEnvelope envelope = reader.getOriginalEnvelope();
            if (this.env == null) {
                this.env = envelope;
            } else {
                this.env.add((Envelope)envelope);
            }
        }
    }

    abstract class AbstractEnvelopeComposer
    implements EnvelopeComposer {
        GeneralEnvelope env = null;

        AbstractEnvelopeComposer() {
        }

        @Override
        public GeneralEnvelope getOriginalEnvelope() {
            return this.env;
        }
    }

    static interface EnvelopeComposer {
        public void visit(GridCoverage2DReader var1);

        public GeneralEnvelope getOriginalEnvelope();
    }

    class WorstReaderResolutionComposer
    extends AbstractReaderResolutionComposer {
        WorstReaderResolutionComposer() {
        }

        @Override
        public void visit(GridCoverage2DReader reader) throws IOException {
            if (this.resolution == null) {
                this.resolution = reader.getResolutionLevels();
                this.referenceName = reader.getGridCoverageNames()[0];
            } else {
                double[][] tempRes = reader.getResolutionLevels();
                if (tempRes[0][0] > this.resolution[0][0] && tempRes[0][1] > this.resolution[0][1]) {
                    this.resolution = tempRes;
                    this.referenceName = reader.getGridCoverageNames()[0];
                }
            }
        }

        @Override
        public CoverageResolutionChooser getCoverageResolutionChooser() {
            return new CoverageResolutionChooser(){

                @Override
                protected boolean compare(double scaleX, double scaleY, double[] resolution) {
                    return scaleX > resolution[0] && scaleY > resolution[1];
                }
            };
        }
    }

    class BestReaderResolutionComposer
    extends AbstractReaderResolutionComposer {
        BestReaderResolutionComposer() {
        }

        @Override
        public void visit(GridCoverage2DReader reader) throws IOException {
            if (this.resolution == null) {
                this.resolution = reader.getResolutionLevels();
                this.referenceName = reader.getGridCoverageNames()[0];
            } else {
                double[][] tempRes = reader.getResolutionLevels();
                if (tempRes[0][0] < this.resolution[0][0] && tempRes[0][1] < this.resolution[0][1]) {
                    this.resolution = tempRes;
                    this.referenceName = reader.getGridCoverageNames()[0];
                }
            }
        }

        @Override
        public CoverageResolutionChooser getCoverageResolutionChooser() {
            return new CoverageResolutionChooser(){

                @Override
                protected boolean compare(double scaleX, double scaleY, double[] resolution) {
                    return scaleX < resolution[0] && scaleY < resolution[1];
                }
            };
        }
    }

    abstract class AbstractReaderResolutionComposer
    implements ReaderResolutionComposer {
        double[][] resolution;
        String referenceName = null;

        AbstractReaderResolutionComposer() {
        }

        @Override
        public double[][] getResolutionLevels() {
            return this.resolution;
        }

        @Override
        public String getReferenceName() {
            return this.referenceName;
        }
    }

    static interface ReaderResolutionComposer {
        public void visit(GridCoverage2DReader var1) throws IOException;

        public double[][] getResolutionLevels();

        public String getReferenceName();

        public CoverageResolutionChooser getCoverageResolutionChooser();
    }

    static abstract class CoverageResolutionChooser {
        double[] resolution;

        CoverageResolutionChooser() {
        }

        boolean visit(GridCoverage2D coverage) throws IOException {
            MathTransform2D mt = coverage.getGridGeometry().getGridToCRS2D();
            if (!(mt instanceof AffineTransform2D)) {
                return false;
            }
            AffineTransform2D at = (AffineTransform2D)mt;
            double scaleX = Math.abs(at.getScaleX());
            double scaleY = Math.abs(at.getScaleY());
            if (this.resolution == null) {
                this.resolution = new double[2];
                this.resolution[0] = scaleX;
                this.resolution[1] = scaleY;
                return true;
            }
            if (this.compare(scaleX, scaleY, this.resolution)) {
                this.resolution[0] = scaleX;
                this.resolution[1] = scaleY;
                return true;
            }
            return false;
        }

        protected abstract boolean compare(double var1, double var3, double[] var5);
    }
}

