/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.util;

import java.awt.RenderingHints;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.StructuredCoverageViewReader;
import org.geoserver.ows.kvp.TimeParser;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.util.Converters;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public class ReaderDimensionsAccessor {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final Logger LOGGER = Logging.getLogger(ReaderDimensionsAccessor.class);
    private static final String UTC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    private static final Comparator<Object> TEMPORAL_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Date) {
                if (o2 instanceof DateRange) {
                    return ((Date)o1).compareTo(((DateRange)o2).getMinValue());
                }
                return ((Date)o1).compareTo((Date)o2);
            }
            if (o1 instanceof DateRange) {
                if (o2 instanceof Date) {
                    return ((DateRange)o1).getMinValue().compareTo((Date)o2);
                }
                return ((DateRange)o1).getMinValue().compareTo(((DateRange)o2).getMinValue());
            }
            throw new IllegalArgumentException("Unxpected object type found, was expecting date or date range but found " + o1 + " and " + o2);
        }
    };
    private static final Comparator<Object> ELEVATION_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Double) {
                if (o2 instanceof Double) {
                    return ((Double)o1).compareTo((Double)o2);
                }
                if (o2 instanceof NumberRange) {
                    return ((Double)o1).compareTo((Double)((NumberRange)o2).getMinValue());
                }
            } else if (o1 instanceof NumberRange) {
                if (o2 instanceof NumberRange) {
                    return ((Double)((NumberRange)o1).getMinValue()).compareTo((Double)((NumberRange)o2).getMinValue());
                }
                return ((Double)((NumberRange)o1).getMinValue()).compareTo((Double)o2);
            }
            throw new IllegalArgumentException("Unxpected object type found, was expecting double or range of doubles but found " + o1 + " and " + o2);
        }
    };
    private final GridCoverage2DReader reader;
    private final List<String> metadataNames = new ArrayList<String>();

    public ReaderDimensionsAccessor(GridCoverage2DReader reader) throws IOException {
        Utilities.ensureNonNull((String)"reader", (Object)reader);
        this.reader = reader;
        String[] dimensions = reader.getMetadataNames();
        if (dimensions != null) {
            this.metadataNames.addAll(Arrays.asList(dimensions));
        }
    }

    public boolean hasTime() throws IOException {
        return "true".equalsIgnoreCase(this.reader.getMetadataValue("HAS_TIME_DOMAIN"));
    }

    public TreeSet<Object> getTimeDomain() throws IOException {
        if (!this.hasTime()) {
            Collections.emptySet();
        }
        SimpleDateFormat df = this.getTimeFormat();
        String domain = this.reader.getMetadataValue("TIME_DOMAIN");
        String[] timeInstants = domain.split("\\s*,\\s*");
        TreeSet<Object> values = new TreeSet<Object>(TEMPORAL_COMPARATOR);
        for (String tp : timeInstants) {
            try {
                values.add(this.parseTimeOrRange(df, tp));
            }
            catch (ParseException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return values;
    }

    public TreeSet<Object> getTimeDomain(DateRange range, int maxEntries) throws IOException {
        if (!this.hasTime()) {
            Collections.emptySet();
        }
        TreeSet<Object> result = null;
        if (this.reader instanceof StructuredGridCoverage2DReader) {
            StructuredGridCoverage2DReader sr = (StructuredGridCoverage2DReader)this.reader;
            result = this.getDimensionValuesInRange("time", (Range)range, maxEntries, sr);
        }
        if (result == null) {
            result = new TreeSet();
            TreeSet<Object> fullDomain = this.getTimeDomain();
            for (Object o : fullDomain) {
                if (o instanceof Date) {
                    if (!range.contains((Comparable)((Date)o))) continue;
                    result.add(o);
                    continue;
                }
                if (!(o instanceof DateRange) || !range.intersects((Range)((DateRange)o))) continue;
                result.add(o);
            }
        }
        return result;
    }

    private Object parseTimeOrRange(SimpleDateFormat df, String timeOrRange) throws ParseException {
        if (timeOrRange.contains("/")) {
            String[] splitted = timeOrRange.split("/");
            String strStart = splitted[0];
            String strEnd = splitted[1];
            if (strStart == null || strEnd == null) {
                throw new IllegalArgumentException("Invalid date range " + timeOrRange);
            }
            if (strStart != null && strStart.equals(strEnd)) {
                return df.parse(strStart);
            }
            Date start = df.parse(strStart);
            Date end = df.parse(strEnd);
            return new DateRange(start, end);
        }
        return df.parse(timeOrRange);
    }

    private Object parseNumberOrRange(String val) {
        if (val.contains("/")) {
            String strEnd;
            String[] splitted = val.split("/");
            String strStart = splitted[0];
            if (strStart.equals(strEnd = splitted[1])) {
                return Double.parseDouble(strStart);
            }
            double start = Double.parseDouble(strStart);
            double end = Double.parseDouble(strEnd);
            return new NumberRange(Double.class, (Number)start, (Number)end);
        }
        return Double.parseDouble(val);
    }

    public Date getMaxTime() throws IOException {
        if (!this.hasTime()) {
            return null;
        }
        String currentTime = this.reader.getMetadataValue("TIME_DOMAIN_MAXIMUM");
        if (currentTime == null) {
            return null;
        }
        try {
            return this.getTimeFormat().parse(currentTime);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to get CURRENT time from coverage reader", e);
        }
    }

    public Date getMinTime() throws IOException {
        if (!this.hasTime()) {
            return null;
        }
        String currentTime = this.reader.getMetadataValue("TIME_DOMAIN_MINIMUM");
        if (currentTime == null) {
            return null;
        }
        try {
            return this.getTimeFormat().parse(currentTime);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to get minimum time from coverage reader", e);
        }
    }

    public SimpleDateFormat getTimeFormat() {
        SimpleDateFormat df = new SimpleDateFormat(UTC_PATTERN);
        df.setTimeZone(UTC_TIME_ZONE);
        return df;
    }

    public boolean hasElevation() throws IOException {
        return "true".equalsIgnoreCase(this.reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
    }

    public TreeSet<Object> getElevationDomain() throws IOException {
        if (!this.hasElevation()) {
            return null;
        }
        String[] elevationValues = this.reader.getMetadataValue("ELEVATION_DOMAIN").split(",");
        TreeSet<Object> elevations = new TreeSet<Object>(ELEVATION_COMPARATOR);
        for (String val : elevationValues) {
            try {
                elevations.add(this.parseNumberOrRange(val));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return elevations;
    }

    public TreeSet<Object> getElevationDomain(NumberRange range, int maxEntries) throws IOException {
        if (!this.hasElevation()) {
            Collections.emptySet();
        }
        TreeSet<Object> result = null;
        if (this.reader instanceof StructuredGridCoverage2DReader) {
            StructuredGridCoverage2DReader sr = (StructuredGridCoverage2DReader)this.reader;
            result = this.getDimensionValuesInRange("elevation", (Range)range, maxEntries, sr);
        }
        if (result == null) {
            result = new TreeSet();
            TreeSet<Object> fullDomain = this.getElevationDomain();
            for (Object o : fullDomain) {
                if (o instanceof Double) {
                    if (!range.contains((Number)o)) continue;
                    result.add(o);
                    continue;
                }
                if (!(o instanceof NumberRange) || !range.intersects((Range)((NumberRange)o))) continue;
                result.add(o);
            }
        }
        return result;
    }

    private TreeSet<Object> getDimensionValuesInRange(String dimensionName, Range range, int maxEntries, StructuredGridCoverage2DReader sr) throws IOException {
        String name = sr.getGridCoverageNames()[0];
        List descriptors = sr.getDimensionDescriptors(name);
        for (DimensionDescriptor descriptor : descriptors) {
            if (!dimensionName.equalsIgnoreCase(descriptor.getName()) || descriptor.getEndAttribute() != null) continue;
            GranuleSource gs = sr.getGranules(name, true);
            Query query = new Query(gs.getSchema().getName().getLocalPart());
            PropertyName attribute = FF.property(descriptor.getStartAttribute());
            PropertyIsBetween rangeFilter = FF.between((Expression)attribute, (Expression)FF.literal((Object)range.getMinValue()), (Expression)FF.literal((Object)range.getMaxValue()));
            query.setFilter((Filter)rangeFilter);
            query.setMaxFeatures(maxEntries);
            query.setPropertyNames(new String[]{descriptor.getStartAttribute()});
            query.setHints(new Hints((RenderingHints.Key)StructuredCoverageViewReader.QUERY_FIRST_BAND, (Object)true));
            SimpleFeatureCollection collection = gs.getGranules(query);
            UniqueVisitor visitor = new UniqueVisitor((Expression)attribute);
            collection.accepts((FeatureVisitor)visitor, null);
            TreeSet<Object> result = new TreeSet<Object>(visitor.getUnique());
            return result;
        }
        return null;
    }

    public Double getMaxElevation() throws IOException {
        if (!this.hasElevation()) {
            return null;
        }
        String elevation = this.reader.getMetadataValue("ELEVATION_DOMAIN_MAXIMUM");
        if (elevation == null) {
            return null;
        }
        try {
            return Double.parseDouble(elevation);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to get maximum elevation from coverage reader", e);
        }
    }

    public Double getMinElevation() throws IOException {
        if (!this.hasElevation()) {
            return null;
        }
        String elevation = this.reader.getMetadataValue("ELEVATION_DOMAIN_MINIMUM");
        if (elevation == null) {
            return null;
        }
        try {
            return Double.parseDouble(elevation);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to get minimum elevation from coverage reader", e);
        }
    }

    public List<String> getCustomDomains() {
        if (this.metadataNames.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> names = new HashSet<String>(this.metadataNames);
        TreeSet<String> result = new TreeSet<String>();
        for (String name : names) {
            String dimension;
            if (!name.startsWith("HAS_") || !name.endsWith("_DOMAIN") || !names.contains((dimension = name.substring(4, name.length() - 7)) + "_DOMAIN") || "TIME".equals(dimension) || "ELEVATION".equals(dimension)) continue;
            result.add(dimension);
        }
        return new ArrayList<String>(result);
    }

    public String getDomainDatatype(String domainName) throws IOException {
        return this.reader.getMetadataValue(domainName.toUpperCase() + "_DOMAIN_DATATYPE");
    }

    public boolean hasDomain(String name) throws IOException {
        Utilities.ensureNonNull((String)"name", (Object)name);
        return "true".equalsIgnoreCase(this.reader.getMetadataValue("HAS_" + name.toUpperCase() + "_DOMAIN"));
    }

    public List<String> getDomain(String name) throws IOException {
        String[] values = this.reader.getMetadataValue(name.toUpperCase() + "_DOMAIN").split(",");
        ArrayList<String> valueSet = new ArrayList<String>();
        for (String val : values) {
            valueSet.add(val);
        }
        return valueSet;
    }

    public String getCustomDomainDefaultValue(String name) throws IOException {
        Utilities.ensureNonNull((String)"name", (Object)name);
        String minimum = this.reader.getMetadataValue(name.toUpperCase() + "_DOMAIN_MINIMUM");
        if (minimum != null) {
            return minimum;
        }
        List<String> domain = this.getDomain(name);
        if (domain.isEmpty()) {
            return null;
        }
        return domain.get(0);
    }

    public boolean hasRange(String domain) {
        return this.metadataNames.contains(domain + "_DOMAIN_MAXIMUM") && this.metadataNames.contains(domain + "_DOMAIN_MINIMUM");
    }

    public boolean hasResolution(String domain) {
        Utilities.ensureNonNull((String)"name", (Object)domain);
        return this.metadataNames.contains(domain.toUpperCase() + "_DOMAIN_RESOLUTION");
    }

    public Collection<Object> convertDimensionValue(String name, String value) {
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            String typeName = this.getDomainDatatype(name);
            if (typeName != null) {
                Class<?> type = Class.forName(typeName);
                if (type == Date.class) {
                    result.addAll(new TimeParser().parse(value));
                } else if (Number.class.isAssignableFrom(type) && !value.contains(",")) {
                    result.add(this.parseNumberOrRange(value));
                } else {
                    for (String element : value.split(",")) {
                        result.add(Converters.convert((Object)element, type));
                    }
                }
            } else {
                result.add(value);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to convert dimension value: ", e);
            result.add(value);
        }
        return result;
    }

    public List<Object> convertDimensionValue(String name, List<String> value) {
        ArrayList<Object> list2 = new ArrayList<Object>();
        for (String val : value) {
            list2.addAll(this.convertDimensionValue(name, val));
        }
        return list2;
    }
}

