/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.util.Filter;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.logging.Logging;

public class AsynchResourceIterator<T>
implements Iterator<T>,
Closeable {
    static final Logger LOGGER = Logging.getLogger(AsynchResourceIterator.class);
    public static final int ASYNCH_RESOURCE_THREADS;
    static final Object TERMINATOR;
    final BlockingQueue<Object> queue;
    Thread thread;
    T mapped;
    volatile boolean completed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SC_START_IN_CTOR"})
    public AsynchResourceIterator(Resource root, Filter<Resource> filter, ResourceMapper<T> mapper) {
        List resources = root.list().parallelStream().filter(r -> filter.accept(r)).collect(Collectors.toList());
        if (resources.size() > 1) {
            this.queue = new LinkedBlockingQueue<Object>(10000);
            this.thread = new Thread(() -> {
                ExecutorService executor = Executors.newFixedThreadPool(ASYNCH_RESOURCE_THREADS);
                LinkedBlockingQueue<Object> sourceQueue = new LinkedBlockingQueue<Object>(resources);
                for (int i = 0; i < ASYNCH_RESOURCE_THREADS; ++i) {
                    sourceQueue.add(TERMINATOR);
                    executor.submit(() -> {
                        block4: while (true) {
                            try {
                                Object o;
                                while (!this.completed && (o = sourceQueue.take()) != TERMINATOR) {
                                    Resource r = (Resource)o;
                                    try {
                                        Object mapped = mapper.apply(r);
                                        if (mapped == null) continue block4;
                                        this.queue.put(mapped);
                                        continue block4;
                                    }
                                    catch (IOException e) {
                                        LOGGER.log(Level.WARNING, "Failed to load resource '" + r.name() + "'", e);
                                    }
                                }
                                break;
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                    });
                }
                try {
                    executor.shutdown();
                    executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    this.queue.put(TERMINATOR);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Failed to put the terminator in the queue", e);
                }
            }, "Loader" + root.name());
            this.thread.start();
        } else if (resources.size() == 1) {
            this.queue = null;
            Resource r2 = (Resource)resources.get(0);
            try {
                this.mapped = mapper.apply(r2);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load resource '" + r2.name() + "'", e);
            }
            finally {
                this.completed = true;
            }
        } else {
            this.queue = null;
            this.mapped = null;
            this.completed = true;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.mapped != null) {
            return true;
        }
        if (this.completed) {
            return false;
        }
        try {
            Object o = this.queue.take();
            if (o == TERMINATOR) {
                this.completed = true;
                return false;
            }
            this.mapped = o;
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T result = this.mapped;
            this.mapped = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void close() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            this.completed = true;
            this.queue.clear();
        }
    }

    static {
        String value = GeoServerExtensions.getProperty((String)"org.geoserver.catalog.loadingThreads");
        ASYNCH_RESOURCE_THREADS = value != null ? Integer.parseInt(value) : 4;
        TERMINATOR = new Object();
    }

    @FunctionalInterface
    public static interface ResourceMapper<T> {
        public T apply(Resource var1) throws IOException;
    }
}

