/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;

public class CapabilitiesCacheHeadersCallback
extends AbstractDispatcherCallback {
    static final Logger LOGGER = Logging.getLogger(CapabilitiesCacheHeadersCallback.class);
    boolean capabilitiesCacheHeadersEnabled;
    GeoServer gs;

    public CapabilitiesCacheHeadersCallback(GeoServer gs) {
        this.gs = gs;
        String value = GeoServerExtensions.getProperty((String)"CAPABILITIES_CACHE_CONTROL_ENABLED");
        this.capabilitiesCacheHeadersEnabled = value != null ? Boolean.parseBoolean(value) : true;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Cache control for capabilities requests and 304 support is enabled: " + this.capabilitiesCacheHeadersEnabled);
        }
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        if (this.handleCachingHeaders(request)) {
            return new RevalidateTagResponse(response);
        }
        return response;
    }

    private boolean handleCachingHeaders(Request request) {
        return this.capabilitiesCacheHeadersEnabled && "GetCapabilities".equalsIgnoreCase(request.getRequest());
    }

    public boolean isCapabilitiesCacheHeadersEnabled() {
        return this.capabilitiesCacheHeadersEnabled;
    }

    public void setCapabilitiesCacheHeadersEnabled(boolean capabilitiesCacheHeadersEnabled) {
        this.capabilitiesCacheHeadersEnabled = capabilitiesCacheHeadersEnabled;
    }

    private class RevalidateTagResponse
    extends Response {
        Response delegate;

        public RevalidateTagResponse(Response delegate) {
            super(delegate.getBinding());
            this.delegate = delegate;
        }

        public boolean canHandle(Operation operation) {
            return this.delegate.canHandle(operation);
        }

        public String getMimeType(Object value, Operation operation) throws ServiceException {
            return this.delegate.getMimeType(value, operation);
        }

        public String[][] getHeaders(Object value, Operation operation) throws ServiceException {
            String[][] headers = this.delegate.getHeaders(value, operation);
            if (headers == null) {
                return new String[][]{{"Cache-Control", "max-age=0, must-revalidate"}};
            }
            Map map = ArrayUtils.toMap((Object[])headers);
            map.putIfAbsent("Cache-Control", "max-age=0, must-revalidate");
            headers = new String[map.size()][2];
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                headers[i][0] = (String)entry.getKey();
                headers[i][1] = (String)entry.getValue();
                ++i;
            }
            return headers;
        }

        public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
            this.delegate.write(value, output, operation);
        }

        public String getPreferredDisposition(Object value, Operation operation) {
            return this.delegate.getPreferredDisposition(value, operation);
        }

        public String getAttachmentFileName(Object value, Operation operation) {
            return this.delegate.getAttachmentFileName(value, operation);
        }

        public String getCharset(Operation operation) {
            return this.delegate.getCharset(operation);
        }
    }
}

