/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geotools.util.logging.Logging;

public class ServicePersister
extends ConfigurationListenerAdapter {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver");
    List<XStreamServiceLoader> loaders;
    GeoServer geoServer;
    GeoServerResourceLoader resourceLoader;

    public ServicePersister(List<XStreamServiceLoader> loaders, GeoServer geoServer) {
        this.loaders = loaders;
        this.geoServer = geoServer;
        this.resourceLoader = geoServer.getCatalog().getResourceLoader();
    }

    @Override
    public void handleServiceChange(ServiceInfo service, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
        WorkspaceInfo old;
        XStreamServiceLoader loader = this.findServiceLoader(service);
        int i = propertyNames.indexOf("workspace");
        if (i != -1 && (old = (WorkspaceInfo)oldValues.get(i)) != null) {
            WorkspaceInfo ws = (WorkspaceInfo)newValues.get(i);
            try {
                Resource f = this.dir(ws).get(loader.getFilename());
                f.renameTo(this.dir(ws).get(loader.getFilename()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void handlePostServiceChange(ServiceInfo service) {
        XStreamServiceLoader loader = this.findServiceLoader(service);
        try {
            Resource directory = service.getWorkspace() != null ? this.dir(service.getWorkspace()) : null;
            loader.save(service, this.geoServer, directory);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void handleServiceRemove(ServiceInfo service) {
        XStreamServiceLoader loader = this.findServiceLoader(service);
        try {
            Resource dir = service.getWorkspace() != null ? this.dir(service.getWorkspace()) : this.resourceLoader.get("");
            dir.get(loader.getFilename()).delete();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    XStreamServiceLoader findServiceLoader(ServiceInfo service) {
        XStreamServiceLoader loader = null;
        for (XStreamServiceLoader l : this.loaders) {
            if (!l.getServiceClass().isInstance(service)) continue;
            loader = l;
            break;
        }
        if (loader == null) {
            throw new IllegalArgumentException("No loader for " + service.getName());
        }
        return loader;
    }

    Resource dir(WorkspaceInfo ws) throws IOException {
        return this.resourceLoader.get(Paths.path((String[])new String[]{"workspaces", ws.getName()}));
    }
}

