/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.platform.resource.Resources;

public class SpringResourceAdaptor
implements org.springframework.core.io.Resource {
    private Resource resource;

    public static org.springframework.core.io.Resource relative(org.springframework.core.io.Resource resource, ResourceStore store) throws IOException {
        File f = resource.getFile();
        if (f != null) {
            if (!f.isAbsolute()) {
                Resource res = store.get(Paths.convert((String)f.getPath()));
                return new SpringResourceAdaptor(res);
            }
            return new SpringResourceAdaptor(Files.asResource((File)f));
        }
        return resource;
    }

    public SpringResourceAdaptor(Resource resource) {
        this.resource = resource;
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.in();
    }

    public boolean exists() {
        return Resources.exists((Resource)this.resource);
    }

    public boolean isReadable() {
        return Resources.canRead((Resource)this.resource);
    }

    public boolean isOpen() {
        return false;
    }

    public URL getURL() throws IOException {
        return Resources.find((Resource)this.resource).toURI().toURL();
    }

    public URI getURI() throws IOException {
        return Resources.find((Resource)this.resource).toURI();
    }

    public File getFile() throws IOException {
        return Resources.find((Resource)this.resource);
    }

    public long contentLength() throws IOException {
        return Resources.find((Resource)this.resource).length();
    }

    public long lastModified() throws IOException {
        return this.resource.lastmodified();
    }

    public org.springframework.core.io.Resource createRelative(String relativePath) throws IOException {
        return new SpringResourceAdaptor(this.resource.get(relativePath));
    }

    public String getFilename() {
        return this.resource.name();
    }

    public String getDescription() {
        return this.resource.path();
    }

    public Resource getResource() {
        return this.resource;
    }
}

