/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.util;

import java.awt.RenderingHints;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.geotools.util.factory.Hints;
import org.geotools.xml.impl.DatatypeConverterImpl;

public final class TemporalUtils {
    private TemporalUtils() {
    }

    public static String printDate(Date date) {
        if (date == null) {
            return "null";
        }
        Calendar calendar = TemporalUtils.toCalendar(date);
        if (date instanceof java.sql.Date) {
            return DatatypeConverterImpl.getInstance().printDate(calendar);
        }
        return DatatypeConverterImpl.getInstance().printDateTime(calendar);
    }

    private static Calendar toCalendar(Date date) {
        Object hint = Hints.getSystemDefault((RenderingHints.Key)Hints.LOCAL_DATE_TIME_HANDLING);
        Calendar calendar = Boolean.TRUE.equals(hint) ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.setTimeInMillis(date.getTime());
        return calendar;
    }

    public static boolean isDateTimeFormatEnabled() {
        Object hint = Hints.getSystemDefault((RenderingHints.Key)Hints.DATE_TIME_FORMAT_HANDLING);
        return !Boolean.FALSE.equals(hint);
    }
}

