/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;

public class RetypingFeatureCollection
extends DecoratingSimpleFeatureCollection {
    protected SimpleFeatureType target;

    public RetypingFeatureCollection(SimpleFeatureCollection delegate, SimpleFeatureType target) {
        super(delegate);
        this.target = target;
    }

    public SimpleFeatureType getSchema() {
        return this.target;
    }

    public SimpleFeatureIterator features() {
        return new RetypingIterator(this.delegate.features(), this.target);
    }

    protected boolean canDelegate(FeatureVisitor visitor) {
        return ReTypingFeatureCollection.isTypeCompatible((FeatureVisitor)visitor, (SimpleFeatureType)this.target);
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        SimpleFeatureCollection delegateCollection = this.delegate.subCollection(filter);
        return new ReTypingFeatureCollection(delegateCollection, this.target);
    }

    static SimpleFeature retype(SimpleFeature source, SimpleFeatureBuilder builder) throws IllegalAttributeException {
        SimpleFeatureType target = builder.getFeatureType();
        for (int i = 0; i < target.getAttributeCount(); ++i) {
            AttributeDescriptor attributeType = target.getDescriptor(i);
            Object value = null;
            if (source.getFeatureType().getDescriptor(attributeType.getName()) != null) {
                value = source.getAttribute(attributeType.getName());
            }
            builder.add(value);
        }
        FeatureId id = RetypingFeatureCollection.reTypeId(source.getIdentifier(), source.getFeatureType(), target);
        SimpleFeature retyped = builder.buildFeature(id.getID());
        retyped.getUserData().putAll(source.getUserData());
        return retyped;
    }

    public static FeatureId reTypeId(FeatureId sourceId, SimpleFeatureType original, SimpleFeatureType target) {
        String originalTypeName = original.getName().getLocalPart();
        String destTypeName = target.getName().getLocalPart();
        if (destTypeName.equals(originalTypeName)) {
            return sourceId;
        }
        String prefix = originalTypeName + ".";
        if (sourceId.getID().startsWith(prefix)) {
            return new FeatureIdImpl(destTypeName + "." + sourceId.getID().substring(prefix.length()));
        }
        return sourceId;
    }

    public static class RetypingFeatureWriter
    implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
        FeatureWriter<SimpleFeatureType, SimpleFeature> delegate;
        SimpleFeatureBuilder builder;
        private SimpleFeature current;
        private SimpleFeature retyped;

        public RetypingFeatureWriter(FeatureWriter<SimpleFeatureType, SimpleFeature> delegate, SimpleFeatureType target) {
            this.delegate = delegate;
            this.builder = new SimpleFeatureBuilder(target);
        }

        public void close() throws IOException {
            this.delegate.close();
            this.delegate = null;
            this.builder = null;
        }

        public SimpleFeatureType getFeatureType() {
            return this.builder.getFeatureType();
        }

        public boolean hasNext() throws IOException {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() throws IOException {
            try {
                this.current = (SimpleFeature)this.delegate.next();
                this.retyped = RetypingFeatureCollection.retype(this.current, this.builder);
                return this.retyped;
            }
            catch (IllegalAttributeException e) {
                throw (IOException)new IOException("Error occurred while retyping feature").initCause(e);
            }
        }

        public void remove() throws IOException {
            this.delegate.write();
        }

        public void write() throws IOException {
            try {
                SimpleFeatureType target = this.getFeatureType();
                for (int i = 0; i < target.getAttributeCount(); ++i) {
                    AttributeDescriptor at = target.getDescriptor(i);
                    Object value = this.retyped.getAttribute(i);
                    this.current.setAttribute(at.getLocalName(), value);
                }
                this.delegate.write();
            }
            catch (IllegalAttributeException e) {
                throw (IOException)new IOException("Error occurred while retyping feature").initCause(e);
            }
        }
    }

    public static class RetypingFeatureReader
    implements FeatureReader<SimpleFeatureType, SimpleFeature> {
        FeatureReader<SimpleFeatureType, SimpleFeature> delegate;
        SimpleFeatureBuilder builder;

        public RetypingFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> delegate, SimpleFeatureType target) {
            this.delegate = delegate;
            this.builder = new SimpleFeatureBuilder(target);
        }

        public void close() throws IOException {
            this.delegate.close();
            this.delegate = null;
            this.builder = null;
        }

        public SimpleFeatureType getFeatureType() {
            return this.builder.getFeatureType();
        }

        public boolean hasNext() throws IOException {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
            return RetypingFeatureCollection.retype((SimpleFeature)this.delegate.next(), this.builder);
        }
    }

    public static class RetypingIterator
    implements SimpleFeatureIterator {
        protected SimpleFeatureBuilder builder;
        protected SimpleFeatureIterator delegate;

        public RetypingIterator(SimpleFeatureIterator delegate, SimpleFeatureType target) {
            this.delegate = delegate;
            this.builder = new SimpleFeatureBuilder(target);
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() {
            try {
                return RetypingFeatureCollection.retype((SimpleFeature)this.delegate.next(), this.builder);
            }
            catch (IllegalAttributeException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            this.delegate.close();
        }
    }
}

