/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.geoserver.filters.BufferedRequestWrapper;
import org.geoserver.ows.util.RequestUtils;
import org.geotools.util.logging.Logging;

public class LoggingFilter
implements Filter {
    protected Logger logger = Logging.getLogger((String)"org.geoserver.filters");
    protected boolean enabled = true;
    protected boolean logBodies = true;
    protected boolean logHeaders = true;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String message = "";
        String body = null;
        String path = "";
        if (this.enabled) {
            if (req instanceof HttpServletRequest) {
                HttpServletRequest hreq = (HttpServletRequest)req;
                path = RequestUtils.getRemoteAddr((HttpServletRequest)hreq) + " \"" + hreq.getMethod() + " " + hreq.getRequestURI();
                if (hreq.getQueryString() != null) {
                    path = path + "?" + hreq.getQueryString();
                }
                path = path + "\"";
                message = "" + path;
                message = message + " \"" + this.noNull(hreq.getHeader("User-Agent"));
                message = message + "\" \"" + this.noNull(hreq.getHeader("Referer"));
                message = message + "\" \"" + this.noNull(hreq.getHeader("Content-type")) + "\" ";
                if (this.logHeaders) {
                    Enumeration headerNames = hreq.getHeaderNames();
                    message = message + "\n  Headers:";
                    while (headerNames.hasMoreElements()) {
                        String headerName = (String)headerNames.nextElement();
                        message = message + "\n    " + headerName + ": " + hreq.getHeader(headerName);
                    }
                }
                if (this.logBodies && (hreq.getMethod().equals("PUT") || hreq.getMethod().equals("POST"))) {
                    byte[] bytes;
                    message = message + " request-size: " + hreq.getContentLength();
                    message = message + " body: ";
                    String encoding = hreq.getCharacterEncoding();
                    if (encoding == null) {
                        encoding = "ISO-8859-1";
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try (ServletInputStream is = hreq.getInputStream();){
                        IOUtils.copy((InputStream)is, (OutputStream)bos);
                        bytes = bos.toByteArray();
                        body = new String(bytes, encoding);
                    }
                    req = new BufferedRequestWrapper(hreq, encoding, bytes);
                }
            } else {
                message = "" + req.getRemoteHost() + " made a non-HTTP request";
            }
            this.logger.info(message + (body == null ? "" : "\n" + body + "\n"));
            long startTime = System.currentTimeMillis();
            chain.doFilter(req, res);
            long requestTime = System.currentTimeMillis() - startTime;
            this.logger.info(path + " took " + requestTime + "ms");
        } else {
            chain.doFilter(req, res);
        }
    }

    public void init(FilterConfig filterConfig) {
        this.enabled = this.getConfigBool("enabled", filterConfig);
        this.logBodies = this.getConfigBool("log-request-bodies", filterConfig);
        this.logHeaders = this.getConfigBool("log-request-headers", filterConfig);
    }

    protected boolean getConfigBool(String name, FilterConfig conf) {
        try {
            String value = conf.getInitParameter(name);
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected String noNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public void destroy() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLogBodies() {
        return this.logBodies;
    }

    public void setLogBodies(boolean logBodies) {
        this.logBodies = logBodies;
    }
}

