/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.LocalPublished;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;

public abstract class WorkspaceQualifyingCallback
implements DispatcherCallback {
    protected Catalog catalog;

    protected WorkspaceQualifyingCallback(Catalog catalog) {
        this.catalog = catalog;
    }

    public Request init(Request request) {
        return null;
    }

    public Service serviceDispatched(Request request, Service service) throws ServiceException {
        if (LocalWorkspace.get() != null) {
            this.qualifyRequest(LocalWorkspace.get(), LocalPublished.get(), service, request);
        }
        return service;
    }

    public Operation operationDispatched(Request request, Operation operation) {
        if (LocalWorkspace.get() != null) {
            this.qualifyRequest(LocalWorkspace.get(), LocalPublished.get(), operation, request);
        }
        return operation;
    }

    public Object operationExecuted(Request request, Operation operation, Object result) {
        return null;
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        return null;
    }

    public void finished(Request request) {
    }

    protected <T> T parameter(Operation op, Class<T> clazz) {
        return (T)OwsUtils.parameter((Object[])op.getParameters(), clazz);
    }

    protected abstract void qualifyRequest(WorkspaceInfo var1, PublishedInfo var2, Service var3, Request var4);

    protected abstract void qualifyRequest(WorkspaceInfo var1, PublishedInfo var2, Operation var3, Request var4);

    protected String qualifyName(String name, WorkspaceInfo ws) {
        int colon = name.indexOf(58);
        if (colon == -1) {
            name = ws.getName() + ":" + name;
        } else {
            String prefix = name.substring(0, colon);
            if (!prefix.equalsIgnoreCase(ws.getName())) {
                name = ws.getName() + ":" + name.substring(colon + 1);
            }
        }
        return name;
    }

    protected void qualifyLayerNames(List<String> names, WorkspaceInfo ws) {
        for (int i = 0; i < names.size(); ++i) {
            names.set(i, this.qualifyName(names.get(i), ws));
        }
    }
}

