/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.RoleLoadedListener;
import org.geoserver.security.impl.GeoServerRole;

public abstract class AuthorizingRoleService
implements GeoServerRoleStore {
    protected GeoServerRoleService delegate;

    public GeoServerRoleService getDelegate() {
        return this.delegate;
    }

    protected AuthorizingRoleService(GeoServerRoleService delegate) {
        this.delegate = delegate;
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        this.delegate.initializeFromConfig(config);
    }

    @Override
    public boolean canCreateStore() {
        return this.delegate.canCreateStore();
    }

    @Override
    public GeoServerRoleStore createStore() throws IOException {
        try {
            return (GeoServerRoleStore)this.getClass().getConstructor(GeoServerRoleService.class).newInstance(this.delegate.createStore());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public void setName(String name) {
        this.delegate.setName(name);
    }

    @Override
    public void setSecurityManager(GeoServerSecurityManager securityManager) {
        this.delegate.setSecurityManager(securityManager);
    }

    @Override
    public GeoServerSecurityManager getSecurityManager() {
        return this.delegate.getSecurityManager();
    }

    @Override
    public void registerRoleLoadedListener(RoleLoadedListener listener) {
        this.delegate.registerRoleLoadedListener(listener);
    }

    @Override
    public void unregisterRoleLoadedListener(RoleLoadedListener listener) {
        this.delegate.unregisterRoleLoadedListener(listener);
    }

    @Override
    public void load() throws IOException {
        this.delegate.load();
    }

    @Override
    public SortedSet<String> getGroupNamesForRole(GeoServerRole role) throws IOException {
        return this.filterGroups(role, new TreeSet<String>(this.delegate.getGroupNamesForRole(role)));
    }

    @Override
    public SortedSet<String> getUserNamesForRole(GeoServerRole role) throws IOException {
        return this.filterUsers(role, new TreeSet<String>(this.delegate.getUserNamesForRole(role)));
    }

    @Override
    public SortedSet<GeoServerRole> getRolesForUser(String username) throws IOException {
        return this.filterUserRoles(username, new TreeSet<GeoServerRole>(this.delegate.getRolesForUser(username)));
    }

    @Override
    public SortedSet<GeoServerRole> getRolesForGroup(String groupname) throws IOException {
        return this.filterGroupRoles(groupname, new TreeSet<GeoServerRole>(this.delegate.getRolesForGroup(groupname)));
    }

    @Override
    public SortedSet<GeoServerRole> getRoles() throws IOException {
        return this.filterRoles(new TreeSet<GeoServerRole>(this.delegate.getRoles()));
    }

    @Override
    public Map<String, String> getParentMappings() throws IOException {
        return this.filterParentMappings(this.delegate.getParentMappings());
    }

    @Override
    public GeoServerRole createRoleObject(String role) throws IOException {
        return null;
    }

    @Override
    public GeoServerRole getParentRole(GeoServerRole role) throws IOException {
        return this.filterRole(this.delegate.getParentRole(role));
    }

    @Override
    public GeoServerRole getRoleByName(String role) throws IOException {
        return this.filterRole(this.delegate.getRoleByName(role));
    }

    @Override
    public Properties personalizeRoleParams(String roleName, Properties roleParams, String userName, Properties userProps) throws IOException {
        return this.delegate.personalizeRoleParams(roleName, roleParams, userName, userProps);
    }

    @Override
    public GeoServerRole getAdminRole() {
        return this.filterRole(this.delegate.getAdminRole());
    }

    @Override
    public GeoServerRole getGroupAdminRole() {
        return this.filterRole(this.delegate.getGroupAdminRole());
    }

    @Override
    public int getRoleCount() throws IOException {
        return this.getRoles().size();
    }

    protected GeoServerRoleStore delegateAsStore() {
        return (GeoServerRoleStore)this.delegate;
    }

    @Override
    public void initializeFromService(GeoServerRoleService service) throws IOException {
        this.delegateAsStore().initializeFromService(((AuthorizingRoleService)service).getDelegate());
    }

    @Override
    public void store() throws IOException {
        this.delegateAsStore().store();
    }

    @Override
    public boolean isModified() {
        return this.delegateAsStore().isModified();
    }

    @Override
    public void clear() throws IOException {
        this.delegateAsStore().clear();
    }

    @Override
    public void addRole(GeoServerRole role) throws IOException {
        if (this.filterRole(role) != null) {
            this.delegateAsStore().addRole(role);
        }
    }

    @Override
    public void updateRole(GeoServerRole role) throws IOException {
        if (this.filterRole(role) != null) {
            this.delegateAsStore().updateRole(role);
        }
    }

    @Override
    public boolean removeRole(GeoServerRole role) throws IOException {
        if (this.filterRole(role) != null) {
            return this.delegateAsStore().removeRole(role);
        }
        return false;
    }

    @Override
    public void associateRoleToGroup(GeoServerRole role, String groupname) throws IOException {
        if (this.filterRole(role) != null && !this.filterGroup(groupname)) {
            this.delegateAsStore().associateRoleToGroup(role, groupname);
        }
    }

    @Override
    public void disAssociateRoleFromGroup(GeoServerRole role, String groupname) throws IOException {
        if (this.filterRole(role) != null && !this.filterGroup(groupname)) {
            this.delegateAsStore().disAssociateRoleFromGroup(role, groupname);
        }
    }

    @Override
    public void associateRoleToUser(GeoServerRole role, String username) throws IOException {
        if (this.filterRole(role) != null && !this.filterUser(username)) {
            this.delegateAsStore().associateRoleToUser(role, username);
        }
    }

    @Override
    public void disAssociateRoleFromUser(GeoServerRole role, String username) throws IOException {
        if (this.filterRole(role) != null && !this.filterUser(username)) {
            this.delegateAsStore().disAssociateRoleFromUser(role, username);
        }
    }

    @Override
    public void setParentRole(GeoServerRole role, GeoServerRole parentRole) throws IOException {
        if (this.filterRole(role) != null && this.filterRole(parentRole) != null) {
            this.delegateAsStore().setParentRole(role, parentRole);
        }
    }

    protected abstract SortedSet<String> filterGroups(GeoServerRole var1, SortedSet<String> var2);

    protected abstract boolean filterGroup(String var1);

    protected abstract SortedSet<String> filterUsers(GeoServerRole var1, SortedSet<String> var2);

    protected abstract boolean filterUser(String var1);

    protected abstract SortedSet<GeoServerRole> filterUserRoles(String var1, SortedSet<GeoServerRole> var2);

    protected abstract SortedSet<GeoServerRole> filterGroupRoles(String var1, SortedSet<GeoServerRole> var2);

    protected abstract SortedSet<GeoServerRole> filterRoles(SortedSet<GeoServerRole> var1);

    protected abstract Map<String, String> filterParentMappings(Map<String, String> var1);

    protected abstract GeoServerRole filterRole(GeoServerRole var1);
}

