/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.CatalogFilter;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.LayerGroupAccessLimits;
import org.geoserver.security.ResourceAccessManagerWrapper;
import org.geoserver.security.StyleAccessLimits;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.opengis.filter.Filter;
import org.springframework.security.core.Authentication;

public class CatalogFilterAccessManager
extends ResourceAccessManagerWrapper {
    private List<? extends CatalogFilter> filters;

    private DataAccessLimits hide(ResourceInfo info) {
        if (info instanceof FeatureTypeInfo) {
            return new VectorAccessLimits(CatalogMode.HIDE, null, (Filter)Filter.EXCLUDE, null, (Filter)Filter.EXCLUDE);
        }
        if (info instanceof CoverageInfo) {
            return new CoverageAccessLimits(CatalogMode.HIDE, (Filter)Filter.EXCLUDE, null, null);
        }
        if (info instanceof WMSLayerInfo) {
            return new WMSAccessLimits(CatalogMode.HIDE, (Filter)Filter.EXCLUDE, null, false);
        }
        return new DataAccessLimits(CatalogMode.HIDE, (Filter)Filter.EXCLUDE);
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer) {
        if (this.hideLayer(layer) || this.hideResource(layer.getResource())) {
            return this.hide(layer.getResource());
        }
        return super.getAccessLimits(user, layer);
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer, List<LayerGroupInfo> containers) {
        if (this.hideLayer(layer) || this.hideResource(layer.getResource())) {
            return this.hide(layer.getResource());
        }
        return super.getAccessLimits(user, layer, containers);
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, ResourceInfo resource) {
        if (this.hideResource(resource)) {
            return this.hide(resource);
        }
        return super.getAccessLimits(user, resource);
    }

    @Override
    public WorkspaceAccessLimits getAccessLimits(Authentication user, WorkspaceInfo workspace) {
        if (this.hideWorkspace(workspace)) {
            return new WorkspaceAccessLimits(CatalogMode.HIDE, false, false, false);
        }
        return super.getAccessLimits(user, workspace);
    }

    @Override
    public StyleAccessLimits getAccessLimits(Authentication user, StyleInfo style) {
        if (this.hideStyle(style)) {
            return new StyleAccessLimits(CatalogMode.HIDE);
        }
        return super.getAccessLimits(user, style);
    }

    @Override
    public LayerGroupAccessLimits getAccessLimits(Authentication user, LayerGroupInfo layerGroup) {
        if (this.hideLayerGroup(layerGroup)) {
            return new LayerGroupAccessLimits(CatalogMode.HIDE);
        }
        return super.getAccessLimits(user, layerGroup);
    }

    @Override
    public LayerGroupAccessLimits getAccessLimits(Authentication user, LayerGroupInfo layerGroup, List<LayerGroupInfo> containers) {
        if (this.hideLayerGroup(layerGroup)) {
            return new LayerGroupAccessLimits(CatalogMode.HIDE);
        }
        return super.getAccessLimits(user, layerGroup, containers);
    }

    private boolean hideResource(ResourceInfo resource) {
        for (CatalogFilter catalogFilter : this.getCatalogFilters()) {
            if (!catalogFilter.hideResource(resource)) continue;
            return true;
        }
        return false;
    }

    private boolean hideLayer(LayerInfo layer) {
        for (CatalogFilter catalogFilter : this.getCatalogFilters()) {
            if (!catalogFilter.hideLayer(layer)) continue;
            return true;
        }
        return false;
    }

    private boolean hideWorkspace(WorkspaceInfo workspace) {
        for (CatalogFilter catalogFilter : this.getCatalogFilters()) {
            if (!catalogFilter.hideWorkspace(workspace)) continue;
            return true;
        }
        return false;
    }

    private boolean hideStyle(StyleInfo style) {
        for (CatalogFilter catalogFilter : this.getCatalogFilters()) {
            if (!catalogFilter.hideStyle(style)) continue;
            return true;
        }
        return false;
    }

    private boolean hideLayerGroup(LayerGroupInfo layerGroup) {
        for (CatalogFilter catalogFilter : this.getCatalogFilters()) {
            if (!catalogFilter.hideLayerGroup(layerGroup)) continue;
            return true;
        }
        return false;
    }

    private List<? extends CatalogFilter> getCatalogFilters() {
        if (this.filters == null) {
            this.filters = GeoServerExtensions.extensions(CatalogFilter.class);
        }
        return this.filters;
    }

    public void setCatalogFilters(List<? extends CatalogFilter> filters) {
        this.filters = filters;
    }

    @Override
    public Filter getSecurityFilter(Authentication user, Class<? extends CatalogInfo> clazz) {
        if (this.filters == null || this.filters.isEmpty()) {
            return this.delegate.getSecurityFilter(user, clazz);
        }
        ArrayList<Filter> convertedFilters = new ArrayList<Filter>(this.filters.size() + 1);
        convertedFilters.add(this.delegate.getSecurityFilter(user, clazz));
        for (CatalogFilter catalogFilter : this.getCatalogFilters()) {
            convertedFilters.add(catalogFilter.getSecurityFilter(clazz));
        }
        return Predicates.and(convertedFilters.toArray(new Filter[convertedFilters.size()]));
    }
}

