/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geoserver.security.ConstantFilterChain;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityProvider;
import org.geoserver.security.HtmlLoginFilterChain;
import org.geoserver.security.LogoutFilterChain;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.ServiceLoginFilterChain;

public class GeoServerSecurityFilterChain
implements Serializable {
    private static final long serialVersionUID = 1L;
    List<RequestFilterChain> requestChains = new ArrayList<RequestFilterChain>();
    public static final List<String> REST_CHAIN_2_5 = Arrays.asList("/rest/**");
    public static final List<String> GWC_REST_CHAIN_2_5 = Arrays.asList("/gwc/rest/**");
    public static final String WEB_CHAIN = "/web/**";
    public static final String FORM_LOGIN_CHAIN = "/j_spring_security_check,/j_spring_security_check/,/login";
    public static final String FORM_LOGOUT_CHAIN = "/j_spring_security_logout,/j_spring_security_logout/,/logout";
    public static final String REST_CHAIN = "/rest.*,/rest/**";
    public static final String GWC_WEB_CHAIN = "/gwc/rest/web/**";
    public static final String GWC_REST_CHAIN = "/gwc/rest.*,/gwc/rest/**";
    public static final String DEFAULT_CHAIN = "/**";
    public static final String SECURITY_CONTEXT_ASC_FILTER = "contextAsc";
    public static final String SECURITY_CONTEXT_NO_ASC_FILTER = "contextNoAsc";
    public static final String ROLE_FILTER = "roleFilter";
    public static final String SSL_FILTER = "sslFilter";
    public static final String FORM_LOGIN_FILTER = "form";
    public static final String FORM_LOGOUT_FILTER = "formLogout";
    public static final String REMEMBER_ME_FILTER = "rememberme";
    public static final String ANONYMOUS_FILTER = "anonymous";
    public static final String BASIC_AUTH_FILTER = "basic";
    public static final String DYNAMIC_EXCEPTION_TRANSLATION_FILTER = "exception";
    public static final String GUI_EXCEPTION_TRANSLATION_FILTER = "guiException";
    public static final String FILTER_SECURITY_INTERCEPTOR = "interceptor";
    public static final String FILTER_SECURITY_REST_INTERCEPTOR = "restInterceptor";
    public static final String WEB_CHAIN_NAME = "web";
    public static final String WEB_LOGIN_CHAIN_NAME = "webLogin";
    public static final String WEB_LOGOUT_CHAIN_NAME = "webLogout";
    public static final String REST_CHAIN_NAME = "rest";
    public static final String GWC_CHAIN_NAME = "gwc";
    public static final String DEFAULT_CHAIN_NAME = "default";
    static HtmlLoginFilterChain WEB = new HtmlLoginFilterChain("/web/**", "/gwc/rest/web/**");
    private static ConstantFilterChain WEB_LOGIN;
    private static LogoutFilterChain WEB_LOGOUT;
    private static ServiceLoginFilterChain REST;
    private static ServiceLoginFilterChain GWC;
    private static ServiceLoginFilterChain DEFAULT;
    private static List<RequestFilterChain> INITIAL;

    public GeoServerSecurityFilterChain() {
        this.requestChains = new ArrayList<RequestFilterChain>();
    }

    public GeoServerSecurityFilterChain(List<RequestFilterChain> requestChains) {
        this.requestChains = requestChains;
    }

    public GeoServerSecurityFilterChain(GeoServerSecurityFilterChain other) {
        this.requestChains = new ArrayList<RequestFilterChain>(other.getRequestChains());
    }

    public static GeoServerSecurityFilterChain createInitialChain() {
        return new GeoServerSecurityFilterChain(new ArrayList<RequestFilterChain>(INITIAL));
    }

    public void postConfigure(GeoServerSecurityManager secMgr) {
        for (GeoServerSecurityProvider p : secMgr.lookupSecurityProviders()) {
            p.configureFilterChain(this);
        }
    }

    public static RequestFilterChain lookupRequestChainByName(String name, GeoServerSecurityManager secMgr) {
        GeoServerSecurityFilterChain filterChain = GeoServerSecurityFilterChain.createInitialChain();
        filterChain.postConfigure(secMgr);
        for (RequestFilterChain requestChain : filterChain.getRequestChains()) {
            if (!requestChain.getName().equals(name)) continue;
            return requestChain;
        }
        return null;
    }

    public static RequestFilterChain lookupRequestChainByPattern(String pattern, GeoServerSecurityManager secMgr) {
        GeoServerSecurityFilterChain filterChain = GeoServerSecurityFilterChain.createInitialChain();
        filterChain.postConfigure(secMgr);
        for (RequestFilterChain requestChain : filterChain.getRequestChains()) {
            if (!requestChain.getPatterns().contains(pattern)) continue;
            return requestChain;
        }
        return null;
    }

    public List<RequestFilterChain> getRequestChains() {
        return this.requestChains;
    }

    public List<RequestFilterChain> getVariableRequestChains() {
        ArrayList<RequestFilterChain> result = new ArrayList<RequestFilterChain>();
        for (RequestFilterChain chain : this.getRequestChains()) {
            if (chain.isConstant()) continue;
            result.add(chain);
        }
        return result;
    }

    public RequestFilterChain getRequestChainByName(String name) {
        for (RequestFilterChain requestChain : this.requestChains) {
            if (!requestChain.getName().equals(name)) continue;
            return requestChain;
        }
        return null;
    }

    public boolean insertFirst(String pattern, String filterName) {
        RequestFilterChain requestChain = this.findAndCheck(pattern, filterName);
        if (requestChain == null) {
            return false;
        }
        requestChain.getFilterNames().add(0, filterName);
        return false;
    }

    public boolean insertLast(String pattern, String filterName) {
        RequestFilterChain requestChain = this.findAndCheck(pattern, filterName);
        if (requestChain == null) {
            return false;
        }
        return requestChain.getFilterNames().add(filterName);
    }

    public boolean insertBefore(String pattern, String filterName, String positionName) {
        RequestFilterChain requestChain = this.findAndCheck(pattern, filterName);
        if (requestChain == null) {
            return false;
        }
        List<String> filterNames = requestChain.getFilterNames();
        int index = filterNames.indexOf(positionName);
        if (index == -1) {
            return false;
        }
        filterNames.add(index, filterName);
        return true;
    }

    public boolean insertAfter(String pattern, String filterName, String positionName) {
        RequestFilterChain requestChain = this.findAndCheck(pattern, filterName);
        if (requestChain == null) {
            return false;
        }
        List<String> filterNames = requestChain.getFilterNames();
        int index = filterNames.indexOf(positionName);
        if (index == -1) {
            return false;
        }
        filterNames.add(index + 1, filterName);
        return true;
    }

    public RequestFilterChain find(String pattern) {
        return this.requestChain(pattern);
    }

    public List<String> patternsForFilter(String filterName, boolean includeAll) {
        ArrayList<String> result = new ArrayList<String>();
        for (RequestFilterChain requestChain : this.requestChains) {
            List<String> filterNames = includeAll ? requestChain.getCompiledFilterNames() : requestChain.getFilterNames();
            if (!filterNames.contains(filterName)) continue;
            result.addAll(requestChain.getPatterns());
        }
        return result;
    }

    public List<String> filtersFor(String pattern) {
        RequestFilterChain requestChain = this.requestChain(pattern);
        if (requestChain == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<String>(requestChain.getFilterNames());
    }

    public boolean removeForPattern(String pattern) {
        RequestFilterChain requestChain = this.requestChain(pattern);
        if (requestChain != null) {
            return this.requestChains.remove(requestChain);
        }
        return false;
    }

    public boolean remove(String filterName) {
        boolean removed = false;
        for (RequestFilterChain requestChain : this.requestChains) {
            removed |= requestChain.getFilterNames().remove(filterName);
        }
        return removed;
    }

    RequestFilterChain findAndCheck(String pattern, String filterName) {
        RequestFilterChain requestChain = this.requestChain(pattern);
        if (requestChain == null) {
            return null;
        }
        if (requestChain.getFilterNames().contains(filterName)) {
            return null;
        }
        return requestChain;
    }

    RequestFilterChain requestChain(String pattern) {
        for (RequestFilterChain requestChain : this.requestChains) {
            if (!requestChain.getPatterns().contains(pattern)) continue;
            return requestChain;
        }
        return null;
    }

    static {
        WEB.setName(WEB_CHAIN_NAME);
        WEB.setFilterNames(REMEMBER_ME_FILTER, FORM_LOGIN_FILTER, ANONYMOUS_FILTER);
        WEB.setAllowSessionCreation(true);
        WEB_LOGIN = new ConstantFilterChain(FORM_LOGIN_CHAIN);
        WEB_LOGIN.setName(WEB_LOGIN_CHAIN_NAME);
        WEB_LOGIN.setFilterNames(FORM_LOGIN_FILTER);
        WEB_LOGIN.setAllowSessionCreation(true);
        WEB_LOGOUT = new LogoutFilterChain(FORM_LOGOUT_CHAIN);
        WEB_LOGOUT.setName(WEB_LOGOUT_CHAIN_NAME);
        WEB_LOGOUT.setFilterNames(FORM_LOGOUT_FILTER);
        REST = new ServiceLoginFilterChain(REST_CHAIN);
        REST.setName(REST_CHAIN_NAME);
        REST.setFilterNames(BASIC_AUTH_FILTER, ANONYMOUS_FILTER);
        REST.setInterceptorName(FILTER_SECURITY_REST_INTERCEPTOR);
        GWC = new ServiceLoginFilterChain(GWC_REST_CHAIN);
        GWC.setName(GWC_CHAIN_NAME);
        GWC.setFilterNames(BASIC_AUTH_FILTER);
        GWC.setInterceptorName(FILTER_SECURITY_REST_INTERCEPTOR);
        DEFAULT = new ServiceLoginFilterChain(DEFAULT_CHAIN);
        DEFAULT.setName(DEFAULT_CHAIN_NAME);
        DEFAULT.setFilterNames(BASIC_AUTH_FILTER, ANONYMOUS_FILTER);
        INITIAL = new ArrayList<RequestFilterChain>();
        INITIAL.add(WEB);
        INITIAL.add(WEB_LOGIN);
        INITIAL.add(WEB_LOGOUT);
        INITIAL.add(REST);
        INITIAL.add(GWC);
        INITIAL.add(DEFAULT);
    }
}

