/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.KeyStoreProvider;
import org.geoserver.security.SecurityUtils;
import org.geoserver.security.password.RandomPasswordProvider;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.BeanNameAware;

public class KeyStoreProviderImpl
implements BeanNameAware,
KeyStoreProvider {
    public static final String DEFAULT_BEAN_NAME = "DefaultKeyStoreProvider";
    public static final String DEFAULT_FILE_NAME = "geoserver.jceks";
    public static final String PREPARED_FILE_NAME = "geoserver.jceks.new";
    public static final String CONFIGPASSWORDKEY = "config:password:key";
    public static final String URLPARAMKEY = "url:param:key";
    public static final String USERGROUP_PREFIX = "ug:";
    public static final String USERGROUP_POSTFIX = ":key";
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    protected String name;
    protected Resource keyStoreResource;
    protected KeyStore ks;
    public static final String KEYSTORETYPE = "JCEKS";
    GeoServerSecurityManager securityManager;

    public void setBeanName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setSecurityManager(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public GeoServerSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public Resource getResource() {
        if (this.keyStoreResource == null) {
            this.keyStoreResource = this.securityManager.security().get(DEFAULT_FILE_NAME);
        }
        return this.keyStoreResource;
    }

    @Override
    public void reloadKeyStore() throws IOException {
        this.ks = null;
        this.assertActivatedKeyStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key getKey(String alias) throws IOException {
        this.assertActivatedKeyStore();
        char[] passwd = this.securityManager.getMasterPassword();
        try {
            Key key = this.ks.getKey(alias, passwd);
            this.securityManager.disposePassword(passwd);
            return key;
        }
        catch (Throwable throwable) {
            try {
                this.securityManager.disposePassword(passwd);
                throw throwable;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public byte[] getConfigPasswordKey() throws IOException {
        SecretKey key = this.getSecretKey(CONFIGPASSWORDKEY);
        if (key == null) {
            return null;
        }
        return key.getEncoded();
    }

    @Override
    public boolean hasConfigPasswordKey() throws IOException {
        return this.containsAlias(CONFIGPASSWORDKEY);
    }

    @Override
    public boolean containsAlias(String alias) throws IOException {
        this.assertActivatedKeyStore();
        try {
            return this.ks.containsAlias(alias);
        }
        catch (KeyStoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] getUserGroupKey(String serviceName) throws IOException {
        SecretKey key = this.getSecretKey(this.aliasForGroupService(serviceName));
        if (key == null) {
            return null;
        }
        return key.getEncoded();
    }

    @Override
    public boolean hasUserGroupKey(String serviceName) throws IOException {
        return this.containsAlias(this.aliasForGroupService(serviceName));
    }

    @Override
    public SecretKey getSecretKey(String name) throws IOException {
        Key key = this.getKey(name);
        if (key == null) {
            return null;
        }
        if (!(key instanceof SecretKey)) {
            throw new IOException("Invalid key type for: " + name);
        }
        return (SecretKey)key;
    }

    @Override
    public PublicKey getPublicKey(String name) throws IOException {
        Key key = this.getKey(name);
        if (key == null) {
            return null;
        }
        if (!(key instanceof PublicKey)) {
            throw new IOException("Invalid key type for: " + name);
        }
        return (PublicKey)key;
    }

    @Override
    public PrivateKey getPrivateKey(String name) throws IOException {
        Key key = this.getKey(name);
        if (key == null) {
            return null;
        }
        if (!(key instanceof PrivateKey)) {
            throw new IOException("Invalid key type for: " + name);
        }
        return (PrivateKey)key;
    }

    @Override
    public String aliasForGroupService(String serviceName) {
        StringBuffer buff = new StringBuffer(USERGROUP_PREFIX);
        buff.append(serviceName);
        buff.append(USERGROUP_POSTFIX);
        return buff.toString();
    }

    protected void assertActivatedKeyStore() throws IOException {
        block20: {
            if (this.ks != null) {
                return;
            }
            char[] passwd = this.securityManager.getMasterPassword();
            try {
                this.ks = KeyStore.getInstance(KEYSTORETYPE);
                if (this.getResource().getType() == Resource.Type.UNDEFINED) {
                    this.ks.load(null, passwd);
                    this.addInitialKeys();
                    try (OutputStream fos = this.getResource().out();){
                        this.ks.store(fos, passwd);
                        break block20;
                    }
                }
                try (InputStream fis = this.getResource().in();){
                    this.ks.load(fis, passwd);
                }
            }
            catch (Exception ex) {
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw new IOException(ex);
            }
            finally {
                this.securityManager.disposePassword(passwd);
            }
        }
    }

    @Override
    public boolean isKeyStorePassword(char[] password) throws IOException {
        if (password == null) {
            return false;
        }
        this.assertActivatedKeyStore();
        KeyStore testStore = null;
        try {
            testStore = KeyStore.getInstance(KEYSTORETYPE);
        }
        catch (KeyStoreException e1) {
            throw new RuntimeException(e1);
        }
        try (InputStream fis = this.getResource().in();){
            testStore.load(fis, password);
        }
        catch (IOException e2) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public void setSecretKey(String alias, char[] key) throws IOException {
        this.assertActivatedKeyStore();
        SecretKeySpec mySecretKey = new SecretKeySpec(SecurityUtils.toBytes(key), "PBE");
        KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(mySecretKey);
        char[] passwd = this.securityManager.getMasterPassword();
        try {
            this.ks.setEntry(alias, skEntry, new KeyStore.PasswordProtection(passwd));
        }
        catch (KeyStoreException e) {
            throw new IOException(e);
        }
        finally {
            this.securityManager.disposePassword(passwd);
        }
    }

    @Override
    public void setUserGroupKey(String serviceName, char[] password) throws IOException {
        String alias = this.aliasForGroupService(serviceName);
        this.setSecretKey(alias, password);
    }

    @Override
    public void removeKey(String alias) throws IOException {
        this.assertActivatedKeyStore();
        try {
            this.ks.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void storeKeyStore() throws IOException {
        this.assertActivatedKeyStore();
        try (OutputStream fos = this.getResource().out();){
            char[] passwd = this.securityManager.getMasterPassword();
            try {
                this.ks.store(fos, passwd);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                this.securityManager.disposePassword(passwd);
            }
        }
    }

    protected void addInitialKeys() throws IOException {
        RandomPasswordProvider randPasswdProvider = this.getSecurityManager().getRandomPassworddProvider();
        char[] configKey = randPasswdProvider.getRandomPasswordWithDefaultLength();
        this.setSecretKey(CONFIGPASSWORDKEY, configKey);
    }

    @Override
    public void prepareForMasterPasswordChange(char[] oldPassword, char[] newPassword) throws IOException {
        Resource dir = this.getResource().parent();
        Resource newKSFile = dir.get(PREPARED_FILE_NAME);
        if (newKSFile.getType() != Resource.Type.UNDEFINED) {
            newKSFile.delete();
        }
        try {
            KeyStore oldKS = KeyStore.getInstance(KEYSTORETYPE);
            try (InputStream fin = this.getResource().in();){
                oldKS.load(fin, oldPassword);
            }
            KeyStore newKS = KeyStore.getInstance(KEYSTORETYPE);
            newKS.load(null, newPassword);
            KeyStore.PasswordProtection protectionparam = new KeyStore.PasswordProtection(newPassword);
            Enumeration<String> enumeration = oldKS.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                Key key = oldKS.getKey(alias, oldPassword);
                KeyStore.Entry entry = null;
                if (key instanceof SecretKey) {
                    entry = new KeyStore.SecretKeyEntry((SecretKey)key);
                }
                if (key instanceof PrivateKey) {
                    entry = new KeyStore.PrivateKeyEntry((PrivateKey)key, oldKS.getCertificateChain(alias));
                }
                if (key instanceof PublicKey) {
                    entry = new KeyStore.TrustedCertificateEntry(oldKS.getCertificate(alias));
                }
                if (entry == null) {
                    LOGGER.warning("Unknown key in store, alias: " + alias + " class: " + key.getClass().getName());
                    continue;
                }
                newKS.setEntry(alias, entry, protectionparam);
            }
            try (OutputStream fos = newKSFile.out();){
                newKS.store(fos, newPassword);
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void abortMasterPasswordChange() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commitMasterPasswordChange() throws IOException {
        Resource dir = this.getResource().parent();
        Resource newKSFile = dir.get(PREPARED_FILE_NAME);
        Resource oldKSFile = dir.get(DEFAULT_FILE_NAME);
        if (newKSFile.getType() == Resource.Type.UNDEFINED) {
            return;
        }
        if (oldKSFile.getType() == Resource.Type.UNDEFINED) {
            return;
        }
        InputStream fin = newKSFile.in();
        char[] passwd = this.securityManager.getMasterPassword();
        try {
            KeyStore newKS = KeyStore.getInstance(KEYSTORETYPE);
            newKS.load(fin, passwd);
            Enumeration<String> enumeration = newKS.aliases();
            while (enumeration.hasMoreElements()) {
                newKS.getKey(enumeration.nextElement(), passwd);
            }
            fin.close();
            fin = null;
            if (!oldKSFile.delete()) {
                LOGGER.severe("cannot delete " + oldKSFile.path());
                return;
            }
            if (!newKSFile.renameTo(oldKSFile)) {
                String msg = "cannot rename " + newKSFile.path();
                msg = msg + "to " + oldKSFile.path();
                msg = msg + "Try to rename manually and restart";
                LOGGER.severe(msg);
                return;
            }
            this.reloadKeyStore();
            LOGGER.info("Successfully changed master password");
            return;
        }
        catch (IOException e) {
            String msg = "Error creating new keystore: " + newKSFile.path();
            LOGGER.log(Level.WARNING, msg, e);
            throw e;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.securityManager.disposePassword(passwd);
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

