/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geotools.util.logging.Logging;

public class SecuredResourceNameChangeListener
implements CatalogListener {
    static final Logger LOGGER = Logging.getLogger(SecuredResourceNameChangeListener.class);
    Catalog catalog;
    DataAccessRuleDAO dao;

    public SecuredResourceNameChangeListener(Catalog catalog, DataAccessRuleDAO dao) {
        this.catalog = catalog;
        this.dao = dao;
        catalog.addListener(this);
    }

    @Override
    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
    }

    @Override
    public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
        String resourceWorkSpaceName = null;
        CatalogInfo resourceInfo = event.getSource();
        String resourceName = null;
        if (resourceInfo instanceof LayerInfo) {
            resourceWorkSpaceName = ((LayerInfo)resourceInfo).getResource().getStore().getWorkspace().getName();
            resourceName = ((LayerInfo)resourceInfo).getName();
        } else if (event.getSource() instanceof LayerGroupInfo) {
            resourceWorkSpaceName = ((LayerGroupInfo)resourceInfo).getWorkspace().getName();
            resourceName = ((LayerGroupInfo)resourceInfo).getName();
        }
        if (resourceWorkSpaceName != null && resourceInfo != null && this.layerHasSecurityRule(resourceWorkSpaceName, resourceName)) {
            LOGGER.info(String.format("Removing Security Rules for removed layer: %s", resourceName));
            List<DataAccessRule> rulesToRemove = this.getDataAccessRule(resourceInfo, resourceName);
            for (DataAccessRule r : rulesToRemove) {
                this.dao.removeRule(r);
            }
            try {
                this.dao.storeRules();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                throw new CatalogException(e);
            }
        }
    }

    @Override
    public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
    }

    @Override
    public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        List<DataAccessRule> rulesToModifyList;
        String newName;
        if (event.getPropertyNames().indexOf("name") == -1) {
            return;
        }
        String oldName = String.valueOf(event.getOldValues().get(event.getPropertyNames().indexOf("name")));
        if (oldName.equalsIgnoreCase(newName = String.valueOf(event.getNewValues().get(event.getPropertyNames().indexOf("name"))))) {
            return;
        }
        String resourceWorkSpaceName = null;
        CatalogInfo resourceInfo = null;
        if (event.getSource() instanceof WorkspaceInfo) {
            if (this.workspaceHasSecurityRule(oldName)) {
                LOGGER.info(String.format("Updating Security Rules for Renamed Workspace: %s", oldName));
                rulesToModifyList = this.getDataAccessRule(event.getSource(), oldName);
                for (DataAccessRule rule : rulesToModifyList) {
                    rule.setRoot(newName);
                }
            }
        } else if (event.getSource() instanceof ResourceInfo) {
            resourceInfo = event.getSource();
            resourceWorkSpaceName = ((ResourceInfo)resourceInfo).getStore().getWorkspace().getName();
        } else if (event.getSource() instanceof LayerGroupInfo) {
            resourceInfo = event.getSource();
            resourceWorkSpaceName = ((LayerGroupInfo)resourceInfo).getWorkspace().getName();
        }
        if (resourceWorkSpaceName != null && resourceInfo != null && this.layerHasSecurityRule(resourceWorkSpaceName, oldName)) {
            LOGGER.info(String.format("Updating Security Rules for Renamed Feature Type: %s", oldName));
            rulesToModifyList = this.getDataAccessRule(resourceInfo, oldName);
            for (DataAccessRule rule : rulesToModifyList) {
                rule.setLayer(newName);
            }
        }
        try {
            this.dao.storeRules();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void reloaded() {
    }

    private boolean workspaceHasSecurityRule(String workspaceName) {
        List rules = this.dao.getRules();
        for (DataAccessRule rule : rules) {
            if (!rule.getRoot().equalsIgnoreCase(workspaceName)) continue;
            return true;
        }
        return false;
    }

    private boolean layerHasSecurityRule(String workspaceName, String layerName) {
        List rules = this.dao.getRules();
        for (DataAccessRule rule : rules) {
            if (!rule.getRoot().equalsIgnoreCase(workspaceName) || !rule.getLayer().equalsIgnoreCase(layerName)) continue;
            return true;
        }
        return false;
    }

    private List<DataAccessRule> getDataAccessRule(CatalogInfo catalogInfo, String oldName) {
        List rules = this.dao.getRules();
        ArrayList<DataAccessRule> rulesToUpdate = new ArrayList<DataAccessRule>();
        for (DataAccessRule rule : rules) {
            String workspaceName;
            CatalogInfo resourceInfo;
            if (catalogInfo instanceof WorkspaceInfo) {
                if (!rule.getRoot().equalsIgnoreCase(oldName)) continue;
                rulesToUpdate.add(rule);
                continue;
            }
            if (catalogInfo instanceof ResourceInfo) {
                resourceInfo = (ResourceInfo)catalogInfo;
                workspaceName = resourceInfo.getStore().getWorkspace().getName();
                if (!rule.getRoot().equalsIgnoreCase(workspaceName) || !rule.getLayer().equalsIgnoreCase(oldName)) continue;
                rulesToUpdate.add(rule);
                continue;
            }
            if (catalogInfo instanceof LayerGroupInfo) {
                resourceInfo = (LayerGroupInfo)catalogInfo;
                workspaceName = resourceInfo.getWorkspace().getName();
                if (!rule.getRoot().equalsIgnoreCase(workspaceName) || !rule.getLayer().equalsIgnoreCase(oldName)) continue;
                rulesToUpdate.add(rule);
                continue;
            }
            if (!(catalogInfo instanceof LayerInfo)) continue;
            resourceInfo = (LayerInfo)catalogInfo;
            workspaceName = resourceInfo.getResource().getStore().getWorkspace().getName();
            if (!rule.getRoot().equalsIgnoreCase(workspaceName) || !rule.getLayer().equalsIgnoreCase(oldName)) continue;
            rulesToUpdate.add(rule);
        }
        return rulesToUpdate;
    }
}

