/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.Arrays;
import org.geoserver.security.AccessLevel;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.password.RandomPasswordProvider;
import org.geotools.data.Query;
import org.opengis.filter.Filter;
import org.springframework.security.core.userdetails.UserDetails;

public class SecurityUtils {
    public static boolean isSecurityException(Throwable t) {
        return t != null && t.getClass().getPackage().getName().startsWith("org.springframework.security");
    }

    public static byte[] toBytes(char[] ch) {
        return SecurityUtils.toBytes(ch, Charset.defaultCharset());
    }

    public static byte[] toBytes(char[] ch, String charset) {
        return SecurityUtils.toBytes(ch, Charset.forName(charset));
    }

    public static byte[] toBytes(char[] ch, Charset charset) {
        ByteBuffer buff = charset.encode(CharBuffer.wrap(ch));
        byte[] tmp = new byte[buff.limit()];
        buff.get(tmp);
        return tmp;
    }

    public static char[] toChars(byte[] b) {
        return SecurityUtils.toChars(b, Charset.defaultCharset());
    }

    public static char[] toChars(byte[] b, String charset) {
        return SecurityUtils.toChars(b, Charset.forName(charset));
    }

    public static char[] toChars(byte[] b, Charset charset) {
        CharBuffer buff = charset.decode(ByteBuffer.wrap(b));
        char[] tmp = new char[buff.limit()];
        buff.get(tmp);
        return tmp;
    }

    public static void scramble(char[] ch) {
        if (ch == null) {
            return;
        }
        RandomPasswordProvider rpp = new RandomPasswordProvider();
        rpp.getRandomPassword(ch);
    }

    public static void scramble(byte[] ch) {
        if (ch == null) {
            return;
        }
        RandomPasswordProvider rpp = new RandomPasswordProvider();
        rpp.getRandomPassword(ch);
    }

    public static Query getWriteQuery(WrapperPolicy policy) {
        if (policy.getAccessLevel() != AccessLevel.READ_WRITE) {
            return new Query(null, (Filter)Filter.EXCLUDE);
        }
        if (policy.getLimits() == null) {
            return Query.ALL;
        }
        if (policy.getLimits() instanceof VectorAccessLimits) {
            VectorAccessLimits val = (VectorAccessLimits)policy.getLimits();
            return val.getWriteQuery();
        }
        throw new IllegalArgumentException("SecureFeatureStore has been fed with unexpected AccessLimits class " + policy.getLimits().getClass());
    }

    public static int[] createInverse(int[] perm) {
        int[] inverse = new int[perm.length];
        for (int i = 0; i < perm.length; ++i) {
            inverse[perm[i]] = i;
        }
        return inverse;
    }

    public static char[] permute(char[] base, int times, int[] perm) {
        char[][] working = new char[2][base.length];
        System.arraycopy(base, 0, working[0], 0, base.length);
        for (int j = 0; j < times; ++j) {
            int source = j % 2;
            int target = (j + 1) % 2;
            for (int i = 0; i < working[source].length; ++i) {
                working[target][perm[i]] = working[source][i];
            }
        }
        char[] result = (char[])working[1].clone();
        Arrays.fill(working[0], '0');
        Arrays.fill(working[1], '0');
        return result;
    }

    public static String getUsername(Object principal) {
        String username = null;
        if (principal != null) {
            username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : (principal instanceof Principal ? ((Principal)principal).getName() : principal.toString());
        }
        return username;
    }
}

