/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.UsernamePasswordAuthenticationProviderConfig;
import org.geoserver.security.filter.GeoServerWebAuthenticationDetails;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.password.GeoServerMultiplexingPasswordEncoder;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;

public class UsernamePasswordAuthenticationProvider
extends GeoServerAuthenticationProvider {
    DaoAuthenticationProvider authProvider;
    String userGroupServiceName;

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        UsernamePasswordAuthenticationProviderConfig upAuthConfig = (UsernamePasswordAuthenticationProviderConfig)config;
        GeoServerUserGroupService ugService = this.getSecurityManager().loadUserGroupService(upAuthConfig.getUserGroupServiceName());
        if (ugService == null) {
            throw new IllegalArgumentException("Unable to load user group service " + upAuthConfig.getUserGroupServiceName());
        }
        this.userGroupServiceName = upAuthConfig.getUserGroupServiceName();
        this.authProvider = new DaoAuthenticationProvider();
        this.authProvider.setUserDetailsService((UserDetailsService)ugService);
        this.authProvider.setPasswordEncoder((PasswordEncoder)new GeoServerMultiplexingPasswordEncoder(this.getSecurityManager(), ugService));
        try {
            this.authProvider.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean supports(Class<? extends Object> authentication, HttpServletRequest request) {
        return this.authProvider.supports(authentication);
    }

    @Override
    public Authentication authenticate(Authentication authentication, HttpServletRequest request) throws AuthenticationException {
        UsernamePasswordAuthenticationToken auth = null;
        try {
            auth = (UsernamePasswordAuthenticationToken)this.authProvider.authenticate(authentication);
        }
        catch (AuthenticationException ex) {
            this.log(ex);
            return null;
        }
        if (auth == null) {
            return null;
        }
        if (auth.getDetails() instanceof GeoServerWebAuthenticationDetails) {
            ((GeoServerWebAuthenticationDetails)((Object)auth.getDetails())).setUserGroupServiceName(this.userGroupServiceName);
        }
        if (!auth.getAuthorities().contains(GeoServerRole.AUTHENTICATED_ROLE)) {
            ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
            roles.addAll(auth.getAuthorities());
            roles.add(GeoServerRole.AUTHENTICATED_ROLE);
            UsernamePasswordAuthenticationToken newAuth = new UsernamePasswordAuthenticationToken(auth.getPrincipal(), auth.getCredentials(), roles);
            newAuth.setDetails(auth.getDetails());
            return newAuth;
        }
        return auth;
    }
}

