/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.security.AccessLevel;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingCoverageInfo;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.util.ProgressListener;

public class SecuredCoverageInfo
extends DecoratingCoverageInfo {
    WrapperPolicy policy;

    public SecuredCoverageInfo(CoverageInfo delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    @Override
    public GridCoverage getGridCoverage(ProgressListener listener, Hints hints) throws IOException {
        if (this.policy.level == AccessLevel.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        GridCoverageReader reader = this.getGridCoverageReader(listener, hints);
        return this.getCatalog().getResourcePool().getGridCoverage((CoverageInfo)this, reader, null, hints);
    }

    @Override
    public GridCoverage getGridCoverage(ProgressListener listener, ReferencedEnvelope envelope, Hints hints) throws IOException {
        if (this.policy.level == AccessLevel.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        GridCoverageReader reader = this.getGridCoverageReader(listener, hints);
        return this.getCatalog().getResourcePool().getGridCoverage((CoverageInfo)this, reader, envelope, hints);
    }

    @Override
    public GridCoverageReader getGridCoverageReader(ProgressListener listener, Hints hints) throws IOException {
        Request request = (Request)Dispatcher.REQUEST.get();
        if (this.policy.level == AccessLevel.METADATA && (request == null || !"GetCapabilities".equalsIgnoreCase(request.getRequest()) && !"DescribeCoverage".equalsIgnoreCase(request.getRequest()))) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        GridCoverageReader reader = super.getGridCoverageReader(listener, hints);
        return (GridCoverageReader)SecuredObjects.secure(reader, this.policy);
    }

    @Override
    public CoverageStoreInfo getStore() {
        return (CoverageStoreInfo)SecuredObjects.secure(super.getStore(), this.policy);
    }

    @Override
    public void setStore(StoreInfo store) {
        super.setStore((StoreInfo)SecureCatalogImpl.unwrap((Object)store));
    }
}

