/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.security.AccessLevel;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingFeatureTypeInfo;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.factory.Hints;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.util.ProgressListener;

public class SecuredFeatureTypeInfo
extends DecoratingFeatureTypeInfo {
    WrapperPolicy policy;

    public SecuredFeatureTypeInfo(FeatureTypeInfo info, WrapperPolicy policy) {
        super(info);
        this.policy = policy;
    }

    @Override
    public FeatureType getFeatureType() throws IOException {
        FeatureType ft = super.getFeatureType();
        if (this.policy.getLimits() == null) {
            return ft;
        }
        if (this.policy.getLimits() instanceof VectorAccessLimits) {
            VectorAccessLimits val = (VectorAccessLimits)this.policy.getLimits();
            Query query = val.getReadQuery();
            if (query.getPropertyNames() == Query.ALL_NAMES) {
                return ft;
            }
            if (ft instanceof SimpleFeatureType) {
                SimpleFeatureType sft = (SimpleFeatureType)ft;
                HashSet<String> properties = new HashSet<String>(Arrays.asList(query.getPropertyNames()));
                SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
                tb.init(sft);
                for (AttributeDescriptor at : sft.getAttributeDescriptors()) {
                    String attName = at.getLocalName();
                    if (properties.contains(attName)) continue;
                    tb.remove(attName);
                }
                return tb.buildFeatureType();
            }
            query.setFilter((Filter)Filter.EXCLUDE);
            FeatureSource fs = this.getFeatureSource(null, null);
            FeatureCollection fc = fs.getFeatures(query);
            return fc.getSchema();
        }
        throw new IllegalArgumentException("SecureFeatureSources has been fed with unexpected AccessLimits class " + this.policy.getLimits().getClass());
    }

    @Override
    public FeatureSource getFeatureSource(ProgressListener listener, Hints hints) throws IOException {
        FeatureSource<? extends FeatureType, ? extends Feature> fs = ((FeatureTypeInfo)this.delegate).getFeatureSource(listener, hints);
        if (this.policy.level == AccessLevel.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        return (FeatureSource)SecuredObjects.secure(fs, this.policy);
    }

    @Override
    public DataStoreInfo getStore() {
        return (DataStoreInfo)SecuredObjects.secure(((FeatureTypeInfo)this.delegate).getStore(), this.policy);
    }

    @Override
    public void setStore(StoreInfo store) {
        super.setStore((StoreInfo)SecureCatalogImpl.unwrap((Object)store));
    }
}

