/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.security.AccessLevel;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingWMSStoreInfo;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.ows.wms.WebMapServer;
import org.opengis.util.ProgressListener;

public class SecuredWMSStoreInfo
extends DecoratingWMSStoreInfo {
    WrapperPolicy policy;

    public SecuredWMSStoreInfo(WMSStoreInfo delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    @Override
    public WebMapServer getWebMapServer(ProgressListener listener) throws IOException {
        WebMapServer wms = super.getWebMapServer(null);
        if (wms == null) {
            return null;
        }
        if (this.policy.level == AccessLevel.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        return (WebMapServer)SecuredObjects.secure(wms, this.policy);
    }
}

